package tomcatbook.customtag;

import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.*;

/**
 * Basic JSP tag.
 *
 *
 * @author Rick Hightower
 * @created July 29, 2002
 * @version 1.0
 *
 * @jsp:tag name="BasicTag"
 *
 * @jsp:variable name-given="currentIter"
 * class="java.lang.Integer" scope="NESTED"
 * @jsp:variable name-given="atBegin"
 * class="java.lang.Integer" scope="AT_BEGIN"
 * @jsp:variable name-given="atEnd"
 * class="java.lang.Integer" scope="AT_END"
 */
public class BasicTag extends TagSupport {

  /** Contient la valeur de la proprit includePage. */
  private boolean includePage;

  /** Contient la valeur de la proprit includeBody. */
  private boolean includeBody;

  /** Contient la valeur de la proprit iterate. */
  private int iterate;

  public int doStartTag() {
    pageContext.setAttribute("currentIter", new Integer(0));
    pageContext.setAttribute("atBegin", new Integer(0));
    return this.includeBody ? EVAL_BODY_INCLUDE : SKIP_BODY;
  }

  public int doEndTag() {
    pageContext.setAttribute("atEnd", new Integer(iterate));
    return this.includePage ? EVAL_PAGE : SKIP_PAGE;
  }

  public int doAfterBody() {
    this.iterate -= 1;
    pageContext.setAttribute("currentIter", new Integer(iterate));
    if (iterate <= 0)
      return SKIP_BODY;
    else
      return EVAL_BODY_AGAIN;
  }

  /** Getter de la proprit includePage.
   * @return Value of property includePage.
   * @jsp:attribute required="true"
   * rtexprvalue="true"
   * description="The includePage attribute"
   */
  public boolean isIncludePage() {
    return this.includePage;
  }

  /** Setter de la proprit includePage.
   * @param includePage New value of property includePage.
   *
   */
  public void setIncludePage(boolean includePage) {
    this.includePage = includePage;
  }

  /** Getter de la proprit includeBody.
   * @return Value of property includeBody.
   * @jsp:attribute required="true"
   * rtexprvalue="true"
   * description="The includeBody attribute"
   */
  public boolean isIncludeBody() {
    return this.includeBody;
  }

  /** Setter de la proprit includeBody.
   * @param includeBody New value of property includeBody.
   */
  public void setIncludeBody(boolean includeBody) {
    this.includeBody = includeBody;
  }

  /** Getter de la proprit iterate.
   * @return Value of property iterate.
   * @jsp:attribute required="true"
   * rtexprvalue="true"
   * description="The iterate attribute"
   */
  public int getIterate() {
    return this.iterate;
  }

  /** Setter de la proprit iterate.
   * @param iterate New value of property iterate.
   */
  public void setIterate(int iterate) {
    this.iterate = iterate;
  }
}
