package xptoolkit.applet;
import javax.swing.JApplet;
import javax.swing.JLabel;
import java.awt.Font;
import java.awt.BorderLayout;
import java.applet.AppletContext;
import java.net.URL;
import java.io.InputStreamReader;
import java.io.BufferedReader;

public class HelloWorldApplet extends javax.swing.JApplet {

    JLabel text;

    public HelloWorldApplet() {
      this.getContentPane().setLayout(new BorderLayout());
      text = new JLabel("Bye Bye");
      text.setAlignmentX(JLabel.CENTER_ALIGNMENT);
      text.setAlignmentY(JLabel.CENTER_ALIGNMENT);
      Font f = new Font("Arial", Font.BOLD, 20);
      text.setFont(f);
      getContentPane().add(text,BorderLayout.CENTER);
    }

    public void init(){
      URL uGreeting;
      String sGreeting="Bye Bye";

      this.doLayout();
      getAppletContext()
  .showStatus("Lecture du message sur le serveur.");

    try{
      uGreeting = new URL(
        this.getDocumentBase(),
        "HelloWorldServlet");
       sGreeting = getGreeting(uGreeting);
    }
    catch(Exception e){
      getAppletContext()
  .showStatus("Impossible de joindre le serveur.");
      e.printStackTrace();
    }
    text.setText(sGreeting);

  }
  private String getGreeting(URL uGreeting)throws Exception{
    String line;
    int endTagIndex;
    BufferedReader reader=null;

    try{
      reader = new BufferedReader(
        new InputStreamReader (
          uGreeting.openStream()));
      while((line=reader.readLine())!=null){
        System.out.println(line);
        if (line.startsWith("<h1>")){
          getAppletContext().showStatus("Analyse du message.");
          endTagIndex=line.indexOf("</h1>");
          line=line.substring(4,endTagIndex);
          break;
        }
      }
    }
    finally{
      if (reader!=null)reader.close();
    }
    return line;
  }
}
