import java.awt.event.*; import java.util.*; import java.awt.*; import java.io.*; import java.net.*; /**  *  * ExpliciteClient  * <BR><BR>  * Client pour le Serveur Explicite  */  public class ExpliciteClient extends Thread {     private Thread thrThis;         // Thread de client     private Socket socket;          // socket pour la connection     private ExpliciteServeur Serveur;      // server auquel le client est connect     private String ip;              // l'ip du client     protected BufferedReader in;    // buffer de capture les messages entrants     protected PrintWriter out;      // buffer de messages sortant      /**      * Constructeur pour ExpliciteClient.  Initialise les proprits du ExpliciteClient .      * paramtre   serveur    Le serveur auquel le client est connect      * paramtre   socket    La socket a par laquelle le client est connecte     */     public ExpliciteClient(ExpliciteServeur Serveur, Socket socket) {         this.Serveur = Serveur;     
     this.socket = socket;         this.ip = socket.getInetAddress().getHostAddress();                   try {             in = new BufferedReader(new InputStreamReader(socket.getInputStream()));             out = new PrintWriter(socket.getOutputStream(), true);         } catch(IOException ioe) {             Serveur.writeActivite("Client IP: " + ip + " ne peut pas tre "  + "initialis et a t dconnect.");             killClient();         }     }      /**      * mthode run du thread.     */	     public void run() {         try {             char charBuffer[] = new char[1];                          // --- tant que nous avons un flux             while(in.read(charBuffer,0,1) != -1) {                  // --- nous crons un buffer                 StringBuffer stringBuffer = new StringBuffer(8192);                              // ---tant que le flux n'est pas termin                 while(charBuffer[0] != '\0') {                     // --- on ajoute le caractre au buffer    
                  stringBuffer.append(charBuffer[0]);                     in.read(charBuffer, 0 ,1);                 }                                  // --- broadcast le message                 Serveur.broadcastMessage(stringBuffer.toString());             }         } catch(IOException ioe) {             Serveur.writeActivite("Client IP: " + ip + " a caus une erreur "              + "et a dt tre dconnect.");         } finally {             killClient();         }     }      /**      * Donne l'ip du client.      *      */     public String getIP() {         return ip;     }          /**      * Envois un message au client. utilis par la mthode de broadcast du serveur      * paramtre : message. Le message  envoyer     */     public void send(String message) {         // ---met le message dans le buffer de sortie         out.print(message);                  // --- vide le buffer et regarde si y'a des erreurs         // --- si oui, on kill le client         if(out.check
 Error()) {             Serveur.writeActivite("Client IP: " + ip + "a caus une erreur d'criture "             + "et a dut tre deconnect.");             killClient();         }     }       /**      * Kill les clients.      */        private void killClient() {         // --- dit au serveur de retirer le client de la liste des clients             Serveur.removeClient(this);          // --- ferme les conenctions correcpondantes.         try {             socket.close();             in.close();             out.close();             thrThis = null;         } catch (IOException ioe) {             Serveur.writeActivite("Client IP: " + ip + " a caus une erreur "             + "et doit tre deconnect.");         }            } }