
delimiter $

--
DROP TABLE IF EXISTS test.Trace$
CREATE TABLE test.Trace(message VARCHAR(80))$

--

DROP PROCEDURE IF EXISTS installLogSeg$

CREATE PROCEDURE installLogSeg (IN param1 VARCHAR(11), IN param2 VARCHAR(5),IN param3 VARCHAR(20), 
 IN param4 TIMESTAMP, IN param5 VARCHAR(7), IN param6 VARCHAR(9), IN param7 DECIMAL(6,2))
BEGIN
 DECLARE fincurs    BOOLEAN DEFAULT 0;
 DECLARE doublonTrouve  BOOLEAN DEFAULT 0;
 DECLARE pereInexistant BOOLEAN DEFAULT 0;
 DECLARE nbrInstall TINYINT DEFAULT 0;
 DECLARE v_nomSeg   VARCHAR(20);
 DECLARE v_nomPoste VARCHAR(20);
 DECLARE v_nomSalle VARCHAR(20);
 DECLARE v_nPoste   VARCHAR(7); 
 DECLARE curseur    CURSOR FOR 
         SELECT     p.nomPoste,p.nPoste,s.nomSalle
                    FROM  Poste p, Salle s
                    WHERE p.indIP  = param1 AND p.typePoste = param6
                    AND p.nSalle = s.nSalle;
 DECLARE CONTINUE HANDLER FOR NOT FOUND SET fincurs  := 1;
 DECLARE CONTINUE HANDLER FOR 1062 SET doublonTrouve := 1;
 DECLARE CONTINUE HANDLER FOR 1452 SET pereInexistant := 1;

 --  numro de segment inconnu?
 SELECT nomSegment INTO v_nomSeg FROM Segment WHERE indIP=param1;
 IF (fincurs) THEN
    INSERT INTO test.Trace VALUES (CONCAT('Mauvais code segment : ',param1));
 ELSE
 --  numro de logiciel dj prsent ?

  SET AUTOCOMMIT = 0;
  INSERT INTO Logiciel VALUES (param2,param3,param4,param5,param6,param7,0);
  IF (doublonTrouve) THEN
     INSERT INTO test.Trace VALUES (CONCAT('Logiciel : ',param2,' dj prsent!'));
  ELSE
    IF (pereInexistant) THEN
     INSERT INTO test.Trace VALUES (CONCAT('Type du logiciel : ',param6,' non rfrenc!'));
    ELSE
     IF (DATEDIFF(SYSDATE(),param4)<0) THEN
      INSERT INTO test.Trace VALUES (CONCAT('Date achat plus grande que celle du jour!'));
     ELSE
      INSERT INTO test.Trace VALUES (CONCAT(param3,' stock dans la table Logiciel'));
      OPEN curseur;
      FETCH curseur INTO v_nomPoste,v_nPoste,v_nomSalle;
      WHILE (NOT fincurs) DO
	SET nbrInstall := nbrInstall +1;
        INSERT INTO Installer (nPoste,nLog,delai)  
              VALUES(v_nPoste, param2, TIMESTAMPDIFF(SECOND,param4,SYSDATE())/(24*3600) );
        INSERT INTO test.Trace VALUES (CONCAT('Installation sur ',v_nomPoste,' dans ',v_nomSalle));
        FETCH curseur INTO v_nomPoste,v_nPoste,v_nomSalle;
      END WHILE;
      IF (nbrInstall=0) THEN
       INSERT INTO test.Trace VALUES (CONCAT('Aucune installation sur le segment',param1,' de ',param2));
      END IF;
      CLOSE curseur;
 --     COMMIT;
     END IF;
    END IF;
  END IF;
 END IF;
 SELECT * FROM test.Trace;
END;
$

--test segment

DELETE FROM test.Trace$
CALL installLogSeg('toto', 'log99','Blaster', '2005-09-05', '9.9', 'PCWS', 999.9)$

SELECT * FROM Logiciel$
SELECT * FROM test.Trace$

--test logiciel dj prsent
--ERROR 1062 (23000): Duplicate entry 'log1' for key 1

DELETE FROM test.Trace$
CALL installLogSeg('130.120.80', 'log1','Blaster', '2005-09-05', '9.9', 'PCWS', 999.9)$


--test type du logiciel
--ERROR 1452 (23000): Cannot add or update a child row: a foreign key constraint ...

DELETE FROM test.Trace$
CALL installLogSeg('130.120.80', 'log98','Mozilla', '2005-11-04', '1', 'toto', 100.0)$

--date dachat plus grande que celle du jour ?
-- DATEDIFF(v_dateIns,v_dateAch);

DELETE FROM test.Trace$
CALL installLogSeg('130.120.80', 'log98','Mozilla', '2010-11-04', '1', 'PCWS', 100.0)$

--aucune install
DELETE FROM test.Trace$
CALL installLogSeg('130.120.81', 'log55','Eudora', '2005-12-06', '5', 'PCWS', 540)$


--bonne installation

DELETE FROM test.Trace$
CALL installLogSeg('130.120.80', 'log77','Blog Up', '2005-12-05', '1.3', 'PCWS', 90)$

SELECT * FROM Logiciel$
SELECT * FROM Installer WHERE nLog='log77'$




