
---Manipulation des donnes

CREATE TABLE Test (a INTEGER(1) PRIMARY KEY, b CHAR(4));
INSERT INTO Test VALUES (1,'GTR');

INSERT INTO Test VALUES (1,'GIM') ON DUPLICATE KEY UPDATE a=a+1;
INSERT INTO Test VALUES (1,'GIM') ON DUPLICATE KEY UPDATE a=a+1;

SELECT * FROM Test;

DROP TABLE Test;

--

CREATE TABLE Compagnie
(comp CHAR(4), nrue INTEGER(3),
 rue CHAR(20), ville CHAR(15) DEFAULT 'Paris' COMMENT 'Par defaut : Paris',
 nomComp CHAR(15) NOT NULL,
 CONSTRAINT pk_Compagnie PRIMARY KEY(comp));

CREATE TABLE Pilote
(brevet CHAR(6), nom CHAR(15) NOT NULL,
 nbHVol DECIMAL(7,2), compa CHAR(4),
 CONSTRAINT pk_Pilote PRIMARY KEY(brevet),
 CONSTRAINT ck_nbHVol CHECK (nbHVol BETWEEN 0 AND 20000),
 CONSTRAINT un_nom UNIQUE (nom),
 CONSTRAINT fk_Pil_compa_Comp FOREIGN KEY (compa) REFERENCES Compagnie(comp));


INSERT INTO Compagnie   VALUES ('SING', 7, 'Camparols', 'Singapour', 'Singapore AL');
--DEFAULT explicite
INSERT INTO Compagnie	VALUES ('AF', 10, 'Gambetta', DEFAULT, 'Air France');
--NULL explicite
INSERT INTO Compagnie	VALUES ('AN1', NULL, 'Hoche', 'Blagnac', 'Air Nul1');

--utilise DEFAULT implicite
INSERT INTO Compagnie(comp, nrue, rue, nomComp)	VALUES ('AC', 8, 'Champs Elyses', 'Castanet Air');
--NULL sur nrue implicite
INSERT INTO Compagnie(comp, rue, ville, nomComp) VALUES ('AN2', 'Foch', 'Blagnac', 'Air Nul2');


INSERT INTO Pilote VALUES ('PL-1', 'Louise Ente', 450, 'AF');
INSERT INTO Pilote VALUES ('PL-2', 'Jules Ente', 900, 'AF');
INSERT INTO Pilote VALUES ('PL-3', 'Paul Soutou', 1000, 'SING');

--

INSERT INTO Compagnie VALUES
 ('LUFT',9,'Salas','Munich','Luftansa'),
 ('QUAN',1,'Kangouroo','Sydney','Quantas'),
 ('SNCM',3,'P. Paoli','Bastia','Corse Air');

SELECT * FROM Compagnie;

--pk
INSERT INTO Pilote VALUES ('PL-1', 'Amlie Sulpice', 100, 'AF');

--unique
INSERT INTO Pilote VALUES ('PL-4', 'Louise Ente', 450, 'AF');

--fk
INSERT INTO Pilote VALUES ('PL-5', 'Thomas Sulpice', 500, 'TOTO');

--NOT NULL
INSERT INTO Pilote VALUES ('PL-6', NULL, 100, 'AF');
--ERROR 1048 (23000): Column 'nom' cannot be null

--passe :malgr le CHECK !
INSERT INTO Pilote VALUES ('PL-7', 'Trop vol!', 20001, 'AF');


SELECT * FROM Pilote;
SELECT * FROM Compagnie;

DROP TABLE Pilote;
DROP TABLE Compagnie;

--Bit

DROP TABLE Registres;
CREATE TABLE Registres (nom CHAR(5),numero BIT(2),adresse BIT(16));

INSERT INTO Registres VALUES ('COM2', b'10', b'0000010011110111');

SELECT * FROM Registres;
DROP TABLE Registres;

--enumrations

--ENUM

DROP TABLE UnCursus;
CREATE TABLE UnCursus 
	(num CHAR(4), nom CHAR(15), 
	diplome ENUM ('BTS','DUT','Licence','INSA') NULL,
	CONSTRAINT pk_Cusus PRIMARY KEY(num));

INSERT INTO UnCursus VALUES ('E1', 'F. Brouard', ('BTS'));
INSERT INTO UnCursus VALUES ('E2', 'F. Degrelle', 'Licence');
INSERT INTO UnCursus VALUES ('E3', 'Bug', ('MathSup'));
INSERT INTO UnCursus VALUES ('E4', 'Vide', '');
INSERT INTO UnCursus (num,diplome) VALUES ('E5', 'Null');

SELECT nom, diplome, diplome+0 FROM UnCursus ;

DROP TABLE UnCursus;

--SET
CREATE TABLE Cursus 
	(num CHAR(4), nom CHAR(15), 
	diplomes SET ('BTS','DUT','Licence','INSA'),
	CONSTRAINT pk_Cusus PRIMARY KEY(num));

INSERT INTO Cursus VALUES ('E1', 'F. Brouard', ('BTS,Licence'));
INSERT INTO Cursus VALUES ('E2', 'F. Degrelle', 'Licence,INSA,DUT');
INSERT INTO Cursus VALUES ('E3', 'Bug', ('BTS,INSA,ENAC'));


SELECT nom, diplomes, diplomes+0 FROM Cursus ;

DROP TABLE Cursus;
	
---Dates

CREATE TABLE DatesTest (d1 DATE, d2 DATETIME, d3 TIMESTAMP);

INSERT INTO DatesTest VALUES ('1965-02-05','1965-02-05 06:30:00', SYSDATE());
INSERT INTO DatesTest VALUES ('1965/02/05','1965/02/05 06%30%00', SYSDATE());
INSERT INTO DatesTest VALUES ('19650205','19650205063000', SYSDATE());
INSERT INTO DatesTest VALUES (19650205,19650205063000, SYSDATE());

SELECT * FROM DatesTest;

--pb sur minutes
INSERT INTO DatesTest VALUES (19650205,19650205069000, SYSDATE());

DROP TABLE DatesTest;
--

CREATE TABLE Pilote
 (brevet VARCHAR(6), nom VARCHAR(20), dateNaiss DATE, 
  nbHVol DECIMAL(7,2),dateEmbauche DATETIME, compa VARCHAR(4),
  CONSTRAINT pk_Pilote PRIMARY KEY(brevet));

INSERT INTO Pilote VALUES ('PL-1', 'Christian Soutou', '1965-02-05', 900, SYSDATE(), 'AF');

SELECT * FROM Pilote;

DROP TABLE Pilote;

--
CREATE TABLE Pilote
 (brevet VARCHAR(6), nom VARCHAR(20), pasVolDepuis TIME,
  retraite YEAR, 
  CONSTRAINT pk_Pilote PRIMARY KEY(brevet));

INSERT INTO Pilote VALUES ('PL-1', 'Hait', '1 23:0:0', '2002');
INSERT INTO Pilote VALUES ('PL-2', 'Crampes', '152630', 2006);
INSERT INTO Pilote VALUES ('PL-3', 'Tuffery', '4 23:00', 05);
INSERT INTO Pilote VALUES ('PL-4', 'Mercier', 032750, '07');
INSERT INTO Pilote VALUES ('PL-5', 'Albaric', '1 23:0:0.457', '01');

SELECT * FROM Pilote;

DROP TABLE Pilote;

--

CREATE TABLE Pilote
 (brevet VARCHAR(6), nom VARCHAR(20), misaJour TIMESTAMP,
  CONSTRAINT pk_Pilote PRIMARY KEY(brevet));

INSERT INTO Pilote (brevet,nom) VALUES ('PL-1', 'Hait');
INSERT INTO Pilote (brevet,nom) VALUES ('PL-2', 'Crampes');
INSERT INTO Pilote (brevet,nom) VALUES ('PL-3', 'Tuffery');
--

SELECT * FROM Pilote;

UPDATE Pilote SET nom='Toto' WHERE brevet='PL-2';

SELECT * FROM Pilote;

UPDATE Pilote SET misaJour = NULL WHERE brevet='PL-3';

SELECT * FROM Pilote;
DROP TABLE Pilote;

SELECT CURRENT_TIMESTAMP(), CURRENT_TIME(), CURRENT_DATE(), UTC_TIME() ;
--heure hiver/t (indiquera -1h en hiver, -2h en t)
SELECT UTC_TIME(); 