---Projection

CREATE TABLE Pilote
	(brevet VARCHAR(6),
	 nom VARCHAR(16), nbHVol DECIMAL(7,2), compa CHAR(4),
	CONSTRAINT pk_Pilote PRIMARY KEY(brevet));

INSERT INTO Pilote VALUES ('PL-1', 'Gratien Viel', 450, 'AF');
INSERT INTO Pilote VALUES ('PL-2', 'Didier Donsez', 0, 'AF');
INSERT INTO Pilote VALUES ('PL-3', 'Richard Grin', 1000, 'SING');
INSERT INTO Pilote VALUES ('PL-4', 'Placide Fresnais', 2450, 'CAST');
INSERT INTO Pilote VALUES ('PL-5', 'Daniel Vielle', NULL, 'AF');

SELECT * FROM Pilote;

--col

SELECT compa, brevet FROM Pilote;

--alias

SELECT compa AS c1, nom AS NometPrenom, brevet c3 FROM Pilote;

SELECT aliasDesPilotes.compa AS c1, aliasDesPilotes.nom FROM Pilote aliasDesPilotes;



--duplicatas

SELECT compa FROM Pilote;

SELECT DISTINCT(compa) FROM Pilote;

SELECT DISTINCT compa FROM Pilote;

SELECT DISTINCTROW(compa) FROM Pilote;

SELECT DISTINCTROW compa FROM Pilote;

--expression


SELECT brevet, nbHVol, nbHVol*nbHVol AS auCarre, 10*nbHVol+5/2 FROM Pilote;


SELECT SYSDATE()+0 ;

--null

SELECT brevet, nbHVol FROM Pilote;

--odrer

SELECT brevet, nom FROM Pilote ORDER BY nom;

SELECT brevet,nbHVol FROM Pilote ORDER BY nbHvol DESC ;

--concatnation

SELECT brevet,CONCAT(nom,' vole pour ',compa) AS "Embauche" FROM Pilote;

--insertion multilignes


CREATE TABLE NomsetHVoldesPilotes
 (nom VARCHAR(16), nbHVol DECIMAL(7,2), compa CHAR(4));

INSERT INTO NomsetHVoldesPilotes SELECT nom,nbHVol,compa FROM Pilote;

SELECT * FROM NomsetHVoldesPilotes;

DROP TABLE NomsetHVoldesPilotes ;


CREATE TABLE NomsetHVoldesPilotes 
	AS SELECT nom, nbHVol, compa FROM Pilote;

SELECT * FROM NomsetHVoldesPilotes p;


DROP TABLE NomsetHVoldesPilotes ;



--LIMIT


SELECT * FROM Pilote LIMIT 1,2;  # Retrieve rows 6-15


SELECT * FROM Pilote ORDER BY nbHvol DESC LIMIT 2; 


SELECT * FROM Pilote ORDER BY nbHvol ASC LIMIT 2;


DROP TABLE Pilote;
