
--sous util / bdutil
--mysql --user=util --host=localhost -p --database=bdutil

CREATE TABLE pilote
(brevet CHAR(8), nom CHAR(10), nbHVol DECIMAL(7,2), 
adresse CHAR(20), compa CHAR(8),
CONSTRAINT pk_pilote PRIMARY KEY(brevet));
INSERT INTO pilote VALUES ('PL-1', 'Soutou', 890, 'Castanet', 'CAST');
INSERT INTO pilote VALUES ('PL-2', 'Laroche', 500, 'Montauban', 'CAST');
INSERT INTO pilote VALUES ('PL-3', 'Lamothe', 1200, 'Ramonville', 'AF');
INSERT INTO pilote VALUES ('PL-4', 'Albaric', 500, 'Vieille-Toulouse','AF');
INSERT INTO pilote VALUES ('PL-5', 'Bidal', 120, 'Paris', 'ASO');
INSERT INTO pilote VALUES ('PL-6', 'Labat', 120, 'Pau', 'ASO');
INSERT INTO pilote VALUES ('PL-7', 'Tauzin', 100, 'Bas-Mauco', 'ASO');

SELECT * FROM Pilote;
--

CREATE VIEW PilotesAF
    AS SELECT * FROM  Pilote 
    WHERE compa = 'AF';

CREATE VIEW Etat_civil
  AS SELECT nom, nbHVol, adresse, compa
  FROM Pilote;

SELECT SUM(nbHVol) FROM PilotesAF;

SELECT COUNT(*) FROM Etat_civil;

--order by

CREATE VIEW PilotesOrder
    AS SELECT * FROM  Pilote 
    ORDER BY nom;

SELECT * FROM PilotesOrder;

DROP VIEW PilotesOrder;


--

CREATE TABLE test (brevet CHAR(8));

CREATE VIEW vtest
    AS SELECT * FROM  test;
INSERT INTO test VALUES ('PL-1');

SELECT * FROM  vtest;

ALTER TABLE test ADD c2 CHAR(1);

SELECT * FROM  vtest;

DROP VIEW vtest;
DROP TABLE test;


--Alias
CREATE OR REPLACE VIEW PilotesPasAF(codepil, nomPil, heuresPil, adressePil, societe)
  AS SELECT *
  FROM  Pilote
  WHERE NOT (compa = 'AF');

SELECT * FROM PilotesPasAF;

--
CREATE OR REPLACE VIEW PilotesPasAF
  AS SELECT brevet codepil, nom nomPil, nbHVol heuresPil, adresse adressePil, 
  compa societe
  FROM  Pilote
  WHERE NOT (compa = 'AF');

SELECT * FROM PilotesPasAF;

--Vue d'une vue

CREATE OR REPLACE VIEW EtatCivilPilotesPasAF
  AS SELECT nomPil, heuresPil, adressePil
  FROM  PilotesPasAF;

SELECT * FROM EtatCivilPilotesPasAF;


--Read only


CREATE OR REPLACE ALGORITHM=TEMPTABLE
 VIEW PilotesPasAFRO
  AS SELECT *
  FROM  Pilote
  WHERE NOT (compa = 'AF');

INSERT INTO PilotesPasAFRO VALUES ('PL-8', 'Ferry', 5, 'Paris', 'ASO');

UPDATE PilotesPasAFRO SET nbHvol=nbHvol+2;

DELETE FROM PilotesPasAFRO ;

SELECT * FROM PilotesPasAFRO ;


--Mises  jour

INSERT INTO Etat_civil VALUES('Raffarin', 10, 'Poitiers', 'ASO');

INSERT INTO Etat_civil VALUES('Lebur',20,'Bordeaux','ASO');

--Possible!!!!
SELECT * FROM Pilote;
SELECT * FROM Pilote WHERE brevet IS NULL;
SELECT * FROM Pilote WHERE brevet='';


DELETE FROM Etat_civil WHERE compa = 'ASO';

UPDATE Etat_civil
  SET nbHVol = nbHVol*2
  WHERE nom = 'Lamothe';

SELECT * FROM Etat_civil;

INSERT INTO PilotesAF VALUES ('PL-8', 'Ferry', 5, 'Paris', 'AF');

UPDATE PilotesAF  SET nbHVol = nbHVol*2;

DELETE FROM PilotesAF WHERE nom = 'Ferry';

INSERT INTO PilotesAF VALUES ('PL-9', 'Caboche',600, 'Rennes', 'ASO');

SELECT * FROM pilote;
SELECT * FROM PilotesAF;


--WITH CHECK OPTION

CREATE OR REPLACE VIEW PilotesAF
  AS SELECT * FROM  pilote
  WHERE compa = 'AF' WITH CHECK OPTION;


INSERT INTO PilotesAF VALUES ('PL-9', 'Caboche',600, 'Rennes', 'ASO');

UPDATE PilotesAF SET compa='ASO';

INSERT INTO PilotesAF VALUES ('PL-11','Teste',900,'Revel','AF');

SELECT * FROM PilotesAF;
SELECT * FROM pilote;

DROP TABLE Pilote;
DROP VIEW PilotesPasAFRO;
DROP VIEW PilotesPasAF;

DROP VIEW PilotesAF;
DROP VIEW Etat_civil;
DROP VIEW EtatCivilPilotesPasAF;

--------------vues complexes

CREATE TABLE Compagnie
	(comp CHAR(4), nrue TINYINT(3), 
	rue CHAR(20), ville CHAR(15) DEFAULT 'Paris', nomComp CHAR(15),
 	CONSTRAINT pk_Compagnie PRIMARY KEY(comp));

CREATE TABLE Pilote
	(brevet CHAR(6), nom CHAR(15) NOT NULL, nbHVol DECIMAL(7,2), compa CHAR(4),
	 CONSTRAINT pk_Pilote PRIMARY KEY(brevet),
	 CONSTRAINT ck_nbHVol CHECK (nbHVol BETWEEN 0 AND 20000),
	 CONSTRAINT un_nom    UNIQUE (nom),
	 CONSTRAINT fk_Pil_compa_Comp FOREIGN KEY(compa) REFERENCES Compagnie(comp));

INSERT INTO Compagnie VALUES ('SING', 7, 'Camparols', 'Singapour', 'Singapore AL');
INSERT INTO Compagnie VALUES ('AF', 124, 'Port Royal', DEFAULT, 'Air France');
INSERT INTO Pilote VALUES ('PL-1', 'Louise Ente', 450, 'AF');
INSERT INTO Pilote VALUES ('PL-2', 'Paul Ente', 900, 'AF');
INSERT INTO Pilote VALUES ('PL-3', 'Paul Soutou', 1000, 'SING');

--
CREATE VIEW Pilotes_multi_AF
        AS SELECT  p.brevet, p.nom, p.nbHVol, c.ville, c.nomComp
             FROM  Pilote p, Compagnie c
             WHERE p.compa = c.comp
             AND   p.compa = 'AF';
SELECT * FROM Pilotes_multi_AF;

--
CREATE VIEW Moyenne_Heures_Pil
  AS SELECT compa, AVG(nbHVol) moyenne 
  FROM Pilote GROUP BY compa;
SELECT * FROM  Moyenne_Heures_Pil;

--insert : non
INSERT INTO Moyenne_Heures_Pil VALUES ('TAT',50);

--update: non
UPDATE Moyenne_Heures_Pil SET moyenne = 10;

--delete: non
DELETE FROM Moyenne_Heures_Pil;

--insert : non
INSERT INTO Pilotes_multi_AF VALUES 
('PL-4', 'Test', 400, 'Castanet','Castanet Air Lines');

--update
--possible (key preserved)
SELECT * FROM Pilotes_multi_AF;

UPDATE Pilotes_multi_AF SET nbHVol =  nbHVol * 2;

SELECT brevet,nom,nbHVol FROM Pilotes_multi_AF;

-- possible !
UPDATE Pilotes_multi_AF SET ville =  'Orly';


SELECT brevet,nom,ville FROM Pilotes_multi_AF;
SELECT comp,ville,nomComp FROM Compagnie;

--delete : pas possible

DELETE FROM Pilotes_multi_AF;

SELECT * FROM Pilotes_multi_AF;

SELECT * FROM Pilote;

SELECT * FROM Compagnie;


DROP VIEW  Moyenne_Heures_Pil;
DROP VIEW  Pilotes_multi_AF;

--key preserved : Pilote 

DROP VIEW  Vue_Multi_Comp_Pil;

CREATE VIEW  Vue_Multi_Comp_Pil
  AS SELECT c.comp, c.nomComp, p.brevet, p.nom, p.nbHVol
  FROM  Pilote p, Compagnie c
  WHERE p.compa = c.comp;

SELECT * FROM Vue_Multi_Comp_Pil;

--pas possible
INSERT INTO Vue_Multi_Comp_Pil VALUES ('TAT', 'Test', 'PL-5', 'Jean',2500);
INSERT INTO Vue_Multi_Comp_Pil VALUES ('', '', 'PL-5', 'Jean',2500);
INSERT INTO Vue_Multi_Comp_Pil VALUES (NULL,NULL, 'PL-5', 'Jean',2500);

--ok
UPDATE Vue_Multi_Comp_Pil SET nbHVol = nbHVol*3;


SELECT brevet, nbHVol FROM Pilote;


--possible : EFFET DE BORD...

UPDATE Vue_Multi_Comp_Pil SET  nomComp = 'Dupond';

SELECT comp,ville,nomComp FROM Compagnie;

SELECT * FROM Vue_Multi_Comp_Pil;

-- pas possible

DELETE FROM Vue_Multi_Comp_Pil WHERE comp='AF';

--possible

INSERT INTO Vue_Multi_Comp_Pil(brevet,nom,nbHVol)
 VALUES ('PL-5', 'Jean',2500);

INSERT INTO Vue_Multi_Comp_Pil(comp,nomComp)
 VALUES ('TAT', 'Test');

SELECT brevet,nom,nbHVol FROM Pilote;
SELECT comp,ville,nomComp FROM Compagnie;


--
DESC Vue_Multi_Comp_Pil;

SELECT * FROM Vue_Multi_Comp_Pil;
SELECT * FROM Pilote;
SELECT * FROM Compagnie;

----

describe INFORMATION_SCHEMA.COLLATION_CHARACTER_SET_APPLICABILITY;

CREATE VIEW CollationsLatines (collation,jeu)
	AS SELECT * 
	FROM INFORMATION_SCHEMA.COLLATION_CHARACTER_SET_APPLICABILITY
	WHERE CHARACTER_SET_NAME LIKE 'Latin%';

SELECT * FROM CollationsLatines 
	WHERE collation LIKE '%french%'
	OR    collation LIKE '%german%';

DROP  VIEW CollationsLatines ;


--
-- si grade copil / nbHvol > ... 3cas

DROP TABLE Pilote;

CREATE TABLE Pilote
(brevet CHAR(6), nom CHAR(15), nbHVol DECIMAL(7,2), grade CHAR(4),
CONSTRAINT pk_Pilote PRIMARY KEY(brevet));


CREATE VIEW VueGradePilotes
  AS SELECT brevet,nom,nbHVol,grade
  FROM Pilote
  WHERE (grade = 'CDB' AND nbHVol BETWEEN 1000 AND 4000)
  OR    (grade = 'COPI' AND nbHVol BETWEEN 100 AND 1000)
  OR    (grade = 'INST' AND nbHVol > 3000) 
  WITH CHECK OPTION ;


--
INSERT INTO VueGradePilotes (brevet,nom,nbHVol,grade)
	VALUES ('PL-1', 'Daniel Vielle', 1000, 'CDB');

INSERT INTO VueGradePilotes (brevet,nom,nbHVol,grade)
	VALUES ('PL-2', 'Benoit Treihlou', 450, 'COPI');

INSERT INTO VueGradePilotes (brevet,nom,nbHVol,grade)
	VALUES ('PL-3', 'Pierre Filoux', 9000, 'INST');

INSERT INTO VueGradePilotes (brevet,nom,nbHVol,grade)
	VALUES ('PL-4', 'Philippe Minier', 1000, 'COPI');

--idem
SELECT * FROM VueGradePilotes ;
SELECT * FROM Pilote;

--non valide
INSERT INTO VueGradePilotes (brevet,nom,nbHVol,grade)
	VALUES ('PL-5', 'Trop jeune', 100, 'CDB');

INSERT INTO VueGradePilotes (brevet,nom,nbHVol,grade)
	VALUES ('PL-6', 'Inexperimente', 2999, 'INST');

UPDATE VueGradePilotes 
	SET grade ='INST' WHERE brevet = 'PL-2';

UPDATE VueGradePilotes 
	SET nbHVol= 50 WHERE brevet = 'PL-3';

--valide
UPDATE VueGradePilotes 
	SET grade ='CDB' WHERE brevet = 'PL-4';

--idem
SELECT * FROM VueGradePilotes ;
SELECT * FROM Pilote;


DROP VIEW VueGradePilotes;
DROP TABLE Pilote;
DROP TABLE Compagnie;
DROP VIEW Vue_Multi_Comp_Pil;

-----------

---Confidentialit


CREATE TABLE Compagnie
	(comp CHAR(4), nrue TINYINT(3), 
	rue CHAR(20), ville CHAR(15) DEFAULT 'Paris', nomComp CHAR(15),
 	CONSTRAINT pk_Compagnie PRIMARY KEY(comp));

INSERT INTO Compagnie VALUES ('SING', 7, 'Camparols', 'Singapour', 'Singapore AL');
INSERT INTO Compagnie VALUES ('AF', 124, 'Port Royal', DEFAULT, 'Air France');

CREATE VIEW VueDesCompagniesJoursFeries
  AS SELECT * FROM Compagnie
  WHERE DATE_FORMAT(SYSDATE(),'%W') IN ('Sunday', 'Saturday');

--NOT IN pour inverser le sens

SELECT DATE_FORMAT(SYSDATE(),'%W');

SELECT * FROM Compagnie;
SELECT * FROM VueDesCompagniesJoursFeries;

INSERT INTO VueDesCompagniesJoursFeries
 VALUES ('TEMP', 1, 'tmp', 'tmp', 'tmp...');


DROP VIEW VueDesCompagniesJoursFeries;
DROP TABLE Compagnie;
---------


CREATE TABLE Pilote
(brevet CHAR(6), nom CHAR(15), nbHVol DECIMAL(7,2), grade CHAR(4),
CONSTRAINT pk_Pilote PRIMARY KEY(brevet));

--

INSERT INTO Pilote (brevet,nom,nbHVol,grade)
	VALUES ('PL-1', 'Daniel Vielle', 1000, 'CDB');

SELECT CURTIME()+0;


CREATE VIEW VueDesPilotesJoursOuvrables
  AS SELECT * FROM Pilote
  WHERE CURTIME()+0 BETWEEN 83000 AND 173000
  AND DATE_FORMAT(SYSDATE(),'%W') NOT IN ('Sunday', 'Saturday')
  WITH CHECK OPTION;


SELECT * FROM VueDesPilotesJoursOuvrables;

INSERT INTO VueDesPilotesJoursOuvrables
 VALUES ('PL-6', 'Pil nouveau', 50, 'SING');

SELECT * FROM VueDesPilotesJoursOuvrables;


DROP VIEW VueDesPilotesJoursOuvrables;

CREATE VIEW VueDesPilotesJoursOuvrables
  AS SELECT * FROM Pilote
  WHERE CURTIME()+0 BETWEEN 83000 AND 173000
  AND DATE_FORMAT(SYSDATE(),'%W') NOT IN ('Sunday', 'Saturday')
  AND CURRENT_USER() = 'root@localhost'
  WITH CHECK OPTION;

SELECT * FROM VueDesPilotesJoursOuvrables;

--ALTER VIEW

ALTER VIEW VueDesPilotesJoursOuvrables
  AS SELECT * FROM Pilote
  WHERE CURTIME()+0 BETWEEN 83000 AND 173000
  AND DATE_FORMAT(SYSDATE(),'%W') IN ('Sunday', 'Saturday')
  WITH CHECK OPTION;

ALTER ALGORITHM=TEMPTABLE VIEW VueDesPilotesJoursOuvrables
  AS SELECT * FROM Pilote
  WHERE CURTIME()+0 BETWEEN 83000 AND 173000
  AND DATE_FORMAT(SYSDATE(),'%W') IN ('Sunday', 'Saturday');

SHOW CREATE VIEW VueDesPilotesJoursOuvrables;

DROP VIEW VueDesPilotesJoursOuvrables;
DROP TABLE Pilote;
