
--Crations sous root

CREATE USER Paul@localhost IDENTIFIED BY 'iut';

CREATE USER Jules@localhost IDENTIFIED BY 'iut';


CREATE DATABASE bdpaul;

GRANT CREATE,DROP ON bdpaul.* TO 'Paul'@'localhost';


--sous Paul

mysql --user=Paul --host=localhost -p 

USE bdpaul;

CREATE TABLE bdpaul.Livre(titre VARCHAR(30), ISBN VARCHAR(20));

-- sous root

GRANT INSERT,SELECT,DELETE,UPDATE(ISBN) ON bdpaul.Livre TO 'Paul'@'localhost';

GRANT ALTER ON bdpaul.Livre TO 'Paul'@'localhost';

GRANT SELECT(titre) ON bdpaul.Livre TO 'Jules'@'localhost'
	WITH GRANT OPTION;

GRANT CREATE ON *.* TO 'Jules'@'localhost';

GRANT USAGE ON bdpaul.* TO 'Jules'@'localhost'
         WITH 
           MAX_QUERIES_PER_HOUR 50
           MAX_UPDATES_PER_HOUR 20 
           MAX_CONNECTIONS_PER_HOUR 6
           MAX_USER_CONNECTIONS 3;

--sous paul/bdpaul

INSERT INTO Livre VALUES('Objet-relationnel sous Oracle8','2-212-09063-3');

--Refus : normal
UPDATE Livre SET titre = 'Apprendre MySQL'
	WHERE ISBN='2-212-09063-3';

UPDATE Livre SET ISBN='I1' 
	WHERE titre = 'Objet-relationnel sous Oracle8';

ALTER TABLE Livre 
	ADD CONSTRAINT un_titre_livre UNIQUE (titre);

--pas possible car Paul pas GRANT OPTION
GRANT SELECT ON bdpaul.Livre TO 'Jules'@'localhost';


--sous Jules

mysql --user=Jules --host=localhost -p 

SELECT titre FROM bdpaul.Livre;

--pas permis
SELECT ISBN FROM bdpaul.Livre;

--permis
CREATE DATABASE bdjules;

--pas permis
DROP DATABASE bdjules;

--sous root
SHOW GRANTS FOR 'Jules'@'localhost';

SHOW GRANTS FOR 'Paul'@'localhost';

SHOW GRANTS FOR 'root'@'localhost';


SELECT Host,User,Select_priv,Insert_priv,Update_priv,Delete_priv FROM mysql.user;

SELECT Host,User,Create_priv,Drop_priv,Index_priv,Alter_priv  FROM mysql.user;

SELECT Host,User,Create_user_priv,Grant_priv,Show_db_priv FROM mysql.user;

SELECT Host,User,Create_view_priv,Show_view_priv FROM mysql.user;

SELECT  Host,User,Create_routine_priv,Alter_routine_priv,Execute_priv FROM mysql.user;

SELECT  Host,User,max_questions "Requetes",max_updates "Modifs" ,
max_connections "Connexions",max_user_connections "Cx simult." FROM mysql.user;

--PAs fait :
--,References_priv
--pas oprationnel
-- SELECT Host,User,Create_tmp_table_priv, Lock_tables_priv FROM mysql.user;
-- SELECT Host,User,Shutdown_priv,Process_priv,File_priv FROM mysql.user;
-- SELECT Host,User,Super_priv FROM mysql.user;
-- SELECT Host,User,Repl_slave_priv,Repl_client_priv FROM mysql.user;


--------Table mysql.db

DESCRIBE mysql.db;

SELECT Host,User,Db,Create_priv,Drop_priv,Alter_priv FROM mysql.db;

SELECT Host,User,Db, Select_priv,Insert_priv,Update_priv,Delete_priv FROM mysql.db;

SELECT Host,User,Db ,Grant_priv FROM mysql.db;

SELECT Host,User,Db, Create_view_priv,Show_view_priv FROM mysql.db;

SELECT  Host,User,Db, Create_routine_priv,Alter_routine_priv,Execute_priv FROM mysql.db;

--------Table mysql.host c'est mysql.db avec la colonne User en moins ?

DESCRIBE mysql.host;

SELECT Host,Db,Select_priv,Insert_priv,Update_priv,Delete_priv FROM mysql.host;

SELECT Host,Db,Create_priv,Drop_priv,Alter_priv FROM mysql.host;

SELECT  Host,Db, Create_routine_priv,Alter_routine_priv,Execute_priv FROM mysql.host;


--------Table mysql.tables_priv
       
DESCRIBE mysql.tables_priv;

SELECT CONCAT(User,'@',Host) "Compte", CONCAT(Db,'.',Table_name) "Objet",Grantor,Table_priv FROM mysql.tables_priv;

--------Table mysql.columns_priv

DESCRIBE mysql.columns_priv;

SELECT CONCAT(User,'@',Host) "Compte", CONCAT(Db,'.',Table_name) "Objet",
       Column_name,Column_priv FROM mysql.columns_priv;


--------Table mysql.procs_priv

DESCRIBE mysql.procs_priv;

--jeu essai

delimiter $

CREATE PROCEDURE bdpaul.sp1()
BEGIN
  DECLARE v_brevet CHAR(6);
  SET v_brevet := 'PROC';
END;
$

CREATE FUNCTION bdpaul.sp2() RETURNS CHAR(3)
BEGIN
  DECLARE v_brevet CHAR(3);
  SET v_brevet := 'FCT';
  RETURN v_brevet ;
END;
$

delimiter ;


GRANT CREATE ROUTINE ON bdpaul.* TO 'Paul'@'localhost';
GRANT ALTER ROUTINE ON PROCEDURE bdpaul.sp1 TO 'Paul'@'localhost';
GRANT EXECUTE ON PROCEDURE bdpaul.sp1 TO 'Jules'@'localhost';
GRANT EXECUTE ON FUNCTION bdpaul.sp2 TO 'Jules'@'localhost';


SELECT  CONCAT(User,'@',Host) "Compte", Db, Create_routine_priv "create routine",
 Alter_routine_priv "alter routine",Execute_priv "exec. routine" FROM mysql.db;

SELECT CONCAT(User,'@',Host) "Compte", CONCAT(Db,'.',Routine_name,':',Routine_type) "Objet",
       Grantor,Proc_priv FROM mysql.procs_priv;

DROP PROCEDURE bdpaul.sp1;
DROP FUNCTION  bdpaul.sp2;

--REVOKE
--sous root

REVOKE CREATE ON bdpaul.* FROM 'Paul'@'localhost';

REVOKE ALTER,INSERT,UPDATE(ISBN) ON bdpaul.Livre FROM 'Paul'@'localhost';

GRANT USAGE ON bdpaul.* TO 'Jules'@'localhost'
         WITH 
           MAX_QUERIES_PER_HOUR 0
           MAX_UPDATES_PER_HOUR 0;

SELECT CONCAT(User,'@',Host) "Compte", 
       CONCAT(Db,'.',Table_name) "Objet", Grantor, Table_priv 
       FROM mysql.tables_priv WHERE User='Paul' AND Host='localhost';

SELECT Host,User, max_questions "Requetes", max_updates "Modifs" ,
       max_connections "Connexions", max_user_connections "Cx simult." 
       FROM mysql.user WHERE User='Jules' AND Host='localhost';


REVOKE ALL PRIVILEGES, GRANT OPTION FROM 'Jules'@'localhost';

SELECT Host,User, max_questions "Requetes", max_updates "Modifs" ,
       max_connections "Connexions", max_user_connections "Cx simult." 
       FROM mysql.user;

SELECT Host,User,Db,Create_priv,Drop_priv,Alter_priv FROM mysql.db;

SELECT CONCAT(User,'@',Host) "Compte", 
       CONCAT(Db,'.',Table_name) "Objet", Grantor, Table_priv 
       FROM mysql.tables_priv;

SELECT CONCAT(User,'@',Host) "Compte", CONCAT(Db,'.',Table_name) "Objet",
       Column_name,Column_priv FROM mysql.columns_priv;


SELECT CONCAT(User,'@',Host) "Compte",
       CONCAT(Db,'.',Routine_name,':',Routine_type) "Objet", 
       Grantor, Proc_priv FROM mysql.procs_priv;


--Accs distant

CREATE USER Paul@192.168.4.173 IDENTIFIED BY 'pauldistant';

GRANT SELECT ON bdpaul.Livre TO 'Paul'@'192.168.4.173';

SELECT User,Host FROM mysql.user;

GRANT DROP ON bdPaul.* TO 'Paul'@'192.168.4.173';

SELECT Host,Db,Select_priv,Insert_priv,Update_priv,Delete_priv FROM mysql.host;

SELECT Host,Db,Create_priv,Drop_priv,Alter_priv FROM mysql.host;

SELECT  Host,Db, Create_routine_priv,Alter_routine_priv,Execute_priv FROM mysql.host;

-------------------------

DROP USER Paul@192.168.4.173 ;
DROP USER Paul@localhost ;
DROP USER Jules@localhost ;

DROP DATABASE bdjules;
DROP DATABASE bdpaul;






