-- Curseurs

--
delimiter $

DROP PROCEDURE bdutil.cursex1$

CREATE PROCEDURE bdutil.cursex1()
BEGIN
  DECLARE fincurs1 BOOLEAN DEFAULT 0;
  DECLARE v_brevet VARCHAR(6);
  DECLARE v_nbHv   DECIMAL(7,2);
  DECLARE v_comp   VARCHAR(4);
 
  DECLARE curs1 CURSOR FOR 
	SELECT brevet,nbHVol,comp 
	FROM bdutil.Pilote WHERE comp = 'AF';
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET fincurs1 := 1;

  OPEN curs1;

  REPEAT
    FETCH curs1 INTO v_brevet,v_nbHv,v_comp;
    IF NOT fincurs1 THEN
	SELECT  v_brevet,v_nbHv;
    END IF;
    UNTIL fincurs1 
  END REPEAT;
  CLOSE curs1;
END;
$


delimiter ;
CALL bdutil.cursex1();

--2eme solution de parcours

delimiter $

DROP PROCEDURE bdutil.cursex1$

CREATE PROCEDURE bdutil.cursex1()
BEGIN
  DECLARE fincurs1 BOOLEAN DEFAULT 0;
  DECLARE v_brevet VARCHAR(6);
  DECLARE v_nbHv   DECIMAL(7,2);
  DECLARE v_comp   VARCHAR(4);
 
  DECLARE curs1 CURSOR FOR 
	SELECT brevet,nbHVol,comp 
	FROM bdutil.Pilote WHERE comp = 'AF';
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET fincurs1 := 1;

  OPEN curs1;

  FETCH curs1 INTO v_brevet,v_nbHv,v_comp;
  WHILE (NOT fincurs1) DO 
	SELECT  v_brevet,v_nbHv;
	FETCH curs1 INTO v_brevet,v_nbHv,v_comp;  
  END WHILE;
  CLOSE curs1;
-- FETCH curs1 INTO v_brevet,v_nbHv,v_comp;  
END;
$

delimiter ;
CALL bdutil.cursex1();

DROP PROCEDURE bdutil.cursex1;

--3eme solution avec une fonction
--bug
--ERROR 1415 (0A000): Not allowed to return a result set from a function

delimiter $

DROP FUNCTION bdutil.cursex1$

CREATE FUNCTION bdutil.cursex1() RETURNS SMALLINT
LANGUAGE SQL READS SQL DATA 
BEGIN
  DECLARE fincurs1 BOOLEAN DEFAULT 0;
  DECLARE v_brevet VARCHAR(6);
  DECLARE v_nbHv   DECIMAL(7,2);
  DECLARE v_comp   VARCHAR(4);
  DECLARE v_nbpil  SMALLINT DEFAULT 0;

  DECLARE curs1 CURSOR FOR 
	SELECT brevet,nbHVol,comp 
	FROM bdutil.Pilote WHERE comp = 'AF';
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET fincurs1 := 1;

  OPEN curs1;

  FETCH curs1 INTO v_brevet,v_nbHv,v_comp;
  WHILE (NOT fincurs1) DO 
	SET v_nbpil  := v_nbpil+1;
	SELECT  v_brevet,v_nbHv;
	FETCH curs1 INTO v_brevet,v_nbHv,v_comp;  
  END WHILE;
  CLOSE curs1;
  RETURN v_nbpil;
END;
$

delimiter ;
CALL bdutil.cursex1();


----------total heures pour 'AF'


delimiter $

DROP PROCEDURE bdutil.cursex1$

CREATE PROCEDURE bdutil.cursex1()
BEGIN
  DECLARE fincurs1 BOOLEAN DEFAULT 0;
  DECLARE v_nbHv   DECIMAL(7,2);
  DECLARE v_tot    DECIMAL(8,2) DEFAULT 0;
 
  DECLARE curs1 CURSOR FOR 
	SELECT nbHVol
	FROM bdutil.Pilote WHERE comp = 'AF';
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET fincurs1 := 1;

  OPEN curs1;

  REPEAT
    FETCH curs1 INTO v_nbHv;
    IF NOT fincurs1 THEN
	SET v_tot := v_tot+v_nbHv;
    END IF;
    UNTIL fincurs1 
  END REPEAT;
  CLOSE curs1;
  SELECT v_tot AS 'Total heures pour les pilotes de ''AF''';
END;
$


delimiter ;
CALL bdutil.cursex1();

DROP PROCEDURE bdutil.cursex1;


--2eme solution de parcours

delimiter $

DROP PROCEDURE bdutil.cursex1$

CREATE PROCEDURE bdutil.cursex1()
BEGIN
  DECLARE fincurs1 BOOLEAN DEFAULT 0;
  DECLARE v_nbHv   DECIMAL(7,2);
  DECLARE v_tot    DECIMAL(8,2) DEFAULT 0;
 
  DECLARE curs1 CURSOR FOR 
	SELECT nbHVol
	FROM bdutil.Pilote WHERE comp = 'AF';
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET fincurs1 := 1;

  OPEN curs1;
  FETCH curs1 INTO v_nbHv;
  WHILE (NOT fincurs1) DO 
	SET v_tot := v_tot+v_nbHv;
	FETCH curs1 INTO v_nbHv;  
  END WHILE;
  CLOSE curs1;
  SELECT v_tot AS 'Total heures pour les pilotes de ''AF''';
END;
$

delimiter ;
CALL bdutil.cursex1();

DROP PROCEDURE bdutil.cursex1;


delimiter $

DROP PROCEDURE bdutil.cursex1$

CREATE PROCEDURE bdutil.cursex1()
BEGIN
  DECLARE fincurs BOOLEAN DEFAULT 0;
  DECLARE v_brevet VARCHAR(6);
  DECLARE v_nbHv   DECIMAL(7,2);
  DECLARE v_comp   VARCHAR(4);

  DECLARE curs CURSOR FOR 
	SELECT brevet,nbHVol,comp
	FROM bdutil.Pilote FOR UPDATE;
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET fincurs := 1;
  SET AUTOCOMMIT = 0;

  OPEN curs;
  FETCH curs INTO v_brevet,v_nbHv,v_comp;
  WHILE (NOT fincurs) DO 
	IF (v_comp='AF') THEN 
		UPDATE bdutil.Pilote SET nbHVol = nbHVol + 100
		WHERE brevet = v_brevet;
	ELSEIF (v_comp='SING') THEN 
	       UPDATE bdutil.Pilote SET nbHVol = nbHVol - 100 WHERE brevet = v_brevet;
	ELSE
               DELETE FROM bdutil.Pilote WHERE brevet = v_brevet;
	END IF;

	FETCH curs INTO v_brevet,v_nbHv,v_comp;  
  END WHILE;
  CLOSE curs;
 COMMIT;
END;
$

delimiter ;
SELECT * FROM bdutil.pilote;

CALL bdutil.cursex1();
SELECT * FROM bdutil.pilote;

DROP PROCEDURE bdutil.cursex1;
-----------

delimiter $

CREATE PROCEDURE bdutil.cursex1(IN p_comp VARCHAR(4))
BEGIN
  DECLARE fincurs1 BOOLEAN DEFAULT 0;
--  DECLARE v_brevet VARCHAR(6);
  DECLARE v_nom    VARCHAR(20);
  DECLARE v_comp   VARCHAR(4);
  DECLARE v_nbHv   DECIMAL(7,2);
  DECLARE v_tot    DECIMAL(8,2) DEFAULT 0;
  DECLARE v_nbpil  SMALLINT DEFAULT 0;

  DECLARE curs1 CURSOR FOR 
	SELECT nom,nbHVol,comp 
	FROM bdutil.Pilote WHERE NOT (comp = p_comp);
 --  DECLARE CONTINUE HANDLER FOR SQLSTATE '02000' SET done = 1;

  DECLARE CONTINUE HANDLER FOR NOT FOUND SET fincurs1 := 1;

  OPEN curs1;

  REPEAT
    FETCH curs1 INTO v_nom,v_nbHv,v_comp;
    IF NOT fincurs1 THEN
       --
	SET v_nbpil  := v_nbpil+1;
	SELECT v_nom AS 'Nom',v_comp AS 'compagnie';
	SET v_tot := v_tot+v_nbHv;
    END IF;
    UNTIL fincurs1 
  END REPEAT;
  CLOSE curs1;
  SELECT CONCAT(v_nbpil,' pilotes pour ',v_tot,' heures',' pour compagnie diffrent de ',p_comp)
	 AS 'Total heures';
END;
$


delimiter ;
CALL bdutil.cursex1('AF');


delimiter ;
CALL bdutil.cursex1('SING');



DROP PROCEDURE bdutil.cursex1;

