
--sous root donner le privilge SUPER  util
--GRANT SUPER ON * TO 'util'@'localhost';
--sous util / bdutil

delimiter ;

CREATE TABLE TypeAvion
	(typA VARCHAR(4), nomType VARCHAR(30));

CREATE TABLE Pilote
	(brevet VARCHAR(6), nom VARCHAR(20), nbHVol DECIMAL(7,2), compa VARCHAR(4), nbQualif TINYINT(1),
	 CONSTRAINT pk_Pilote PRIMARY KEY(brevet));

CREATE TABLE Qualifications
	(brevet VARCHAR(6), typa VARCHAR(4), expire DATE);

INSERT INTO TypeAvion VALUES ('A320', 'Biracteur Airbus 320');
INSERT INTO TypeAvion VALUES ('A330', 'Biracteur Airbus 330');
INSERT INTO TypeAvion VALUES ('A340', 'Quadriracteur Airbus 340');
INSERT INTO TypeAvion VALUES ('A380', 'Big-Quadriracteur 380');

INSERT INTO Pilote VALUES ('PL-1', 'P. Caboche', 450, 'AF',3);
INSERT INTO Pilote VALUES ('PL-2', 'G. Lebur', 3400, 'AF',1);
INSERT INTO Pilote VALUES ('PL-3', 'X. Leclercq', 900, 'SING',1);

INSERT INTO Qualifications VALUES ('PL-1', 'A340', '2005-06-22');
INSERT INTO Qualifications VALUES ('PL-1', 'A330', '2005-02-05');
INSERT INTO Qualifications VALUES ('PL-1', 'A320', '2004-01-16');
INSERT INTO Qualifications VALUES ('PL-2', 'A320', '2004-01-18');
INSERT INTO Qualifications VALUES ('PL-3', 'A330', '2006-01-22');

SELECT * FROM Pilote;
SELECT * FROM TypeAvion ;
SELECT * FROM Qualifications ;


--  trigger after delete

delimiter $
CREATE TRIGGER TriDelQualif
 AFTER DELETE ON Qualifications
 FOR EACH ROW
BEGIN
   UPDATE Pilote SET nbQualif = nbQualif - 1 WHERE brevet = OLD.brevet;
END;
$


----AFTER INSERT

delimiter $
CREATE TRIGGER TrigInsQualif
 AFTER INSERT ON Qualifications
 FOR EACH ROW
BEGIN
 UPDATE Pilote SET nbQualif = nbQualif + 1 WHERE brevet = NEW.brevet;
END;
$

--  trigger after update

delimiter $
CREATE TRIGGER TrigUpdQualif
 AFTER UPDATE ON Qualifications 
 FOR EACH ROW
BEGIN
    UPDATE Pilote SET nbQualif = nbQualif + 1 WHERE brevet = NEW.brevet;
    UPDATE Pilote SET nbQualif = nbQualif - 1 WHERE brevet = OLD.brevet;
END;
$

SELECT * FROM Pilote$
SELECT * FROM Qualifications$

INSERT INTO Qualifications VALUES ('PL-2', 'A380', SYSDATE())$

DELETE FROM Qualifications WHERE typa = 'A320'$

UPDATE Qualifications 
       SET brevet   = 'PL-2'  WHERE brevet = 'PL-3' AND   typa   = 'A330'$

SELECT * FROM Pilote$
SELECT * FROM Qualifications$


--Dictionnaire des donnes

delimiter ;
SELECT TRIGGER_NAME,EVENT_OBJECT_TABLE "Table",
       EVENT_MANIPULATION "Evenement", ACTION_TIMING,EVENT_OBJECT_SCHEMA "Base"
  FROM INFORMATION_SCHEMA.TRIGGERS
  WHERE  TRIGGER_SCHEMA='bdutil';

SELECT ACTION_STATEMENT 
    FROM INFORMATION_SCHEMA.TRIGGERS
    WHERE  TRIGGER_SCHEMA='bdutil' AND EVENT_OBJECT_TABLE='Qualifications'
    AND EVENT_MANIPULATION='UPDATE' AND ACTION_TIMING='AFTER';

SHOW TRIGGERS;


--Appels procdures

delimiter $
CREATE TABLE Trace(col VARCHAR(80))$

CREATE PROCEDURE bdutil.procTrigg(IN param DATETIME) 
BEGIN
   INSERT INTO Trace VALUES (CONCAT('Insertion pilote, appel de bdutil.procTrigg le ',param));	
 --  COMMIT;
 -- ERROR 1422 (HY000): Explicit or implicit commit is not allowed in stored functio
 -- n or trigger.
END;
$

CREATE TRIGGER bdutil.espionAjoutPilote
 BEFORE INSERT ON Pilote
 FOR EACH ROW
BEGIN
 CALL bdutil.procTrigg(SYSDATE());
END;
$

SELECT * FROM Pilote$
SELECT * FROM Trace$
INSERT INTO Pilote VALUES ('PL-4', 'C. Soutou', 100, 'AF',0)$
SELECT * FROM Pilote$
SELECT * FROM Trace$

--


DROP TRIGGER bdutil.espionAjoutPilote$
DROP TABLE Trace $
DROP PROCEDURE bdutil.procTrigg$

DROP TRIGGER TrigUpdQualif$
DROP TRIGGER TrigInsQualif$
DROP TRIGGER TriDelQualif$

--  trigger before insert : comment interdire l'insert?

delimiter ;
delete from Qualifications ;
delete from Pilote ;
delete from TypeAvion ;

INSERT INTO TypeAvion VALUES ('A320', 'Biracteur Airbus 320');
INSERT INTO TypeAvion VALUES ('A330', 'Biracteur Airbus 330');
INSERT INTO TypeAvion VALUES ('A340', 'Quadriracteur Airbus 340');
INSERT INTO TypeAvion VALUES ('A380', 'Big-Quadriracteur 380');

INSERT INTO Pilote VALUES ('PL-1', 'P. Caboche', 450, 'AF',3);
INSERT INTO Pilote VALUES ('PL-2', 'G. Lebur', 3400, 'AF',1);
INSERT INTO Pilote VALUES ('PL-3', 'X. Leclercq', 900, 'SING',1);

INSERT INTO Qualifications VALUES ('PL-1', 'A340', '2005-06-22');
INSERT INTO Qualifications VALUES ('PL-1', 'A330', '2005-02-05');
INSERT INTO Qualifications VALUES ('PL-1', 'A320', '2004-01-16');
INSERT INTO Qualifications VALUES ('PL-2', 'A320', '2004-01-18');
INSERT INTO Qualifications VALUES ('PL-3', 'A330', '2006-01-22');

delimiter $

CREATE TABLE Trace(col VARCHAR(80) PRIMARY KEY)$

CREATE TRIGGER TrigInsQualif
 BEFORE INSERT ON Qualifications
 FOR EACH ROW
BEGIN
DECLARE v_compteur TINYINT(1);
DECLARE v_nom VARCHAR(30);
 SELECT nbQualif, nom INTO v_compteur, v_nom FROM Pilote WHERE brevet = NEW.brevet;
 IF v_compteur < 3 THEN
    UPDATE Pilote SET nbQualif = nbQualif + 1 WHERE brevet = NEW.brevet;
 ELSE
  INSERT INTO TRACE VALUES (CONCAT('Le pilote ',v_nom,' a dj 3 qualifications!'));
  INSERT INTO TRACE VALUES (NULL);
 END IF;
END;
$

SELECT * FROM Pilote$
SELECT * FROM Qualifications$
DELETE FROM Trace$

--ne passe pas et ne fait pas l'INSERT ni dans Trace ni dans Qualifications

INSERT INTO Qualifications VALUES ('PL-1', 'A380', SYSDATE())$

SELECT * FROM Pilote$
SELECT * FROM Qualifications$
SELECT * FROM Trace$

--passe
INSERT INTO Qualifications VALUES ('PL-3', 'A380', SYSDATE())$

SELECT * FROM Pilote$
SELECT * FROM Qualifications$
SELECT * FROM Trace$

--mutating


delimiter $
SET @vs_nombre=0$
CREATE TRIGGER TrigMutant
 AFTER INSERT ON Trace FOR EACH ROW
BEGIN
 DECLARE v_nombre TINYINT;
 SELECT COUNT(*) INTO  @vs_nombre FROM Trace;
END;
$

SELECT * FROM Trace$

SELECT @vs_nombre$

INSERT INTO Trace VALUES ('Test TrigMutant')$

SELECT @vs_nombre$

DROP TRIGGER TrigMutant$
CREATE TRIGGER TrigMutant
 AFTER INSERT ON Trace FOR EACH ROW
BEGIN
 DECLARE v_nombre TINYINT;
 SELECT COUNT(*) INTO  @vs_nombre FROM Trace;
 UPDATE Trace SET col = 'Le trigger est pass l...';
END;
$

SELECT * FROM Trace$

SELECT @vs_nombre$

INSERT INTO Trace VALUES ('Test2 TrigMutant')$

DROP TRIGGER TrigInsQualif$
DROP TRIGGER TrigMutant$
DROP TABLE Trace$

DROP TABLE Qualifications$
DROP TABLE Pilote$
DROP TABLE TypeAvion$

--
-- si grade copil / nbHvol > ... 3cas
--

delimiter ;

CREATE TABLE Pilote
(brevet CHAR(6), nom CHAR(15), nbHVol DECIMAL(7,2), grade CHAR(4),
CONSTRAINT pk_Pilote PRIMARY KEY(brevet));


delimiter $

DROP TRIGGER TrigInsGrade$
CREATE TRIGGER TrigInsGrade
 BEFORE INSERT ON Pilote
 FOR EACH ROW
BEGIN
 IF (NEW.grade = 'CDB' AND (NEW.nbHVol<1000)) THEN 
   SET NEW.grade := 'COPI';
 END IF;
 IF (NEW.grade = 'CDB' AND (NEW.nbHVol>4000)) THEN 
   SET NEW.grade := 'INST';
 END IF;
 IF (NEW.grade = 'COPI' AND (NEW.nbHVol>1000)) THEN 
   SET NEW.grade :=  'CDB';
 END IF;
 IF (NEW.grade = 'INST' AND (NEW.nbHVol<3000)) OR  (NEW.nbHVol<100) THEN 
   SET NEW.grade :=  NULL;
 END IF;
END;
$

--

delimiter ;
INSERT INTO Pilote VALUES ('PL-1', 'Daniel Vielle', 1000, 'CDB');
INSERT INTO Pilote VALUES ('PL-2', 'Benoit Treihlou', 450, 'COPI');
INSERT INTO Pilote VALUES ('PL-3', 'Pierre Filoux', 9000, 'INST');
INSERT INTO Pilote VALUES ('PL-4', 'Philippe Minier', 1000, 'COPI');

--idem

SELECT * FROM Pilote;

--non valide
INSERT INTO Pilote VALUES ('PL-5', 'Trop jeune', 100, 'CDB');
INSERT INTO Pilote VALUES ('PL-6', 'Inexperimente', 2999, 'INST');

SELECT * FROM Pilote;


DROP TRIGGER TrigInsGrade;
DROP TABLE Pilote;




