-- tests exceptions


delimiter ;
DROP TABLE bdutil.Pilote;
CREATE TABLE bdutil.Pilote
	(brevet VARCHAR(6) PRIMARY KEY,
	 nom VARCHAR(20), nbHVol DECIMAL(7,2), comp VARCHAR(4));
INSERT INTO Pilote VALUES ('PL-1', 'Gilles Laborde', 2450, 'AF');
INSERT INTO Pilote VALUES ('PL-2', 'Frdric D''Almeyda', 900, 'AF');
INSERT INTO Pilote VALUES ('PL-3', 'Florence Prissel', 1000, 'SING');
INSERT INTO Pilote VALUES ('PL-4', 'Sonia Dietrich', 2450, 'CAST');
INSERT INTO Pilote VALUES ('PL-5', 'Christine Royo', 200, 'AF');
INSERT INTO Pilote VALUES ('PL-6', 'Aurlia Ente', 2450, 'SING');

SELECT * FROM bdutil.Pilote;

---------------------

--CALL dans un handler

delimiter $

CREATE PROCEDURE bdutil.pasTrouve(IN p_comp VARCHAR(4)) 
BEGIN
  SELECT CONCAT('Il n''y a pas de pilote pour la compagnie ',p_comp) 
        AS 'Resultat procpasTrouve';
END;
$

CREATE PROCEDURE bdutil.procException1 (IN p_comp VARCHAR(4)) 
BEGIN
 DECLARE var1 VARCHAR(20);
 DECLARE EXIT HANDLER FOR NOT FOUND CALL bdutil.pasTrouve(p_comp);

 SELECT nom INTO var1 FROM Pilote WHERE comp = p_comp;
 SELECT CONCAT('Le seul pilote de la compagnie ',p_comp,' est ',var1) 
        AS 'Resultat procException1';
END;
$


CALL procException1('RIEN')$

DROP PROCEDURE bdutil.pasTrouve$
DROP PROCEDURE bdutil.procException1$


--recreer la table + inserts
--essai direct de ER_TOO_MANY_ROWS ...

delimiter $

CREATE PROCEDURE bdutil.procException1 (IN p_comp VARCHAR(4)) 
BEGIN
 DECLARE flagNOTFOUND BOOLEAN DEFAULT 0;
 DECLARE flagPlusDun  BOOLEAN DEFAULT 0;
 DECLARE flagAutre    BOOLEAN DEFAULT 0;
 DECLARE var1 VARCHAR(20);

 BEGIN
   DECLARE EXIT HANDLER FOR ER_TOO_MANY_ROWS SET flagPlusDun  :=1;
   DECLARE EXIT HANDLER FOR NOT FOUND    SET flagNOTFOUND :=1;
   DECLARE EXIT HANDLER FOR SQLEXCEPTION SET flagAutre :=1;

  SELECT nom INTO var1 FROM Pilote WHERE comp = p_comp;
  SELECT CONCAT('Le seul pilote de la compagnie ',p_comp,' est ',var1) AS 'Resultat procException1';
 END;

 IF flagNOTFOUND THEN
  SELECT CONCAT('Il n''y a pas de pilote pour la compagnie ',p_comp) AS 'Resultat procException1';
 END IF; 

 IF flagPlusDun  THEN
  SELECT CONCAT('Il y a plusieurs pilotes pour la compagnie ',p_comp) AS 'Resultat procException1';
 END IF; 

 IF flagAutre THEN
  SELECT CONCAT('Erreur ',' ??') AS 'Resultat procException1';
 END IF; 
END;
$
       
CALL procException1('AF')$
--ERROR 1319 (42000): Undefined CONDITION: ER_TOO_MANY_ROWS

--
DROP PROCEDURE bdutil.procException1$
DROP TABLE bdutil.Pilote$

