-- exceptions

delimiter ;
DROP TABLE bdutil.Pilote;
CREATE TABLE bdutil.Pilote
	(brevet VARCHAR(6) PRIMARY KEY,
	 nom VARCHAR(20), nbHVol DECIMAL(7,2), comp VARCHAR(4));
INSERT INTO bdutil.Pilote VALUES ('PL-1', 'Gilles Laborde', 2450, 'AF');
INSERT INTO bdutil.Pilote VALUES ('PL-2', 'Frdric D''Almeyda', 900, 'AF');
INSERT INTO bdutil.Pilote VALUES ('PL-3', 'Florence Prissel', 1000, 'SING');
INSERT INTO bdutil.Pilote VALUES ('PL-4', 'Sonia Dietrich', 2450, 'CAST');
INSERT INTO bdutil.Pilote VALUES ('PL-5', 'Christine Royo', 200, 'AF');
INSERT INTO bdutil.Pilote VALUES ('PL-6', 'Aurlia Ente', 2450, 'SING');

SELECT * FROM bdutil.Pilote;

-- 2 erreurs


delimiter $

DROP PROCEDURE bdutil.procException1$
CREATE PROCEDURE bdutil.procException1 (IN p_comp VARCHAR(4)) 
BEGIN
DECLARE var1 VARCHAR(20);
SELECT nom INTO var1 FROM Pilote WHERE comp = p_comp;
SELECT CONCAT('Le seul pilote de la compagnie ',p_comp,' est ',var1) AS 'Resultat procException1';
END;
$

CALL bdutil.procException1('AF')$
--ERROR 1172 (42000): Result consisted of more than one row


CALL bdutil.procException1('RIEN')$


CALL bdutil.procException1('CAST')$

CALL bdutil.procException1('CodeDepassantLaTailleDeBeaucoup')$

CALL bdutil.procException1(0123)$

--avec 1 handler

delimiter $

DROP PROCEDURE bdutil.procException1$
CREATE PROCEDURE bdutil.procException1 (IN p_comp VARCHAR(4)) 
BEGIN
 DECLARE flagNOTFOUND BOOLEAN DEFAULT 0;
 DECLARE var1 VARCHAR(20);
 BEGIN
 
    DECLARE EXIT HANDLER FOR NOT FOUND SET flagNOTFOUND :=1;

  SELECT nom INTO var1 FROM Pilote WHERE comp = p_comp;
  SELECT CONCAT('Le seul pilote de la compagnie ',p_comp,' est ',var1) AS 'Resultat procException1';
 END;
 IF flagNOTFOUND THEN
  SELECT CONCAT('Il n''y a pas de pilote pour la compagnie ',p_comp) AS 'Resultat procException1';
 END IF; 
END;
$


CALL bdutil.procException1('AF')$
--ERROR 1172 (42000): Result consisted of more than one row

CALL bdutil.procException1('RIEN')$


CALL bdutil.procException1('CAST')$


--avec 2 handlers



delimiter $

DROP PROCEDURE bdutil.procException1$
CREATE PROCEDURE bdutil.procException1 (IN p_comp VARCHAR(4)) 
BEGIN
 DECLARE flagNOTFOUND BOOLEAN DEFAULT 0;
 DECLARE flagPlusDun  BOOLEAN DEFAULT 0;
 DECLARE var1 VARCHAR(20);

 BEGIN
   DECLARE EXIT HANDLER FOR 1172      SET flagPlusDun  :=1;
   DECLARE EXIT HANDLER FOR NOT FOUND SET flagNOTFOUND :=1;

  SELECT nom INTO var1 FROM Pilote WHERE comp = p_comp;
  SELECT CONCAT('Le seul pilote de la compagnie ',p_comp,' est ',var1) AS 'Resultat procException1';
 END;

 IF flagNOTFOUND THEN
  SELECT CONCAT('Il n''y a pas de pilote pour la compagnie ',p_comp) AS 'Resultat procException1';
 END IF; 

 IF flagPlusDun  THEN
  SELECT CONCAT('Il y a plusieurs pilotes pour la compagnie ',p_comp) AS 'Resultat procException1';
 END IF; 
END;
$


CALL bdutil.procException1('AF')$

CALL bdutil.procException1('RIEN')$

CALL bdutil.procException1('CAST')$



--avec 2 handlers et un OTHERS


delimiter $


DROP PROCEDURE bdutil.procException1$
CREATE PROCEDURE bdutil.procException1 (IN p_comp VARCHAR(4)) 
BEGIN
 DECLARE flagNOTFOUND BOOLEAN DEFAULT 0;
 DECLARE flagPlusDun  BOOLEAN DEFAULT 0;
 DECLARE flagAutre    BOOLEAN DEFAULT 0;

 DECLARE var1 VARCHAR(20);

 BEGIN
   DECLARE EXIT HANDLER FOR 1172         SET flagPlusDun  :=1;
   DECLARE EXIT HANDLER FOR NOT FOUND    SET flagNOTFOUND :=1;
   DECLARE EXIT HANDLER FOR SQLEXCEPTION SET flagAutre :=1;

  SELECT nom INTO var1 FROM Pilote WHERE comp = p_comp;
  SELECT CONCAT('Le seul pilote de la compagnie ',p_comp,' est ',var1) AS 'Resultat procException1';
 END;

 IF flagNOTFOUND THEN
  SELECT CONCAT('Il n''y a pas de pilote pour la compagnie ',p_comp) AS 'Resultat procException1';
 END IF; 

 IF flagPlusDun  THEN
  SELECT CONCAT('Il y a plusieurs pilotes pour la compagnie ',p_comp) AS 'Resultat procException1';
 END IF; 

 IF flagAutre THEN
  SELECT CONCAT('Erreur ',' ??') AS 'Resultat procException1';
 END IF; 
END;
$
       

CALL bdutil.procException1('AF')$

CALL bdutil.procException1('RIEN')$

CALL bdutil.procException1('CAST')$

DROP TABLE bdutil.Pilote$

CALL bdutil.procException1('AF')$

--CALL dans un handler------------------------------

delimiter $

CREATE PROCEDURE bdutil.tropdeLignes(IN p_comp VARCHAR(4))
BEGIN
  SELECT CONCAT('Il y a plusieurs pilotes pour la compagnie ',p_comp)
       AS 'Resultat tropdeLignes';
END;
$


CREATE PROCEDURE bdutil.pasTrouve(IN p_comp VARCHAR(4)) 
BEGIN
  SELECT CONCAT('Il n''y a pas de pilote pour la compagnie ',p_comp) 
        AS 'Resultat pasTrouve';
END;
$

CREATE PROCEDURE bdutil.autreErreur()
BEGIN
  SELECT 'Erreur mais laquelle?' AS 'Resultat autreErreur';
END;
$



DROP PROCEDURE bdutil.procException1$
CREATE PROCEDURE bdutil.procException1 (IN p_comp VARCHAR(4)) 
BEGIN
 DECLARE var1 VARCHAR(20);
 DECLARE EXIT HANDLER FOR 1172         CALL bdutil.tropdeLignes(p_comp);
 DECLARE EXIT HANDLER FOR NOT FOUND    CALL bdutil.pasTrouve(p_comp);
 DECLARE EXIT HANDLER FOR SQLEXCEPTION CALL bdutil.autreErreur();
 SELECT nom INTO var1 FROM Pilote WHERE comp = p_comp;
 SELECT CONCAT('Le seul pilote de la compagnie ',p_comp,' est ',var1) 
        AS 'Resultat procException1';
END;
$


CALL bdutil.procException1('RIEN')$

CALL bdutil.procException1('AF')$

CALL bdutil.procException1('CAST')$


DROP PROCEDURE bdutil.autreErreur$
DROP PROCEDURE bdutil.tropdeLignes$
DROP PROCEDURE bdutil.pasTrouve$
DROP PROCEDURE bdutil.procException1$