
-- exceptions meme inst.

delimiter ;

CREATE TABLE bdutil.Pilote
	(brevet VARCHAR(6) PRIMARY KEY,
	 nom VARCHAR(20), nbHVol DECIMAL(7,2), comp VARCHAR(4));
INSERT INTO bdutil.Pilote VALUES ('PL-1', 'Gilles Laborde', 2450, 'AF');
INSERT INTO bdutil.Pilote VALUES ('PL-2', 'Frdric D''Almeyda', 900, 'AF');
INSERT INTO bdutil.Pilote VALUES ('PL-3', 'Florence Prissel', 1000, 'SING');
INSERT INTO bdutil.Pilote VALUES ('PL-4', 'Sonia Dietrich', 2450, 'CAST');
INSERT INTO bdutil.Pilote VALUES ('PL-5', 'Christine Royo', 200, 'AF');
INSERT INTO bdutil.Pilote VALUES ('PL-6', 'Aurlia Ente', 2450, 'SING');

SELECT * FROM bdutil.Pilote;

--
delimiter $

CREATE PROCEDURE bdutil.procException2
      (IN p_brevet VARCHAR(6),IN p_heures DECIMAL(7,2)) 
BEGIN
 DECLARE v_nom        VARCHAR(20);
 DECLARE flagNOTFOUND BOOLEAN DEFAULT 0;
 DECLARE v_requete    TINYINT;
 
 BEGIN
  DECLARE EXIT HANDLER FOR NOT FOUND SET flagNOTFOUND :=1;
  SET v_requete := 1;
  SELECT nom INTO v_nom FROM bdutil.Pilote
             WHERE brevet = p_brevet;
  SELECT CONCAT('Le pilote de  code ',p_brevet,' est ',v_nom);

  SET v_requete := 2;
  SELECT nom INTO v_nom FROM bdutil.Pilote
             WHERE nbHVol = p_heures;
  SELECT CONCAT('Le pilote ayant ',p_heures,' heures de vol est ',v_nom);
 END;
 
 IF flagNOTFOUND THEN
   IF v_requete = 1 THEN
    SELECT CONCAT('Pas de pilote de brevet : ',p_brevet);
   ELSEIF v_requete = 2 THEN 
    SELECT CONCAT('Pas de pilote ayant ce nombre d''heures de vol : ',p_heures);
   END IF;
 END IF;
END;
$

CALL bdutil.procException2('PL-1', 1000)$

CALL bdutil.procException2('PL-0', 2450)$


DROP PROCEDURE bdutil.procException2$

--grer +sieurs excep

delimiter $

CREATE PROCEDURE bdutil.procException3
      (IN p_brevet VARCHAR(6),IN p_heures DECIMAL(7,2)) 
BEGIN
  DECLARE v_nom        VARCHAR(20);
  DECLARE flagNOTFOUND BOOLEAN DEFAULT 0;
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET flagNOTFOUND := 1;
  SELECT nom INTO v_nom FROM bdutil.Pilote
             WHERE brevet = p_brevet;
  IF flagNOTFOUND THEN
   SELECT CONCAT('Pas de pilote de brevet : ',p_brevet);
   SET flagNOTFOUND := 0;
  ELSE
   SELECT CONCAT('Le pilote de  code ',p_brevet,' est ',v_nom);
  END IF;
 
  SELECT nom INTO v_nom FROM bdutil.Pilote
             WHERE nbHVol = p_heures;
  IF flagNOTFOUND THEN
    SELECT CONCAT('Pas de pilote ayant ce nombre d''heures de vol : ',p_heures);
  ELSE
    SELECT CONCAT('Le pilote ayant ',p_heures,' heures de vol est ',v_nom);
  END IF;
END;
$

delimiter $
CALL bdutil.procException3('PL-1', 1000)$

CALL bdutil.procException3('PL-0', 200)$

CALL bdutil.procException3('PL-0', 500)$

CALL bdutil.procException3('PL-0', 2450)$

DROP PROCEDURE bdutil.procException3$

DROP TABLE bdutil.Pilote$
