

--

CREATE TABLE bdutil.Compagnie
 (comp    CHAR(4),
  nrue    INTEGER(3),
  rue     CHAR(20),
  ville   CHAR(15) DEFAULT 'Paris' COMMENT 'Par defaut : Paris',
  nomComp CHAR(15) NOT NULL);

desc bdutil.Compagnie;

DROP TABLE bdutil.Compagnie;
--

CREATE TABLE Compagnie
(comp CHAR(4), nrue INTEGER(3),
 rue CHAR(20), ville CHAR(15) DEFAULT 'Paris' COMMENT 'Par defaut : Paris',
 nomComp CHAR(15) NOT NULL,
 CONSTRAINT pk_Compagnie PRIMARY KEY(comp));

CREATE TABLE Pilote
(brevet CHAR(6), nom CHAR(15),
 nbHVol DECIMAL(7,2), compa CHAR(4),
 CONSTRAINT pk_Pilote PRIMARY KEY(brevet),
 CONSTRAINT nn_nom CHECK (nom IS NOT NULL),
 CONSTRAINT ck_nbHVol CHECK (nbHVol BETWEEN 0 AND 20000),
 CONSTRAINT un_nom UNIQUE (nom),
 CONSTRAINT fk_Pil_compa_Comp FOREIGN KEY (compa) REFERENCES Compagnie(comp));


SHOW CREATE TABLE Compagnie;

SHOW FULL COLUMNS FROM Compagnie;

SHOW CREATE TABLE Pilote;

SHOW FULL COLUMNS FROM Pilote;

--

INSERT INTO Compagnie	VALUES ('AF', 10, 'Gambetta', 'Paris', 'Air France');
INSERT INTO Compagnie   VALUES ('SING', 7, 'Camparols', 'Singapour', 'Singapore AL');

INSERT INTO Pilote VALUES ('PL-1', 'Louise Ente', 450, 'AF');
INSERT INTO Pilote VALUES ('PL-2', 'Jules Ente', 900, 'AF');
INSERT INTO Pilote VALUES ('PL-3', 'Paul Soutou', 1000, 'SING');

--a passe... contrainte hors ligne NOT NULL !...
INSERT INTO Pilote VALUES ('PL-4', NULL, 1000, 'SING');

--a passe...  aussi
INSERT INTO Pilote VALUES ('PL-5','PB sur Check', 30000, 'SING');


-----------------------------
DROP TABLE Pilote;

CREATE TABLE Pilote
(brevet CHAR(6), nom CHAR(15) NOT NULL,
 nbHVol DECIMAL(7,2), compa CHAR(4),
 CONSTRAINT pk_Pilote PRIMARY KEY(brevet),
 CONSTRAINT ck_nbHVol CHECK (nbHVol BETWEEN 0 AND 20000),
 CONSTRAINT un_nom UNIQUE (nom),
 CONSTRAINT fk_Pil_compa_Comp FOREIGN KEY (compa) REFERENCES Compagnie(comp));

--Contrainte en ligne NOT NULL : OK
INSERT INTO Pilote VALUES ('PL-4', NULL, 1000, 'SING');
--ERROR 1048 (23000): Column 'nom' cannot be null

----------------------------------------
DROP TABLE Pilote;

CREATE TABLE Pilote
(brevet CHAR(6), nom CHAR(15),
 nbHVol DECIMAL(7,2), compa CHAR(4) REFERENCES Compagnie(comp),
 CONSTRAINT pk_Pilote PRIMARY KEY(brevet),
 CONSTRAINT nn_nom CHECK (nom IS NOT NULL),
 CONSTRAINT un_nom UNIQUE (nom));


SELECT CONSTRAINT_NAME, CONSTRAINT_TYPE,TABLE_NAME
	FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS ;

SELECT CONSTRAINT_NAME,TABLE_NAME,COLUMN_NAME 
	FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE ;

DROP TABLE Pilote;
DROP TABLE Compagnie;

--
Types

--caractres

CREATE TABLE tchar (f CHAR(4), v VARCHAR(4));

INSERT INTO tchar VALUES ('ab ', 'ab ');

SELECT * FROM tchar ;

SELECT CONCAT(f,'+'), CONCAT(v,'+') FROM tchar;

DROP TABLE tchar;
--


CREATE TABLE tbinary (fixe BINARY(4), variable VARBINARY(4));

INSERT INTO tbinary VALUES ('ab ', 'ab ');

SELECT * FROM tbinary ;

SELECT CONCAT(fixe,'+'), CONCAT(variable,'+') FROM tbinary ;

DROP TABLE tbinary;

--numriques

CREATE TABLE tnum (t TINYINT(4) UNSIGNED);

INSERT INTO tnum VALUES (255);

SELECT * FROM tnum ;

DROP TABLE tnum;

--index

CREATE TABLE Compagnie
(comp CHAR(4), nrue INTEGER(3),
 rue CHAR(20), ville CHAR(15) DEFAULT 'Paris' COMMENT 'Par defaut : Paris',
 nomComp CHAR(15) NOT NULL,
 CONSTRAINT pk_Compagnie PRIMARY KEY(comp));

CREATE TABLE Pilote
(brevet CHAR(6), nom CHAR(15) NOT NULL,
 nbHVol DECIMAL(7,2), compa CHAR(4),
 CONSTRAINT pk_Pilote PRIMARY KEY(brevet),
 CONSTRAINT ck_nbHVol CHECK (nbHVol BETWEEN 0 AND 20000),
 CONSTRAINT un_nom UNIQUE (nom),
 CONSTRAINT fk_Pil_compa_Comp FOREIGN KEY (compa) REFERENCES Compagnie(comp));

CREATE UNIQUE INDEX idx_Pilote_nom3
	USING BTREE
	ON Pilote (nom(3) DESC);

CREATE INDEX idx_Pilote_compa
	USING BTREE
	ON Pilote (compa);


DROP INDEX idx_Pilote_nom3 ON Pilote ;
DROP INDEX idx_Pilote_compa ON Pilote ;

--- pas encore OK
DROP TABLE Compagnie CASCADE;

--OK 
DROP TABLE Pilote;
DROP TABLE Compagnie;

--

CREATE TABLE tableMyISAM 
(
  col1 INT(11) AUTO_INCREMENT,
  col2 CHAR(60) ,
  PRIMARY KEY (col1)
) ENGINE=MyISAM;

CREATE TABLE tableINNODB
(
  col1 INT(11) AUTO_INCREMENT,
  col2 CHAR(60) ,
  PRIMARY KEY (col1)
) ENGINE=INNODB;

CREATE TABLE tableDefaut
(
  col1 INT(11) AUTO_INCREMENT,
  col2 CHAR(60) ,
  PRIMARY KEY (col1)
);

SHOW ENGINES;

SHOW TABLE STATUS;

DROP TABLE tableMyISAM ;
DROP TABLE tableINNODB;
DROP TABLE tableDefaut;




