

--DATE + n (jours)
SELECT ADDDATE('2005-01-02', 54);

--DATETIME + n (jours)
SELECT ADDDATE('2005-11-01 18:50:00', 54);


--TIME + TIME 
SELECT ADDTIME('01:00:00.999999', '02:00:00.999998');

--TIME + n (secondes)
SELECT ADDTIME('01:00:00.999999', 54);

--DATE ou DATETIME + - INTERVAL

SELECT DATE_SUB('2005-11-01 18:50:00',INTERVAL '1 1:1:1' DAY_SECOND);

SELECT DATE_ADD('2005-11-01 18:50:00',INTERVAL '1 1:1:1' DAY_SECOND);

SELECT DATE_SUB('2005-11-01',INTERVAL '1' DAY);

SELECT DATE_ADD('2005-11-01',INTERVAL '1' DAY);

SELECT DATEDIFF(SYSDATE(),'1965-02-05');

SELECT DATEDIFF(SYSDATE(),'1995-05-13');

--

DROP TABLE Pilote;
CREATE TABLE Pilote
 (brevet VARCHAR(6), nom VARCHAR(20), dateNaiss DATETIME, dernierVol DATE,
  dateEmbauche DATETIME, prochainVolControle DATETIME, 
  nombreJoursNaisBoulot INTEGER(5),
  intervalleNaisBoulot DECIMAL(20,6), 
  intervalleVolExterieur DECIMAL(10,6),
  intervalleEntreVols DECIMAL(10,6),
  intervalleEmbaucheControle TIME,
  compa VARCHAR(4), CONSTRAINT pk_Pilote PRIMARY KEY(brevet));

INSERT INTO Pilote VALUES 
 ('PL-1', 'Thierry Albaric','1967-03-25','2005-10-30', SYSDATE(),
  '2006-11-13 15:30:00', NULL, NULL, NULL, NULL, NULL, 'AF');

SELECT * FROM Pilote;

--et le thme astral...
UPDATE Pilote 
 SET dateNaiss = '1967-03-25 12:35:00' 
 WHERE brevet = 'PL-1';

SELECT nom, dateNaiss FROM Pilote;

SELECT nom, dateEmbauche FROM Pilote;

SELECT nom, dernierVol FROM Pilote;

SELECT nom, prochainVolControle FROM Pilote;

--revenez la semaine prochaine + 10minutes , on vous crira srement d'ici l
UPDATE Pilote
 SET dateEmbauche = DATE_ADD(dateEmbauche,
                INTERVAL  '7 0:10' DAY_MINUTE)
 WHERE brevet = 'PL-1';

SELECT nom, dateEmbauche FROM Pilote;

--Attendre en jours avant la premire paye

UPDATE Pilote
	SET nombreJoursNaisBoulot = DATEDIFF(dateEmbauche,dateNaiss)
	 WHERE brevet = 'PL-1';

SELECT nombreJoursNaisBoulot  FROM Pilote;

--au format intervalle jour,decimales
--TIMESTAMPDIFF(interval,datetime_expr1,datetime_expr2) 

SELECT TIMESTAMPDIFF(SECOND,dateNaiss,dateEmbauche)/(24*3600) "j" FROM Pilote;
SELECT TIMESTAMPDIFF(SECOND,dernierVol,prochainVolControle)/(24*3600) "j" FROM Pilote;
SELECT TIMESTAMPDIFF(SECOND,dernierVol,dateEmbauche)/(24*3600) "j" FROM Pilote;

------------------------------

UPDATE Pilote
 SET intervalleNaisBoulot   = TIMESTAMPDIFF(SECOND,dateNaiss,dateEmbauche)/(24*3600) ,
     intervalleEntreVols    = TIMESTAMPDIFF(SECOND,dernierVol,prochainVolControle)/(24*3600) ,
     intervalleVolExterieur = TIMESTAMPDIFF(SECOND,dernierVol,dateEmbauche)/(24*3600) 
 WHERE brevet = 'PL-1';

SELECT nom, dateNaiss,dateEmbauche FROM Pilote;
SELECT dernierVol ,prochainVolControle FROM Pilote;
SELECT intervalleNaisBoulot FROM Pilote;
SELECT intervalleEntreVols FROM Pilote;
SELECT intervalleVolExterieur FROM Pilote;
SELECT intervalleNaisBoulot FROM Pilote;


--intervalleEmbaucheControle 

--au format dcimal
SELECT(intervalleEntreVols - intervalleVolExterieur) FROM Pilote;

--au format TIME (si la diffrence < 839 h soit 34,95 jours)
--SELECT SEC_TO_TIME((14.645833-10.651181)*3600*24);
--SELECT SEC_TO_TIME((intervalleEntreVols - intervalleVolExterieur)*24*3600) FROM Pilote;

UPDATE Pilote SET intervalleEmbaucheControle =
      SEC_TO_TIME((intervalleEntreVols - intervalleVolExterieur)*24*3600) 
WHERE brevet = 'PL-1';



SELECT nom, intervalleEmbaucheControle FROM Pilote;


--DATE_FORMAT
    
SELECT DATE_FORMAT(SYSDATE(),'%j');
        
SELECT DATE_FORMAT(dateNaiss,'%W en %M %X') FROM Pilote;

SELECT STR_TO_DATE('11/09/2005 15:37:42','%d/%m/%Y %H:%i:%s');

--EXTRACT

SELECT EXTRACT(DAY FROM dateEmbauche) FROM Pilote;

SELECT EXTRACT(MONTH FROM dateNaiss) FROM Pilote;	

SELECT UNIX_TIMESTAMP(SYSDATE())/(24*3600);

--FROM_DAYS(N) 

SELECT FROM_DAYS(366);    
    
--

DROP TABLE Pilote;