
-------------
CREATE TABLE Compagnie
(comp VARCHAR(4), nrue SMALLINT(3), rue VARCHAR(20), ville VARCHAR(15), nomComp VARCHAR(15),
 CONSTRAINT pk_Compagnie PRIMARY KEY(comp));

CREATE TABLE Pilote
(brevet VARCHAR(6), nom CHAR(20), nbHVol DECIMAL(7,2), compa VARCHAR(4), chefPil VARCHAR(6),
CONSTRAINT pk_Pilote PRIMARY KEY(brevet),
CONSTRAINT fk_Pil_compa_Comp FOREIGN KEY(compa) REFERENCES Compagnie(comp),
 CONSTRAINT fk_Pil_chefPil_Pil FOREIGN KEY(chefPil) REFERENCES Pilote(brevet));

INSERT INTO Compagnie	VALUES ('AF', 124, 'Port Royal', 'Paris', 'Air France');
INSERT INTO Compagnie   VALUES ('SING', 7, 'Camparols', 'Singapour', 'Singapore AL');
INSERT INTO Compagnie   VALUES ('CAST', 1, 'G. Brassens', 'Blagnac', 'Castanet AL');

INSERT INTO Pilote VALUES ('PL-4', 'Henri Alqui', 3400, 'AF',NULL);
INSERT INTO Pilote VALUES ('PL-1', 'Pierre Lamothe', 450, 'AF', 'PL-4');
INSERT INTO Pilote VALUES ('PL-2', 'Didier Linxe', 900, 'AF','PL-4');
INSERT INTO Pilote VALUES ('PL-3', 'Christian Soutou', 1000, 'SING',NULL);

--R1
--relationnelle
SELECT  brevet, nom
	FROM Pilote, Compagnie
	WHERE comp    = compa 
	AND   nomComp = 'Air France'
	AND   nbHVol  > 500;

SELECT  pil.brevet, pil.nom
	FROM Pilote pil, Compagnie cpg
	WHERE cpg.comp    = pil.compa 
	AND   cpg.nomComp = 'Air France'
	AND   pil.nbHVol  > 500;


--SQL2
SELECT  brevet, nom
	FROM Compagnie JOIN Pilote ON comp = compa
	WHERE nomComp = 'Air France'
	AND   nbHVol  > 500;

SELECT  brevet, nom
	FROM Compagnie INNER JOIN Pilote ON comp = compa
	WHERE nomComp = 'Air France'
	AND   nbHVol  > 500;

--R2
--relationnelle
SELECT  cpg.nomComp, cpg.nrue, cpg.rue, cpg.ville
	FROM Pilote pil, Compagnie cpg
	WHERE cpg.comp    = pil.compa 
	AND   pil.nbHVol < 500;

--SQL2
SELECT  nomComp, nrue, rue, ville
	FROM Compagnie JOIN Pilote ON comp = compa
	WHERE nbHVol < 500;

SELECT  nomComp, nrue, rue, ville
	FROM Compagnie INNER JOIN Pilote ON comp = compa
	WHERE nbHVol  < 500;
--R3
--relationnelle
SELECT p1.brevet, p1.nom 
	FROM Pilote p1, Pilote p2
	WHERE p1.chefPil = p2.brevet
	AND p2.nom LIKE '%Alqui%';
--SQL2
SELECT  p1.brevet, p1.nom 
	FROM Pilote p1 JOIN Pilote p2 ON p1.chefPil = p2.brevet
	WHERE p2.nom LIKE '%Alqui%';
--R4
--relationnelle
SELECT SUM(p1.nbHVol) 
	FROM Pilote p1, Pilote p2, Compagnie cpg
	WHERE p1.chefPil = p2.brevet
	AND cpg.comp = p2.compa
	AND cpg.nomComp = 'Air France';
--SQL2
SELECT  SUM(p1.nbHVol)
	FROM Pilote p1 JOIN Pilote p2 ON p1.chefPil = p2.brevet
		JOIN Compagnie ON comp = p2.compa
		WHERE nomComp = 'Air France';


--inquijoin

CREATE TABLE HeuresVol(titre CHAR(20), basnbHVol DECIMAL(7,2), hautnbHVol DECIMAL(7,2));
INSERT INTO HeuresVol VALUES ('Dbutant', 0, 500);
INSERT INTO HeuresVol VALUES ('Initi', 501, 1000);
INSERT INTO HeuresVol VALUES ('Expert', 1001, 5000);


--R5
--relationnelle
SELECT p1.brevet, p1.nom, p1.nbHVol, p2.nbHVol "Rfrence"
	FROM Pilote p1, Pilote p2
	WHERE p1.nbHVol > p2.nbHVol
	AND p2.brevet = 'PL-2';
--SQL2
SELECT  p1.brevet, p1.nom, p1.nbHVol, p2.nbHVol "Rfrence"
	FROM Pilote p1 JOIN Pilote p2 ON p1.nbHVol > p2.nbHVol
		WHERE p2.brevet = 'PL-2';

--R6
--relationnelle
SELECT  pil.brevet, pil.nom, pil.nbHVol, hv.titre
	FROM Pilote pil, HeuresVol hv
	WHERE pil.nbHVol BETWEEN hv.basnbHVol AND hv.hautnbHVol;
--SQL2
SELECT  brevet, nom, nbHVol, titre
	FROM Pilote INNER JOIN HeuresVol ON nbHVol BETWEEN basnbHVol AND hautnbHVol;


--externes

CREATE TABLE Qualifs
	(brevet VARCHAR(6), typeAv CHAR(4), validite DATE);
INSERT INTO Qualifs VALUES ('PL-4', 'A320','2005-06-24');
INSERT INTO Qualifs VALUES ('PL-4', 'A340','2005-06-24');
INSERT INTO Qualifs VALUES ('PL-2', 'A320','2006-04-04');
INSERT INTO Qualifs VALUES ('PL-3', 'A330','2006-05-13');

--

--R7

--SQL2
--quivalents
SELECT  nomComp, brevet, nom
	FROM Compagnie LEFT OUTER JOIN Pilote ON comp = compa;
SELECT  nomComp, brevet, nom
	FROM Pilote RIGHT OUTER JOIN Compagnie ON comp = compa;

--R8
--SQL2
--quivalents
SELECT qua.typeAv, pil.brevet, pil.nom
	FROM Qualifs qua RIGHT OUTER JOIN Pilote pil ON pil.brevet = qua.brevet;

SELECT  qua.typeAv, pil.brevet, pil.nom
	FROM Pilote pil LEFT OUTER JOIN Qualifs qua ON pil.brevet = qua.brevet;


---2 sens
INSERT INTO Pilote VALUES ('PL-5', 'Michel Castaings', 0, NULL,NULL);
DELETE FROM Qualifs WHERE brevet = 'PL-4' AND typeAv = 'A340';
INSERT INTO Qualifs VALUES ('PL-7', 'A380','2007-07-20');

SELECT * FROM Qualifs;

SELECT * FROM Pilote;


--R9
--SQL92
--BUG POUR LA V 5.0
SELECT  nomComp, brevet, nom
	FROM Pilote FULL OUTER JOIN Compagnie ON comp = compa;

SELECT  nomComp, brevet, nom
	FROM Compagnie FULL OUTER JOIN Pilote ON comp = compa;

--R10
--SQL92
--BUG POUR LA V 5.0
SELECT qua.typeAv, pil.brevet, pil.nom
	FROM Pilote pil FULL OUTER JOIN Qualifs qua ON pil.brevet = qua.brevet;
SELECT  qua.typeAv, pil.brevet, pil.nom
	FROM Qualifs qua FULL OUTER JOIN Pilote pil ON pil.brevet = qua.brevet;


--Autres directives SQL92
--Procdurales
--R1
SELECT  brevet, nom
	FROM Pilote
	WHERE compa = (SELECT comp FROM Compagnie WHERE nomComp = 'Air France')
	AND nbHVol>500;

--R3
SELECT brevet, nom 
	FROM Pilote	 
	WHERE chefPil = (SELECT brevet FROM Pilote WHERE nom LIKE '%Alqui%');

--R2
SELECT  nomComp, nrue, rue, ville
	FROM Compagnie
	WHERE comp IN (SELECT compa FROM Pilote WHERE nbHVol<500);
--R4
SELECT SUM(nbHVol) 
	FROM Pilote
	WHERE chefPil IN 
	(SELECT brevet FROM Pilote WHERE compa 
		= (SELECT comp FROM Compagnie WHERE nomComp = 'Air France')
	);

--R5
SELECT brevet, nom, nbHVol
 FROM Pilote
WHERE nbHVol > 
	(SELECT nbHVol FROM Pilote WHERE brevet = 'PL-2');

--R7
SELECT  nomComp, nrue, rue, ville
	FROM Compagnie
	WHERE comp IN (SELECT compa FROM Pilote WHERE compa IS NOT NULL)
UNION
SELECT  nomComp, nrue, rue, ville
	FROM Compagnie
	WHERE comp NOT IN (SELECT compa FROM Pilote WHERE compa IS NOT NULL);

--NOT IN
SELECT  nomComp, nrue, rue, ville
 FROM Compagnie
 WHERE comp NOT IN
      (SELECT compa FROM Pilote
       WHERE compa IS NOT NULL);



CREATE TABLE Avion
	(immat VARCHAR(6), typeAv CHAR(4), nbHVol DECIMAL(7,2), compa VARCHAR(4));

INSERT INTO Avion VALUES ('A1', 'A320', 1000, 'AF');
INSERT INTO Avion VALUES ('A2', 'A330', 1500, 'AF');
INSERT INTO Avion VALUES ('A3', 'A320', 550, 'SING');
INSERT INTO Avion VALUES ('A4', 'A340', 1800, 'SING');
INSERT INTO Avion VALUES ('A5', 'A340', 200, 'AF');
INSERT INTO Avion VALUES ('A6', 'A330', 100, 'AF');

--R11
SELECT  immat, typeAv, nbHVol
	FROM Avion 
	WHERE nbHVol < ANY (SELECT nbHVol FROM Avion WHERE typeAv='A320');

--R12
SELECT  immat, typeAv, nbHVol, compa
	FROM Avion 
	WHERE nbHVol > ANY (SELECT nbHVol FROM Avion WHERE compa = 'SING');

--R13
SELECT  immat, typeAv, nbHVol
	FROM Avion 
	WHERE nbHVol < ALL (SELECT nbHVol FROM Avion WHERE typeAv='A320');
--R14
SELECT  immat, typeAv, nbHVol, compa
	FROM Avion 
	WHERE nbHVol > ALL (SELECT nbHVol FROM Avion WHERE compa = 'AF');

--Mixte
--R4
SELECT SUM(p1.nbHVol)
	FROM Pilote p1, Pilote p2
	WHERE p1.chefPil = p2.brevet
	AND p2.compa = (SELECT comp FROM Compagnie WHERE nomComp = 'Air France');

--SELECT dans le FROM
SELECT a.compa "Comp",
       a.nbpil/b.total*100 "%Pilote"
  FROM (SELECT compa, COUNT(*) nbpil
               FROM Pilote  GROUP BY compa) a,
       (SELECT COUNT(*) total
               FROM Pilote) b;


---Synchronisation
--R15
SELECT  avi1.*
FROM Avion avi1
WHERE avi1.nbHVol > (SELECT AVG(avi2.nbHVol) FROM Avion avi2 WHERE avi2.compa = avi1.compa);


---EXISTS
--R16
SELECT  pil1.brevet, pil1.nom, pil1.compa
	FROM Pilote pil1 
	WHERE EXISTS (SELECT pil2.* FROM Pilote pil2 WHERE pil2.chefPil=pil1.brevet);

--NOT EXISTS
SELECT  cpg.*
	FROM Compagnie cpg
	WHERE NOT EXISTS (SELECT compa FROM Pilote WHERE compa=cpg.comp);

--

CREATE TABLE Naviguant
(brevet VARCHAR(6), nom CHAR(20), nbHVol DECIMAL(7,2), typeAv VARCHAR(6),
CONSTRAINT pk_Naviguant PRIMARY KEY(brevet) );

INSERT INTO Naviguant VALUES ('PL-1', 'Pierre Lamothe', 450, NULL);
INSERT INTO Naviguant VALUES ('PL-2', 'Didier Linxe', 900, 'A320');
INSERT INTO Naviguant VALUES ('PL-3', 'Henri Alqui', 3400, 'A380');


--externes

CREATE TABLE VolsControle(brevet VARCHAR(6), typeAv VARCHAR(6), validite DATE);

INSERT INTO  VolsControle VALUES ('PL-1', 'A320','2005-06-24');
INSERT INTO VolsControle VALUES ('PL-2', 'A320','2006-04-04');
INSERT INTO VolsControle VALUES ('PL-2', 'A330','2006-05-13');
INSERT INTO VolsControle VALUES ('PL-3', 'A380','2007-07-20');
INSERT INTO VolsControle VALUES ('PL-3', 'A320','2005-03-12');

--SQL2

--naturelle1

SELECT brevet, nom, typeAv, validite
FROM Naviguant NATURAL JOIN VolsControle;

SELECT brevet, nom, typeAv, validite
FROM VolsControle NATURAL JOIN Naviguant ;


SELECT brevet, nom, typeAv, validite
FROM VolsControle NATURAL JOIN Naviguant
WHERE nbHVol BETWEEN 100 AND 4000
AND validite > SYSDATE() ;

--restreinte

SELECT nom, v.typeAv, v.validite
FROM Naviguant JOIN VolsControle v USING (brevet);

SELECT nom, v.typeAv, v.validite
FROM VolsControle v JOIN Naviguant USING (brevet);


--produit cartsien

SELECT * FROM Naviguant CROSS JOIN VolsControle;

SELECT * FROM VolsControle CROSS JOIN Naviguant;

DROP TABLE Avion;
DROP TABLE VolsControle;
DROP TABLE Naviguant;
DROP TABLE Qualifs;
DROP TABLE Pilote;
DROP TABLE Compagnie;
DROP TABLE HeuresVol;

