--Restrictions

CREATE TABLE Pilote
	(brevet VARCHAR(6),
	 nom VARCHAR(16), nbHVol DECIMAL(7,2), prime SMALLINT(4), compa VARCHAR(4));

INSERT INTO Pilote VALUES ('PL-1', 'Gratien Viel',     450, 500, 'AF');
INSERT INTO Pilote VALUES ('PL-2', 'Didier Donsez',     0, NULL,    'AF');
INSERT INTO Pilote VALUES ('PL-3', 'Richard Grin',     1000, 90, 'SING');
INSERT INTO Pilote VALUES ('PL-4', 'Placide Fresnais', 2450, 500, 'CAST');
INSERT INTO Pilote VALUES ('PL-5', 'Daniel Vielle',    400, 600, 'SING');
INSERT INTO Pilote VALUES ('PL-6', 'Francoise Tort',    NULL, 0, 'CAST');

--math
SELECT brevet, nom AS "Prime 500"  FROM Pilote WHERE prime = 500;
SELECT brevet, nom "de Air-France" FROM Pilote WHERE compa = 'AF';
SELECT brevet, nom, prime  FROM Pilote WHERE prime <= 400;
SELECT brevet, nom, prime  FROM Pilote WHERE prime <> 500;
SELECT brevet, nom, prime  FROM Pilote WHERE NOT(prime = 500);


--logique
SELECT brevet, nom, compa
	FROM Pilote WHERE (compa = 'SING' OR compa = 'AF' AND nbHVol < 500);

SELECT brevet, nom, compa
	FROM Pilote WHERE ((compa = 'SING'  OR compa = 'AF') AND nbHVol < 500);

--intgrs
SELECT brevet, nom, nbHVol FROM Pilote WHERE nbHVol BETWEEN 399 AND 1000;
SELECT brevet, nom, compa FROM Pilote WHERE compa IN ('CAST', 'SING');

SELECT brevet, nom, compa FROM Pilote WHERE compa LIKE ('%A%');
SELECT brevet, nom, compa FROM Pilote WHERE compa LIKE ('A_');

SELECT nom, prime, nbHVol FROM Pilote WHERE prime IS NULL OR nbHVol IS NULL;

SELECT nom, prime, nbHVol, compa FROM Pilote WHERE prime IS NOT NULL ;
SELECT nom, prime, nbHVol, compa FROM Pilote WHERE NOT (prime IS NULL) ;


SELECT aliasDesPilotes.compa AS c1, aliasDesPilotes.nom FROM Pilote aliasDesPilotes
--	WHERE c1='AF';
	WHERE aliasDesPilotes.compa='AF';

DROP TABLE Pilote;

