
DESCRIBE INFORMATION_SCHEMA.SCHEMATA;

 CATALOG_NAME
 SCHEMA_NAME
 DEFAULT_CHARACTER_SET_NAME
 DEFAULT_COLLATION_NAME
 SQL_PATH

SELECT SCHEMA_NAME AS 'Base de donnees', 
  DEFAULT_CHARACTER_SET_NAME AS 'Jeu caracteres', DEFAULT_COLLATION_NAME 'Collation'
  FROM INFORMATION_SCHEMA.SCHEMATA;




INFORMATION_SCHEMA STATISTICS 

INFORMATION_SCHEMA VIEWS 





-----------------ex sur une vue

CREATE TABLE Pilote
(brevet CHAR(6), nom CHAR(15), nbHVol DECIMAL(7,2), grade CHAR(4),
CONSTRAINT pk_Pilote PRIMARY KEY(brevet));

--

INSERT INTO Pilote (brevet,nom,nbHVol,grade)
	VALUES ('PL-1', 'Daniel Vielle', 1000, 'CDB');


CREATE VIEW VueDesPilotesJoursOuvrables
  AS SELECT * FROM Pilote
  WHERE CURTIME()+0 BETWEEN 83000 AND 173000
  AND DATE_FORMAT(SYSDATE(),'%W') NOT IN ('Sunday', 'Saturday')
  AND CURRENT_USER() = 'root@localhost'
  WITH CHECK OPTION;

CREATE VIEW bdnouvelle.VueDesSocietes
  AS SELECT * FROM Pilote
  WHERE CURTIME()+0 BETWEEN 03000 AND 173000
  AND DATE_FORMAT(SYSDATE(),'%W') NOT IN ('Sunday', 'Saturday');


DESCRIBE INFORMATION_SCHEMA.VIEWS;

SELECT TABLE_SCHEMA,TABLE_NAME,CHECK_OPTION FROM INFORMATION_SCHEMA.VIEWS;

SELECT TABLE_NAME,VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS;

SELECT TABLE_SCHEMA,  FROM INFORMATION_SCHEMA.VIEWS;


SELECT TABLE_SCHEMA,TABLE_NAME,CHECK_OPTION FROM INFORMATION_SCHEMA.VIEWS
WHERE  TABLE_SCHEMA='bdsoutou';


DROP VIEW bdnouvelle.VueDesSocietes;
DROP VIEW VueDesPilotesJoursOuvrables;
DROP TABLE Pilote;


--Database

--creation d'une TEMP dans bdouvelle

CREATE TEMPORARY TABLE bdnouvelle.Impots (rien CHAR(1));
--n'apparait pas dans le dd

DESCRIBE INFORMATION_SCHEMA.TABLES; 

SELECT TABLE_SCHEMA,TABLE_NAME,TABLE_TYPE,DATE(CREATE_TIME) FROM INFORMATION_SCHEMA.TABLES
WHERE TABLE_SCHEMA NOT IN ('information_schema','test','mysql');

SELECT ENGINE,AUTO_INCREMENT,TABLE_ROWS,AVG_ROW_LENGTH,DATA_LENGTH FROM INFORMATION_SCHEMA.TABLES
WHERE TABLE_SCHEMA = 'bdsoutou' AND TABLE_NAME='Installer';


SELECT TABLE_NAME,
  TABLE_COMMENT
 FROM INFORMATION_SCHEMA.TABLES
WHERE TABLE_SCHEMA NOT IN ('information_schema','test','mysql');

DROP TEMPORARY TABLE bdnouvelle.Impots;

---------------------------Tables
         
DESCRIBE INFORMATION_SCHEMA.COLUMNS;

  
SELECT COLUMN_NAME,DATA_TYPE,ORDINAL_POSITION,COLUMN_DEFAULT,COLUMN_KEY 
       FROM INFORMATION_SCHEMA.COLUMNS 
WHERE TABLE_SCHEMA = 'bdsoutou' AND TABLE_NAME='Installer';

       
SELECT COLUMN_NAME,DATA_TYPE,CHARACTER_OCTET_LENGTH AS 'Taille max',IS_NULLABLE
       FROM INFORMATION_SCHEMA.COLUMNS 
WHERE TABLE_SCHEMA = 'bdsoutou' AND TABLE_NAME='Installer'
AND NUMERIC_PRECISION IS NULL AND DATA_TYPE NOT IN ('timestamp','time','date');


SELECT COLUMN_NAME,DATA_TYPE,NUMERIC_PRECISION AS 'Taille max',NUMERIC_SCALE AS 'Prcision'  
       FROM INFORMATION_SCHEMA.COLUMNS 
WHERE TABLE_SCHEMA = 'bdsoutou' AND TABLE_NAME='Installer'
AND CHARACTER_MAXIMUM_LENGTH IS NULL
AND DATA_TYPE NOT IN ('timestamp','time','date');


SELECT COLUMN_NAME,DATA_TYPE,COLUMN_DEFAULT
FROM INFORMATION_SCHEMA.COLUMNS 
WHERE TABLE_SCHEMA = 'bdsoutou' AND TABLE_NAME='Installer'
AND CHARACTER_MAXIMUM_LENGTH IS NULL
AND DATA_TYPE IN ('timestamp','time','date');


--contraintes 

The TABLE_CONSTRAINTS table describes which tables have constraints. 

SELECT
CONSTRAINT_SCHEMA ,    
CONSTRAINT_NAME    , 
CONSTRAINT_TYPE
FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS 
WHERE TABLE_SCHEMA = 'bdsoutou' AND TABLE_NAME='Installer';


CREATE TABLE test.testCont
(col1     varchar(7),
 col2       varchar(5),
 numIns     INTEGER(5) AUTO_INCREMENT,
 CONSTRAINT pk_Installer PRIMARY KEY(numIns),
 CONSTRAINT un_Installer UNIQUE(col1),
 CONSTRAINT ck_Installer CHECK NOT (col2  = 'MySQL' ));

SELECT
CONSTRAINT_SCHEMA,CONSTRAINT_NAME,CONSTRAINT_TYPE
FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS 
WHERE TABLE_SCHEMA = 'test' AND TABLE_NAME='testCont';

+-------------------+-----------------+-----------------+
| CONSTRAINT_SCHEMA | CONSTRAINT_NAME | CONSTRAINT_TYPE |
+-------------------+-----------------+-----------------+
| test              | PRIMARY         | PRIMARY KEY     |
| test              | un_Installer    | UNIQUE          |
+-------------------+-----------------+-----------------+

DROP TABLE test.testCont;

--nature d'une cl primaire (idem pour les FK)

DESC INFORMATION_SCHEMA.KEY_COLUMN_USAGE ;

SELECT CONSTRAINT_NAME, COLUMN_NAME, ORDINAL_POSITION AS 'Position',
 POSITION_IN_UNIQUE_CONSTRAINT AS 'Position index'
       FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE 
WHERE TABLE_SCHEMA = 'bdsoutou' AND TABLE_NAME='Installer';


--ou vont les cls trangres?


SELECT CONSTRAINT_NAME, COLUMN_NAME AS 'Cle', 
 REFERENCED_TABLE_SCHEMA AS 'Base cible',REFERENCED_TABLE_NAME AS 'Table pere',
REFERENCED_COLUMN_NAME AS 'Col pere'
       FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE 
WHERE TABLE_SCHEMA = 'bdsoutou' AND TABLE_NAME='Installer'
AND REFERENCED_TABLE_SCHEMA IS NOT NULL;


--source procdure-------------------------------------------


--jeu essai

delimiter $

CREATE PROCEDURE test.sp1()
BEGIN
  DECLARE v_brevet CHAR(6);
  SET v_brevet := 'PROC';
END;
$

CREATE FUNCTION test.sp2() RETURNS CHAR(3)
BEGIN
  DECLARE v_brevet CHAR(3);
  SET v_brevet := 'FCT';
  RETURN v_brevet ;
END;
$

delimiter ;
--------------------------------------

DESC INFORMATION_SCHEMA.ROUTINES ;

SPECIFIC_NAME
ROUTINE_CATALOG
ROUTINE_SCHEMA

DTD_IDENTIFIER
ROUTINE_BODY

EXTERNAL_NAME
EXTERNAL_LANGUAGE
PARAMETER_STYLE
IS_DETERMINISTIC
SQL_DATA_ACCESS
SQL_PATH
SQL_MODE

SELECT ROUTINE_NAME,ROUTINE_TYPE,ROUTINE_DEFINITION
FROM  INFORMATION_SCHEMA.ROUTINES 
WHERE ROUTINE_SCHEMA = 'test' ;

SELECT ROUTINE_NAME,EXTERNAL_NAME,EXTERNAL_LANGUAGE,PARAMETER_STYLE 
FROM  INFORMATION_SCHEMA.ROUTINES 
WHERE ROUTINE_SCHEMA = 'test' ;

SELECT ROUTINE_NAME,IS_DETERMINISTIC,SQL_DATA_ACCESS,SQL_PATH 
FROM  INFORMATION_SCHEMA.ROUTINES 
WHERE ROUTINE_SCHEMA = 'test' ;


SELECT ROUTINE_NAME,SECURITY_TYPE,CREATED,LAST_ALTERED,SQL_MODE
FROM  INFORMATION_SCHEMA.ROUTINES 
WHERE ROUTINE_SCHEMA = 'test' ;


SELECT ROUTINE_NAME,ROUTINE_COMMENT,DEFINER
FROM  INFORMATION_SCHEMA.ROUTINES 
WHERE ROUTINE_SCHEMA = 'test' ;

DROP PROCEDURE test.sp1;
DROP FUNCTION test.sp2;


--Utilisateurs global

DESC INFORMATION_SCHEMA.USER_PRIVILEGES ;

SELECT GRANTEE,PRIVILEGE_TYPE,IS_GRANTABLE
FROM  INFORMATION_SCHEMA.USER_PRIVILEGES 
WHERE GRANTEE LIKE '''Paul%' OR GRANTEE LIKE '''Jules%';

--privilges database



DESC INFORMATION_SCHEMA.SCHEMA_PRIVILEGES ;


SELECT  TABLE_SCHEMA,GRANTEE,PRIVILEGE_TYPE,IS_GRANTABLE
FROM  INFORMATION_SCHEMA.SCHEMA_PRIVILEGES 
WHERE GRANTEE LIKE '''Paul%';

--privilges table


DESC INFORMATION_SCHEMA.TABLE_PRIVILEGES ;

SELECT CONCAT(TABLE_SCHEMA,'.',TABLE_NAME) AS 'Base.Table',
 GRANTEE,PRIVILEGE_TYPE AS 'Privilege'
FROM  INFORMATION_SCHEMA.TABLE_PRIVILEGES 
WHERE GRANTEE LIKE '''Paul%';


--privilges columns


DESC INFORMATION_SCHEMA.COLUMN_PRIVILEGES ;

SELECT CONCAT(TABLE_NAME,'.',COLUMN_NAME) AS 'Table.colonne', 
 GRANTEE,PRIVILEGE_TYPE AS 'Privilege'
FROM  INFORMATION_SCHEMA.COLUMN_PRIVILEGES 
WHERE  TABLE_SCHEMA='bdpaul';


SELECT 
*
FROM  INFORMATION_SCHEMA.COLUMN_PRIVILEGES ;