-- exceptions CONTINUE

delimiter ;
DROP TABLE bdutil.Pilote;
CREATE TABLE bdutil.Pilote
	(brevet VARCHAR(6) PRIMARY KEY,
	 nom VARCHAR(20), nbHVol DECIMAL(7,2), comp VARCHAR(4));
INSERT INTO Pilote VALUES ('PL-1', 'Gilles Laborde', 2450, 'AF');
INSERT INTO Pilote VALUES ('PL-2', 'Frdric D''Almeyda', 900, 'AF');
INSERT INTO Pilote VALUES ('PL-3', 'Florence Prissel', 1000, 'SING');
INSERT INTO Pilote VALUES ('PL-4', 'Sonia Dietrich', 2450, 'CAST');
INSERT INTO Pilote VALUES ('PL-5', 'Christine Royo', 200, 'AF');
INSERT INTO Pilote VALUES ('PL-6', 'Aurlia Ente', 2450, 'SING');

SELECT * FROM bdutil.Pilote;


--avec 1 handler

delimiter $

DROP PROCEDURE bdutil.procException1$
CREATE PROCEDURE bdutil.procException1 (IN p_comp VARCHAR(4)) 
BEGIN
 DECLARE flagNOTFOUND BOOLEAN DEFAULT 0;
 DECLARE var1 VARCHAR(20);
 DECLARE CONTINUE HANDLER FOR NOT FOUND SET flagNOTFOUND :=1;
 SELECT nom INTO var1 FROM Pilote WHERE comp = p_comp;
 
 IF flagNOTFOUND THEN
  SELECT CONCAT('Il n''y a pas de pilote pour la compagnie ',p_comp) AS 'Resultat procException1';
 ELSE
  SELECT CONCAT('Le seul pilote de la compagnie ',p_comp,' est ',var1) AS 'Resultat procException1';
 END IF; 
END;
$


CALL procException1('AF')$
--ERROR 1172 (42000): Result consisted of more than one row

CALL procException1('RIEN')$


CALL procException1('CAST')$


--avec 2 handlers


delimiter $

DROP PROCEDURE bdutil.procException1$
CREATE PROCEDURE bdutil.procException1 (IN p_comp VARCHAR(4)) 
BEGIN
 DECLARE flagNOTFOUND BOOLEAN DEFAULT 0;
 DECLARE flagPlusDun  BOOLEAN DEFAULT 0;
 DECLARE var1 VARCHAR(20);

 DECLARE CONTINUE HANDLER FOR 1172      SET flagPlusDun  :=1;
 DECLARE CONTINUE HANDLER FOR NOT FOUND SET flagNOTFOUND :=1;

 SELECT nom INTO var1 FROM Pilote WHERE comp = p_comp;

 IF flagNOTFOUND THEN
  SELECT CONCAT('Il n''y a pas de pilote pour la compagnie ',p_comp) AS 'Resultat procException1';
 ELSEIF flagPlusDun  THEN
    SELECT CONCAT('Il y a plusieurs pilotes pour la compagnie ',p_comp) AS 'Resultat procException1';
   ELSE
    SELECT CONCAT('Le seul pilote de la compagnie ',p_comp,' est ',var1) AS 'Resultat procException1';
 END IF; 
END;
$


CALL procException1('AF')$

CALL procException1('RIEN')$


CALL procException1('CAST')$


delimiter ;
DROP TABLE bdutil.Pilote;
DROP PROCEDURE bdutil.procException1;