/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Parser;
import org.hsqldb.Result;
import org.hsqldb.Select;
import org.hsqldb.SubQuery;
import org.hsqldb.Table;
import org.hsqldb.TableFilter;
import org.hsqldb.Tokenizer;
import org.hsqldb.Trace;
import org.hsqldb.lib.Iterator;

class View
extends Table {
    Table workingTable;
    Select viewSelect;
    SubQuery viewSubQuery;
    private String statement;
    private HsqlNameManager.HsqlName[] colList;
    SubQuery[] viewSubqueries;

    View(Database database, HsqlNameManager.HsqlName hsqlName, String string, HsqlNameManager.HsqlName[] hsqlNameArray) throws HsqlException {
        super(database, hsqlName, 7, 0);
        this.isReadOnly = true;
        this.colList = hsqlNameArray;
        this.statement = View.trimStatement(string);
        this.compile();
    }

    static String trimStatement(String string) throws HsqlException {
        int n;
        String string2;
        Tokenizer tokenizer = new Tokenizer(string);
        do {
            n = tokenizer.getPosition();
        } while ((string2 = tokenizer.getString()).length() != 0 || tokenizer.wasValue());
        return string.substring(0, n).trim();
    }

    void compile() throws HsqlException {
        Tokenizer tokenizer = new Tokenizer(this.statement);
        tokenizer.getThis("SELECT");
        Parser parser = new Parser(this.database, tokenizer, this.database.sessionManager.getSysSession());
        this.viewSubQuery = parser.parseSubquery(null, this.colList, true, 3);
        parser.setAsView(this);
        this.viewSubqueries = parser.getSortedSubqueries();
        this.workingTable = this.viewSubQuery.table;
        this.viewSelect = this.viewSubQuery.select;
        this.viewSelect.prepareResult();
        Result.ResultMetaData resultMetaData = this.viewSelect.resultMetaData;
        int n = this.viewSelect.iResultLen;
        if (this.columnCount == 0) {
            super.addColumns(resultMetaData, n);
        }
    }

    String getStatement() {
        return this.statement;
    }

    void setDataReadOnly(boolean bl) throws HsqlException {
        throw Trace.error(55);
    }

    boolean hasView(View view) {
        if (view == this) {
            return false;
        }
        for (int i = 0; i < this.viewSubqueries.length; ++i) {
            if (this.viewSubqueries[i].view != view) continue;
            return true;
        }
        return false;
    }

    boolean hasTable(String string) {
        for (int i = 0; i < this.viewSubqueries.length; ++i) {
            Select select = this.viewSubqueries[i].select;
            while (select != null) {
                TableFilter[] tableFilterArray = select.tFilter;
                for (int j = 0; j < tableFilterArray.length; ++j) {
                    if (!string.equals(tableFilterArray[j].filterTable.tableName.name)) continue;
                    return true;
                }
                select = select.sUnion;
            }
        }
        return false;
    }

    boolean hasColumn(String string, String string2) {
        if (this.hasTable(string)) {
            Expression.Collector collector = new Expression.Collector();
            collector.addAll(this.viewSubqueries[this.viewSubqueries.length - 1].select, 2);
            Iterator iterator = collector.iterator();
            while (iterator.hasNext()) {
                Expression expression = (Expression)iterator.next();
                if (!expression.getColumnName().equals(string2) || !string.equals(expression.getTableName())) continue;
                return true;
            }
        }
        return false;
    }

    boolean hasSequence(NumberSequence numberSequence) {
        Expression.Collector collector = new Expression.Collector();
        collector.addAll(this.viewSubqueries[this.viewSubqueries.length - 1].select, 71);
        Iterator iterator = collector.iterator();
        while (iterator.hasNext()) {
            Expression expression = (Expression)iterator.next();
            if (expression.valueData != numberSequence) continue;
            return true;
        }
        return false;
    }
}

