/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0;

import com.mchange.v2.c3p0.PooledDataSource;
import com.mchange.v2.c3p0.impl.C3P0PooledConnectionPoolManager;
import com.mchange.v2.c3p0.impl.PoolBackedDataSourceBase;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public final class PoolBackedDataSource
extends PoolBackedDataSourceBase
implements PooledDataSource {
    static final String NO_CPDS_ERR_MSG = "Attempted to use an uninitialized PoolBackedDataSource. Please call setConnectionPoolDataSource( ... ) to initialize.";
    transient C3P0PooledConnectionPoolManager poolManager;
    transient boolean is_closed = false;

    public PoolBackedDataSource() {
        PropertyChangeListener l = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                PoolBackedDataSource.this.resetPoolManager();
            }
        };
        this.addPropertyChangeListener(l);
    }

    public Connection getConnection() throws SQLException {
        PooledConnection pc = this.getPoolManager().getPool().checkoutPooledConnection();
        return pc.getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        PooledConnection pc = this.getPoolManager().getPool(username, password).checkoutPooledConnection();
        return pc.getConnection();
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.assertCpds().getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.assertCpds().setLogWriter(out);
    }

    public int getLoginTimeout() throws SQLException {
        return this.assertCpds().getLoginTimeout();
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.assertCpds().setLoginTimeout(seconds);
    }

    public int getNumConnections() throws SQLException {
        return this.getPoolManager().getPool().getNumConnections();
    }

    public int getNumIdleConnections() throws SQLException {
        return this.getPoolManager().getPool().getNumIdleConnections();
    }

    public int getNumBusyConnections() throws SQLException {
        return this.getPoolManager().getPool().getNumBusyConnections();
    }

    public int getNumConnections(String username, String password) throws SQLException {
        return this.getPoolManager().getPool(username, password).getNumConnections();
    }

    public int getNumIdleConnections(String username, String password) throws SQLException {
        return this.getPoolManager().getPool(username, password).getNumIdleConnections();
    }

    public int getNumBusyConnections(String username, String password) throws SQLException {
        return this.getPoolManager().getPool(username, password).getNumBusyConnections();
    }

    public int getNumConnectionsAllAuths() throws SQLException {
        return this.getPoolManager().getNumConnectionsAllAuths();
    }

    public void close() {
        this.close(false);
    }

    public void close(boolean force_destroy) {
        C3P0PooledConnectionPoolManager forceDestroyMe = force_destroy ? this.poolManager : null;
        this.resetPoolManager();
        this.is_closed = true;
        if (force_destroy) {
            forceDestroyMe.forceDestroy();
        }
    }

    synchronized void resetPoolManager() {
        if (this.poolManager != null) {
            this.poolManager.unregisterActiveClient(this);
            this.poolManager = null;
        }
    }

    private synchronized ConnectionPoolDataSource assertCpds() throws SQLException {
        if (this.is_closed) {
            throw new SQLException(this + " has been closed() -- you can no longer use it.");
        }
        ConnectionPoolDataSource out = this.getConnectionPoolDataSource();
        if (out == null) {
            throw new SQLException(NO_CPDS_ERR_MSG);
        }
        return out;
    }

    private synchronized C3P0PooledConnectionPoolManager getPoolManager() throws SQLException {
        if (this.poolManager == null) {
            this.poolManager = C3P0PooledConnectionPoolManager.find(this.assertCpds(), this.getNumHelperThreads());
            this.poolManager.registerActiveClient(this);
            System.err.println("Initializing c3p0 pool... " + this.toString());
        }
        return this.poolManager;
    }
}

