/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheProvider;
import org.hibernate.util.NamingHelper;
import org.hibernate.util.StringHelper;

public abstract class AbstractJndiBoundCacheProvider
implements CacheProvider {
    private static final Log log;
    private Object cache;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.cache.AbstractJndiBoundCacheProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    protected void prepare(Properties properties) {
    }

    protected void release() {
    }

    public final void start(Properties properties) throws CacheException {
        String jndiNamespace = properties.getProperty("hibernate.cache.jndi");
        if (StringHelper.isEmpty(jndiNamespace)) {
            throw new CacheException("No JNDI namespace specified for cache");
        }
        this.cache = this.locateCache(jndiNamespace, NamingHelper.getJndiProperties(properties));
        this.prepare(properties);
    }

    public final void stop() {
        this.release();
        this.cache = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object locateCache(String jndiNamespace, Properties jndiProperties) {
        InitialContext ctx = null;
        try {
            try {
                ctx = new InitialContext(jndiProperties);
                Object object = ctx.lookup(jndiNamespace);
                Object var6_5 = null;
                if (ctx == null) return object;
                try {
                    ctx.close();
                    return object;
                }
                catch (NamingException ne2) {
                    log.info((Object)"Unable to release initial context", (Throwable)ne2);
                }
                return object;
            }
            catch (NamingException ne) {
                String msg = "Unable to retreive Cache from JNDI [" + jndiNamespace + "]";
                log.info((Object)msg, (Throwable)ne);
                throw new CacheException(msg);
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (ctx == null) throw throwable;
            try {}
            catch (NamingException ne2) {
                log.info((Object)"Unable to release initial context", (Throwable)ne2);
                throw throwable;
            }
            ctx.close();
            throw throwable;
        }
    }

    public Object getCache() {
        return this.cache;
    }
}

