/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.Timestamper;

public class EhCache
implements Cache {
    private static final Log log;
    private net.sf.ehcache.Cache cache;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.cache.EhCache");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public EhCache(net.sf.ehcache.Cache cache) {
        this.cache = cache;
    }

    public Object get(Object key) throws CacheException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("key: " + key));
            }
            if (key == null) {
                return null;
            }
            Element element = this.cache.get((Serializable)key);
            if (element == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Element for " + key + " is null"));
                }
                return null;
            }
            return element.getValue();
        }
        catch (net.sf.ehcache.CacheException e) {
            throw new CacheException((Exception)((Object)e));
        }
    }

    public void update(Object key, Object value) throws CacheException {
        this.put(key, value);
    }

    public void put(Object key, Object value) throws CacheException {
        try {
            Element element = new Element((Serializable)key, (Serializable)value);
            this.cache.put(element);
        }
        catch (IllegalArgumentException e) {
            throw new CacheException(e);
        }
        catch (IllegalStateException e) {
            throw new CacheException(e);
        }
    }

    public void remove(Object key) throws CacheException {
        try {
            this.cache.remove((Serializable)key);
        }
        catch (ClassCastException e) {
            throw new CacheException(e);
        }
        catch (IllegalStateException e) {
            throw new CacheException(e);
        }
    }

    public void clear() throws CacheException {
        try {
            this.cache.removeAll();
        }
        catch (IllegalStateException e) {
            throw new CacheException(e);
        }
        catch (IOException e) {
            throw new CacheException(e);
        }
    }

    public void destroy() throws CacheException {
        try {
            CacheManager.getInstance().removeCache(this.cache.getName());
        }
        catch (IllegalStateException e) {
            throw new CacheException(e);
        }
        catch (net.sf.ehcache.CacheException e) {
            throw new CacheException((Exception)((Object)e));
        }
    }

    public void lock(Object key) throws CacheException {
    }

    public void unlock(Object key) throws CacheException {
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public int getTimeout() {
        return 245760000;
    }

    public String getRegionName() {
        return this.cache.getName();
    }

    public long getSizeInMemory() {
        try {
            return this.cache.calculateInMemorySize();
        }
        catch (Throwable throwable) {
            return -1L;
        }
    }

    public long getElementCountInMemory() {
        try {
            return this.cache.getSize();
        }
        catch (net.sf.ehcache.CacheException ce) {
            throw new CacheException((Exception)((Object)ce));
        }
    }

    public long getElementCountOnDisk() {
        return this.cache.getDiskStoreSize();
    }

    public Map toMap() {
        try {
            HashMap result = new HashMap();
            Iterator iter = this.cache.getKeys().iterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                result.put(key, this.cache.get((Serializable)key));
            }
            return result;
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public String toString() {
        return "EHCache(" + this.getRegionName() + ')';
    }
}

