/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.util.Properties;
import net.sf.ehcache.CacheManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheProvider;
import org.hibernate.cache.EhCache;
import org.hibernate.cache.Timestamper;

public class EhCacheProvider
implements CacheProvider {
    private static final Log log;
    private CacheManager manager;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.cache.EhCacheProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public Cache buildCache(String name, Properties properties) throws CacheException {
        try {
            net.sf.ehcache.Cache cache = this.manager.getCache(name);
            if (cache == null) {
                log.warn((Object)("Could not find configuration [" + name + "]; using defaults."));
                this.manager.addCache(name);
                cache = this.manager.getCache(name);
                log.debug((Object)("started EHCache region: " + name));
            }
            return new EhCache(cache);
        }
        catch (net.sf.ehcache.CacheException e) {
            throw new CacheException((Exception)((Object)e));
        }
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public void start(Properties properties) throws CacheException {
        try {
            this.manager = CacheManager.create();
        }
        catch (net.sf.ehcache.CacheException e) {
            throw new CacheException((Exception)((Object)e));
        }
    }

    public void stop() {
        if (this.manager != null) {
            this.manager.shutdown();
            this.manager = null;
        }
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return false;
    }
}

