/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheException;

public class ReadWriteCache
implements CacheConcurrencyStrategy {
    private static final Log log;
    private Cache cache;
    private int nextLockId;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.cache.ReadWriteCache");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public Cache getCache() {
        return this.cache;
    }

    public String getRegionName() {
        return this.cache.getRegionName();
    }

    private int nextLockId() {
        if (this.nextLockId == Integer.MAX_VALUE) {
            this.nextLockId = Integer.MIN_VALUE;
        }
        return this.nextLockId++;
    }

    public synchronized Object get(Object key, long txTimestamp) throws CacheException {
        Lockable lockable;
        block8: {
            Object object;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Cache lookup: " + key));
            }
            try {
                boolean gettable;
                this.cache.lock(key);
                lockable = (Lockable)this.cache.get(key);
                boolean bl = gettable = lockable != null && lockable.isGettable(txTimestamp);
                if (!gettable) break block8;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Cache hit: " + key));
                }
                object = ((Item)lockable).getValue();
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                this.cache.unlock(key);
                throw throwable;
            }
            this.cache.unlock(key);
            return object;
        }
        if (log.isTraceEnabled()) {
            if (lockable == null) {
                log.trace((Object)("Cache miss: " + key));
            } else {
                log.trace((Object)("Cached item was locked: " + key));
            }
        }
        Object var8_6 = null;
        Object var6_8 = null;
        this.cache.unlock(key);
        return var8_6;
    }

    public synchronized CacheConcurrencyStrategy.SoftLock lock(Object key, Object version) throws CacheException {
        Lock lock;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Invalidating: " + key));
        }
        try {
            this.cache.lock(key);
            Lockable lockable = (Lockable)this.cache.get(key);
            long timeout = this.cache.nextTimestamp() + (long)this.cache.getTimeout();
            Lock lock2 = lockable == null ? new Lock(timeout, this.nextLockId(), version) : lockable.lock(timeout, this.nextLockId());
            this.cache.update(key, lock2);
            lock = lock2;
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.cache.unlock(key);
            throw throwable;
        }
        this.cache.unlock(key);
        return lock;
    }

    public synchronized boolean put(Object key, Object value, long txTimestamp, Object version, Comparator versionComparator, boolean minimalPut) throws CacheException {
        Lockable lockable;
        block8: {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Caching: " + key));
            }
            try {
                boolean puttable;
                this.cache.lock(key);
                lockable = (Lockable)this.cache.get(key);
                boolean bl = puttable = lockable == null || lockable.isPuttable(txTimestamp, version, versionComparator);
                if (!puttable) break block8;
                this.cache.put(key, new Item(value, version, this.cache.nextTimestamp()));
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Cached: " + key));
                }
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                this.cache.unlock(key);
                throw throwable;
            }
            this.cache.unlock(key);
            return true;
        }
        if (log.isTraceEnabled()) {
            if (lockable.isLock()) {
                log.trace((Object)("Item was locked: " + key));
            } else {
                log.trace((Object)("Item was already cached: " + key));
            }
        }
        Object var10_10 = null;
        this.cache.unlock(key);
        return false;
    }

    private void decrementLock(Object key, Lock lock) throws CacheException {
        lock.unlock(this.cache.nextTimestamp());
        this.cache.update(key, lock);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void release(Object key, CacheConcurrencyStrategy.SoftLock clientLock) throws CacheException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Releasing: " + key));
        }
        try {
            this.cache.lock(key);
            Lockable lockable = (Lockable)this.cache.get(key);
            if (this.isUnlockable(clientLock, lockable)) {
                this.decrementLock(key, (Lock)lockable);
            } else {
                this.handleLockExpiry(key);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.cache.unlock(key);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.cache.unlock(key);
    }

    void handleLockExpiry(Object key) throws CacheException {
        log.warn((Object)("An item was expired by the cache while it was locked (increase your cache timeout): " + key));
        long ts = this.cache.nextTimestamp() + (long)this.cache.getTimeout();
        Lock lock = new Lock(ts, this.nextLockId(), null);
        lock.unlock(ts);
        this.cache.update(key, lock);
    }

    public void clear() throws CacheException {
        this.cache.clear();
    }

    public void remove(Object key) throws CacheException {
        this.cache.remove(key);
    }

    public void destroy() {
        try {
            this.cache.destroy();
        }
        catch (Exception e) {
            log.warn((Object)"could not destroy cache", (Throwable)e);
        }
    }

    public synchronized boolean afterUpdate(Object key, Object value, Object version, CacheConcurrencyStrategy.SoftLock clientLock) throws CacheException {
        block6: {
            block7: {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Updating: " + key));
                }
                try {
                    this.cache.lock(key);
                    Lockable lockable = (Lockable)this.cache.get(key);
                    if (!this.isUnlockable(clientLock, lockable)) break block6;
                    Lock lock = (Lock)lockable;
                    if (!lock.wasLockedConcurrently()) break block7;
                    this.decrementLock(key, lock);
                    Object var7_7 = null;
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    this.cache.unlock(key);
                    throw throwable;
                }
                this.cache.unlock(key);
                return false;
            }
            this.cache.update(key, new Item(value, version, this.cache.nextTimestamp()));
            if (log.isTraceEnabled()) {
                log.trace((Object)("Updated: " + key));
            }
            Object var7_8 = null;
            this.cache.unlock(key);
            return true;
        }
        this.handleLockExpiry(key);
        Object var7_9 = null;
        this.cache.unlock(key);
        return false;
    }

    public synchronized boolean afterInsert(Object key, Object value, Object version) throws CacheException {
        block5: {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Inserting: " + key));
            }
            try {
                this.cache.lock(key);
                Lockable lockable = (Lockable)this.cache.get(key);
                if (lockable != null) break block5;
                this.cache.update(key, new Item(value, version, this.cache.nextTimestamp()));
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Inserted: " + key));
                }
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.cache.unlock(key);
                throw throwable;
            }
            this.cache.unlock(key);
            return true;
        }
        Object var5_6 = null;
        this.cache.unlock(key);
        return false;
    }

    public void evict(Object key) throws CacheException {
    }

    public boolean insert(Object key, Object value) throws CacheException {
        return false;
    }

    public boolean update(Object key, Object value) throws CacheException {
        return false;
    }

    private boolean isUnlockable(CacheConcurrencyStrategy.SoftLock clientLock, Lockable myLock) throws CacheException {
        return myLock != null && myLock.isLock() && clientLock != null && ((Lock)clientLock).getId() == ((Lock)myLock).getId();
    }

    public String toString() {
        return this.cache + "(read-write)";
    }

    public static interface Lockable {
        public Lock lock(long var1, int var3);

        public boolean isLock();

        public boolean isGettable(long var1);

        public boolean isPuttable(long var1, Object var3, Comparator var4);
    }

    public static final class Item
    implements Serializable,
    Lockable {
        private final long freshTimestamp;
        private final Object value;
        private final Object version;

        public Item(Object value, Object version, long currentTimestamp) {
            this.value = value;
            this.version = version;
            this.freshTimestamp = currentTimestamp;
        }

        public long getFreshTimestamp() {
            return this.freshTimestamp;
        }

        public Object getValue() {
            return this.value;
        }

        public Lock lock(long timeout, int id) {
            return new Lock(timeout, id, this.version);
        }

        public boolean isLock() {
            return false;
        }

        public boolean isGettable(long txTimestamp) {
            return this.freshTimestamp < txTimestamp;
        }

        public boolean isPuttable(long txTimestamp, Object newVersion, Comparator comparator) {
            return this.version != null && comparator.compare(this.version, newVersion) < 0;
        }

        public String toString() {
            return "Item{version=" + this.version + ",freshTimestamp=" + this.freshTimestamp;
        }
    }

    public static final class Lock
    implements Serializable,
    Lockable,
    CacheConcurrencyStrategy.SoftLock {
        private long unlockTimestamp = -1L;
        private int multiplicity = 1;
        private boolean concurrentLock = false;
        private long timeout;
        private final int id;
        private final Object version;

        public Lock(long timeout, int id, Object version) {
            this.timeout = timeout;
            this.id = id;
            this.version = version;
        }

        public long getUnlockTimestamp() {
            return this.unlockTimestamp;
        }

        public Lock lock(long timeout, int id) {
            this.concurrentLock = true;
            ++this.multiplicity;
            this.timeout = timeout;
            return this;
        }

        public void unlock(long currentTimestamp) {
            if (--this.multiplicity == 0) {
                this.unlockTimestamp = currentTimestamp;
            }
        }

        public boolean isPuttable(long txTimestamp, Object newVersion, Comparator comparator) {
            if (this.timeout < txTimestamp) {
                return true;
            }
            if (this.multiplicity > 0) {
                return false;
            }
            return this.version == null ? this.unlockTimestamp < txTimestamp : comparator.compare(this.version, newVersion) < 0;
        }

        public boolean wasLockedConcurrently() {
            return this.concurrentLock;
        }

        public boolean isLock() {
            return true;
        }

        public boolean isGettable(long txTimestamp) {
            return false;
        }

        public int getId() {
            return this.id;
        }

        public String toString() {
            return "Lock{id=" + this.id + ",version=" + this.version + ",multiplicity=" + this.multiplicity + ",unlockTimestamp=" + this.unlockTimestamp;
        }
    }
}

