/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.jboss.cache.Fqn;

public class TreeCache
implements Cache {
    private static final String ITEM = "item";
    private org.jboss.cache.TreeCache cache;
    private final String regionName;
    private final String userRegionName;
    private final TransactionManager transactionManager;

    public TreeCache(org.jboss.cache.TreeCache cache, String regionName, TransactionManager transactionManager) throws CacheException {
        this.cache = cache;
        this.userRegionName = regionName;
        this.regionName = String.valueOf('/') + regionName.replace('.', '/');
        this.transactionManager = transactionManager;
    }

    public Object get(Object key) throws CacheException {
        try {
            return this.cache.get(new Fqn(new Object[]{this.regionName, key}), (Object)ITEM);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public void update(Object key, Object value) throws CacheException {
        try {
            this.cache.put(new Fqn(new Object[]{this.regionName, key}), (Object)ITEM, value);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public void put(Object key, Object value) throws CacheException {
        try {
            Transaction tx = this.transactionManager == null ? null : this.transactionManager.suspend();
            this.cache.putFailFast(new Fqn(new Object[]{this.regionName, key}), (Object)ITEM, value, 0L);
            if (tx != null) {
                this.transactionManager.resume(tx);
            }
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public void remove(Object key) throws CacheException {
        try {
            this.cache.remove(new Fqn(new Object[]{this.regionName, key}));
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public void clear() throws CacheException {
        try {
            this.cache.remove(new Fqn((Object)this.regionName));
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public void destroy() throws CacheException {
        this.clear();
    }

    public void lock(Object key) throws CacheException {
        throw new UnsupportedOperationException("TreeCache is a fully transactional cache" + this.regionName);
    }

    public void unlock(Object key) throws CacheException {
        throw new UnsupportedOperationException("TreeCache is a fully transactional cache: " + this.regionName);
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public int getTimeout() {
        return 600;
    }

    public String getRegionName() {
        return this.userRegionName;
    }

    public long getSizeInMemory() {
        return -1L;
    }

    public long getElementCountInMemory() {
        try {
            return this.cache.getChildrenNames(new Fqn((Object)this.regionName)).size();
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public long getElementCountOnDisk() {
        return 0L;
    }

    public Map toMap() {
        try {
            HashMap result = new HashMap();
            Iterator iter = this.cache.getChildrenNames(new Fqn((Object)this.regionName)).iterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                result.put(key, this.cache.get(new Fqn(new Object[]{this.regionName, key}), (Object)ITEM));
            }
            return result;
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public String toString() {
        return "TreeCache(" + this.userRegionName + ')';
    }
}

