/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.util.PropertiesHelper;

public final class Environment {
    public static final String VERSION = "3.0rc1";
    public static final String CONNECTION_PROVIDER = "hibernate.connection.provider_class";
    public static final String DRIVER = "hibernate.connection.driver_class";
    public static final String ISOLATION = "hibernate.connection.isolation";
    public static final String URL = "hibernate.connection.url";
    public static final String USER = "hibernate.connection.username";
    public static final String PASS = "hibernate.connection.password";
    public static final String AUTOCOMMIT = "hibernate.connection.autocommit";
    public static final String POOL_SIZE = "hibernate.connection.pool_size";
    public static final String DATASOURCE = "hibernate.connection.datasource";
    public static final String CONNECTION_PREFIX = "hibernate.connection";
    public static final String JNDI_CLASS = "hibernate.jndi.class";
    public static final String JNDI_URL = "hibernate.jndi.url";
    public static final String JNDI_PREFIX = "hibernate.jndi";
    public static final String SESSION_FACTORY_NAME = "hibernate.session_factory_name";
    public static final String DIALECT = "hibernate.dialect";
    public static final String DEFAULT_SCHEMA = "hibernate.default_schema";
    public static final String DEFAULT_CATALOG = "hibernate.default_catalog";
    public static final String SHOW_SQL = "hibernate.show_sql";
    public static final String USE_SQL_COMMENTS = "hibernate.use_sql_comments";
    public static final String MAX_FETCH_DEPTH = "hibernate.max_fetch_depth";
    public static final String DEFAULT_BATCH_FETCH_SIZE = "hibernate.default_batch_fetch_size";
    public static final String USE_STREAMS_FOR_BINARY = "hibernate.jdbc.use_streams_for_binary";
    public static final String USE_SCROLLABLE_RESULTSET = "hibernate.jdbc.use_scrollable_resultset";
    public static final String USE_GET_GENERATED_KEYS = "hibernate.jdbc.use_get_generated_keys";
    public static final String STATEMENT_FETCH_SIZE = "hibernate.jdbc.fetch_size";
    public static final String STATEMENT_BATCH_SIZE = "hibernate.jdbc.batch_size";
    public static final String BATCH_STRATEGY = "hibernate.jdbc.factory_class";
    public static final String BATCH_VERSIONED_DATA = "hibernate.jdbc.batch_versioned_data";
    public static final String OUTPUT_STYLESHEET = "hibernate.xml.output_stylesheet";
    public static final String C3P0_MAX_SIZE = "hibernate.c3p0.max_size";
    public static final String C3P0_MIN_SIZE = "hibernate.c3p0.min_size";
    public static final String C3P0_TIMEOUT = "hibernate.c3p0.timeout";
    public static final String C3P0_MAX_STATEMENTS = "hibernate.c3p0.max_statements";
    public static final String C3P0_ACQUIRE_INCREMENT = "hibernate.c3p0.acquire_increment";
    public static final String C3P0_IDLE_TEST_PERIOD = "hibernate.c3p0.idle_test_period";
    public static final String PROXOOL_PREFIX = "hibernate.proxool";
    public static final String PROXOOL_XML = "hibernate.proxool.xml";
    public static final String PROXOOL_PROPERTIES = "hibernate.proxool.properties";
    public static final String PROXOOL_EXISTING_POOL = "hibernate.proxool.existing_pool";
    public static final String PROXOOL_POOL_ALIAS = "hibernate.proxool.pool_alias";
    public static final String AUTO_CLOSE_SESSION = "hibernate.transaction.auto_close_session";
    public static final String FLUSH_BEFORE_COMPLETION = "hibernate.transaction.flush_before_completion";
    public static final String TRANSACTION_STRATEGY = "hibernate.transaction.factory_class";
    public static final String TRANSACTION_MANAGER_STRATEGY = "hibernate.transaction.manager_lookup_class";
    public static final String USER_TRANSACTION = "jta.UserTransaction";
    public static final String CACHE_PROVIDER = "hibernate.cache.provider_class";
    public static final String CACHE_NAMESPACE = "hibernate.cache.jndi";
    public static final String USE_QUERY_CACHE = "hibernate.cache.use_query_cache";
    public static final String QUERY_CACHE_FACTORY = "hibernate.cache.query_cache_factory";
    public static final String USE_SECOND_LEVEL_CACHE = "hibernate.cache.use_second_level_cache";
    public static final String USE_MINIMAL_PUTS = "hibernate.cache.use_minimal_puts";
    public static final String CACHE_REGION_PREFIX = "hibernate.cache.region_prefix";
    public static final String USE_STRUCTURED_CACHE = "hibernate.cache.use_structured_entries";
    public static final String GENERATE_STATISTICS = "hibernate.generate_statistics";
    public static final String USE_IDENTIFIER_ROLLBACK = "hibernate.use_identifier_rollback";
    public static final String USE_REFLECTION_OPTIMIZER = "hibernate.cglib.use_reflection_optimizer";
    public static final String QUERY_TRANSLATOR = "hibernate.query.factory_class";
    public static final String QUERY_SUBSTITUTIONS = "hibernate.query.substitutions";
    public static final String HBM2DDL_AUTO = "hibernate.hbm2ddl.auto";
    public static final String SQL_EXCEPTION_CONVERTER = "hibernate.jdbc.sql_exception_converter";
    public static final String WRAP_RESULT_SETS = "hibernate.jdbc.wrap_result_sets";
    public static final String ORDER_UPDATES = "hibernate.order_updates";
    public static final String DEFAULT_ENTITY_MODE = "hibernate.default_entity_mode";
    private static final boolean ENABLE_BINARY_STREAMS;
    private static final boolean ENABLE_REFLECTION_OPTIMIZER;
    private static final boolean JVM_SUPPORTS_LINKED_HASH_COLLECTIONS;
    private static final boolean JVM_HAS_TIMESTAMP_BUG;
    private static final boolean JVM_HAS_JDK14_TIMESTAMP;
    private static final boolean JVM_SUPPORTS_GET_GENERATED_KEYS;
    private static final Properties GLOBAL_PROPERTIES;
    private static final HashMap ISOLATION_LEVELS;
    private static final Map OBSOLETE_PROPERTIES;
    private static final Log log;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        block31: {
            Environment.ISOLATION_LEVELS = new HashMap<K, V>();
            Environment.OBSOLETE_PROPERTIES = new HashMap<K, V>();
            v0 = Environment.class$0;
            if (v0 == null) {
                try {
                    v1 = Class.forName("org.hibernate.cfg.Environment");
                }
                catch (ClassNotFoundException v2) {
                    throw new NoClassDefFoundError(v2.getMessage());
                }
                v0 = Environment.class$0 = v1;
            }
            Environment.log = LogFactory.getLog((Class)v0);
            Environment.log.info((Object)"Hibernate 3.0rc1");
            Environment.ISOLATION_LEVELS.put(new Integer(0), "NONE");
            Environment.ISOLATION_LEVELS.put(new Integer(1), "READ_UNCOMMITTED");
            Environment.ISOLATION_LEVELS.put(new Integer(2), "READ_COMMITTED");
            Environment.ISOLATION_LEVELS.put(new Integer(4), "REPEATABLE_READ");
            Environment.ISOLATION_LEVELS.put(new Integer(8), "SERIALIZABLE");
            Environment.GLOBAL_PROPERTIES = new Properties();
            Environment.GLOBAL_PROPERTIES.setProperty("hibernate.cglib.use_reflection_optimizer", Boolean.TRUE.toString());
            v3 = Environment.class$0;
            if (v3 == null) {
                try {
                    v4 = Class.forName("org.hibernate.cfg.Environment");
                }
                catch (ClassNotFoundException v5) {
                    throw new NoClassDefFoundError(v5.getMessage());
                }
                v3 = Environment.class$0 = v4;
            }
            if ((stream = v3.getResourceAsStream("/hibernate.properties")) == null) {
                Environment.log.info((Object)"hibernate.properties not found");
            } else {
                try {
                    try {
                        Environment.GLOBAL_PROPERTIES.load(stream);
                        Environment.log.info((Object)("loaded properties from resource hibernate.properties: " + PropertiesHelper.maskOut(Environment.GLOBAL_PROPERTIES, "hibernate.connection.password")));
                    }
                    catch (Exception v6) {
                        Environment.log.error((Object)"problem loading properties from hibernate.properties");
                    }
                }
                catch (Throwable var2_1) {
                    var1_3 = null;
                    try {
                        stream.close();
                        throw var2_1;
                    }
                    catch (IOException ioe) {
                        Environment.log.error((Object)"could not close stream on hibernate.properties", (Throwable)ioe);
                    }
                    throw var2_1;
                }
                {
                    var1_4 = null;
                }
                ** try [egrp 4[TRYBLOCK] [5 : 306->313)] { 
lbl56:
                // 1 sources

                stream.close();
            }
            break block31;
lbl58:
            // 1 sources

            catch (IOException ioe) {
                Environment.log.error((Object)"could not close stream on hibernate.properties", (Throwable)ioe);
                ** GOTO lbl-1000
            }
        }
        try lbl-1000:
        // 2 sources

        {
            Environment.GLOBAL_PROPERTIES.putAll((Map<?, ?>)System.getProperties());
        }
        catch (SecurityException v7) {
            Environment.log.warn((Object)"could not copy system properties, system properties will be ignored");
        }
        Environment.verifyProperties(Environment.GLOBAL_PROPERTIES);
        Environment.ENABLE_BINARY_STREAMS = PropertiesHelper.getBoolean("hibernate.jdbc.use_streams_for_binary", Environment.GLOBAL_PROPERTIES);
        Environment.ENABLE_REFLECTION_OPTIMIZER = PropertiesHelper.getBoolean("hibernate.cglib.use_reflection_optimizer", Environment.GLOBAL_PROPERTIES);
        if (Environment.ENABLE_BINARY_STREAMS) {
            Environment.log.info((Object)"using java.io streams to persist binary types");
        }
        if (Environment.ENABLE_REFLECTION_OPTIMIZER) {
            Environment.log.info((Object)"using CGLIB reflection optimizer");
        }
        try {
            v8 = Environment.class$1;
            if (v8 == null) {
                try {
                    v9 = Class.forName("java.sql.Statement");
                }
                catch (ClassNotFoundException v10) {
                    throw new NoClassDefFoundError(v10.getMessage());
                }
                v8 = Environment.class$1 = v9;
            }
            v8.getMethod("getGeneratedKeys", null);
            getGeneratedKeysSupport = true;
        }
        catch (NoSuchMethodException v11) {
            getGeneratedKeysSupport = false;
        }
        Environment.JVM_SUPPORTS_GET_GENERATED_KEYS = getGeneratedKeysSupport;
        if (!Environment.JVM_SUPPORTS_GET_GENERATED_KEYS) {
            Environment.log.info((Object)"JVM does not support Statement.getGeneratedKeys()");
        }
        try {
            Class.forName("java.util.LinkedHashSet");
            linkedHashSupport = true;
        }
        catch (ClassNotFoundException v12) {
            linkedHashSupport = false;
        }
        Environment.JVM_SUPPORTS_LINKED_HASH_COLLECTIONS = linkedHashSupport;
        if (!Environment.JVM_SUPPORTS_LINKED_HASH_COLLECTIONS) {
            Environment.log.info((Object)"JVM does not support LinkedHasMap, LinkedHashSet - ordered maps and sets disabled");
        }
        v13 = Environment.JVM_HAS_TIMESTAMP_BUG = new Timestamp(123456789L).getTime() != 123456789L;
        if (Environment.JVM_HAS_TIMESTAMP_BUG) {
            Environment.log.info((Object)"using workaround for JVM bug in java.sql.Timestamp");
        }
        t = new Timestamp(0L);
        t.setNanos(5000000);
        v14 = Environment.JVM_HAS_JDK14_TIMESTAMP = t.getTime() == 5L;
        if (Environment.JVM_HAS_JDK14_TIMESTAMP) {
            Environment.log.info((Object)"using JDK 1.4 java.sql.Timestamp handling");
            return;
        }
        Environment.log.info((Object)"using pre JDK 1.4 java.sql.Timestamp handling");
    }

    public static void verifyProperties(Properties props) {
        Iterator<Object> iter = props.keySet().iterator();
        while (iter.hasNext()) {
            Object oldProp = iter.next();
            Object newProp = OBSOLETE_PROPERTIES.get(oldProp);
            if (newProp == null) continue;
            log.warn((Object)("Usage of obsolete property: " + oldProp + " no longer supported, use: " + newProp));
        }
    }

    public static boolean jvmHasTimestampBug() {
        return JVM_HAS_TIMESTAMP_BUG;
    }

    public static boolean jvmHasJDK14Timestamp() {
        return JVM_HAS_JDK14_TIMESTAMP;
    }

    public static boolean jvmSupportsLinkedHashCollections() {
        return JVM_SUPPORTS_LINKED_HASH_COLLECTIONS;
    }

    public static boolean jvmSupportsGetGeneratedKeys() {
        return JVM_SUPPORTS_GET_GENERATED_KEYS;
    }

    public static boolean useStreamsForBinary() {
        return ENABLE_BINARY_STREAMS;
    }

    public static boolean useReflectionOptimizer() {
        return ENABLE_REFLECTION_OPTIMIZER;
    }

    private Environment() {
        throw new UnsupportedOperationException();
    }

    public static Properties getProperties() {
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)GLOBAL_PROPERTIES);
        return copy;
    }

    public static String isolationLevelToString(int isolation) {
        return (String)ISOLATION_LEVELS.get(new Integer(isolation));
    }
}

