/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.connection;

import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Environment;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.util.ConfigHelper;
import org.hibernate.util.PropertiesHelper;
import org.hibernate.util.StringHelper;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolFacade;
import org.logicalcobwebs.proxool.configuration.JAXPConfigurator;
import org.logicalcobwebs.proxool.configuration.PropertyConfigurator;

public class ProxoolConnectionProvider
implements ConnectionProvider {
    private static final String PROXOOL_JDBC_STEM = "proxool.";
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$connection$ProxoolConnectionProvider == null ? (class$org$hibernate$connection$ProxoolConnectionProvider = ProxoolConnectionProvider.class$("org.hibernate.connection.ProxoolConnectionProvider")) : class$org$hibernate$connection$ProxoolConnectionProvider));
    private String proxoolAlias;
    private boolean existingPool;
    private Integer isolation;
    private boolean autocommit;
    static /* synthetic */ Class class$org$hibernate$connection$ProxoolConnectionProvider;

    public Connection getConnection() throws SQLException {
        Connection c = DriverManager.getConnection(this.proxoolAlias);
        if (this.isolation != null) {
            c.setTransactionIsolation(this.isolation);
        }
        if (c.getAutoCommit() != this.autocommit) {
            c.setAutoCommit(this.autocommit);
        }
        return c;
    }

    public void closeConnection(Connection conn) throws SQLException {
        conn.close();
    }

    public void configure(Properties props) throws HibernateException {
        String jaxpFile = props.getProperty("hibernate.proxool.xml");
        String propFile = props.getProperty("hibernate.proxool.properties");
        String externalConfig = props.getProperty("hibernate.proxool.existing_pool");
        this.proxoolAlias = props.getProperty("hibernate.proxool.pool_alias");
        if ("true".equals(externalConfig)) {
            if (!StringHelper.isNotEmpty(this.proxoolAlias)) {
                String msg = "Cannot configure Proxool Provider to use an existing in memory pool without the hibernate.proxool.pool_alias property set.";
                log.fatal((Object)msg);
                throw new HibernateException(msg);
            }
            this.proxoolAlias = PROXOOL_JDBC_STEM + this.proxoolAlias;
            this.existingPool = true;
            log.info((Object)("Configuring Proxool Provider using existing pool in memory: " + this.proxoolAlias));
        } else if (StringHelper.isNotEmpty(jaxpFile)) {
            log.info((Object)("Configuring Proxool Provider using JAXPConfigurator: " + jaxpFile));
            if (!StringHelper.isNotEmpty(this.proxoolAlias)) {
                String msg = "Cannot configure Proxool Provider to use JAXP without the hibernate.proxool.pool_alias property set.";
                log.fatal((Object)msg);
                throw new HibernateException(msg);
            }
            try {
                JAXPConfigurator.configure((Reader)ConfigHelper.getConfigStreamReader(jaxpFile), (boolean)false);
            }
            catch (ProxoolException e) {
                String msg = "Proxool Provider unable to load JAXP configurator file: " + jaxpFile;
                log.fatal((Object)msg, (Throwable)e);
                throw new HibernateException(msg, e);
            }
            this.proxoolAlias = PROXOOL_JDBC_STEM + this.proxoolAlias;
            log.info((Object)("Configuring Proxool Provider to use pool alias: " + this.proxoolAlias));
        } else if (StringHelper.isNotEmpty(propFile)) {
            log.info((Object)("Configuring Proxool Provider using Properties File: " + propFile));
            if (!StringHelper.isNotEmpty(this.proxoolAlias)) {
                String msg = "Cannot configure Proxool Provider to use Properties File without the hibernate.proxool.pool_alias property set.";
                log.fatal((Object)msg);
                throw new HibernateException(msg);
            }
            try {
                PropertyConfigurator.configure((Properties)ConfigHelper.getConfigProperties(propFile));
            }
            catch (ProxoolException e) {
                String msg = "Proxool Provider unable to load load Property configurator file: " + propFile;
                log.fatal((Object)msg, (Throwable)e);
                throw new HibernateException(msg, e);
            }
            this.proxoolAlias = PROXOOL_JDBC_STEM + this.proxoolAlias;
            log.info((Object)("Configuring Proxool Provider to use pool alias: " + this.proxoolAlias));
        }
        this.isolation = PropertiesHelper.getInteger("hibernate.connection.isolation", props);
        if (this.isolation != null) {
            log.info((Object)("JDBC isolation level: " + Environment.isolationLevelToString(this.isolation)));
        }
        this.autocommit = PropertiesHelper.getBoolean("hibernate.connection.autocommit", props);
        log.info((Object)("autocommit mode: " + this.autocommit));
    }

    public void close() throws HibernateException {
        if (this.existingPool) {
            return;
        }
        try {
            ProxoolFacade.shutdown((int)0);
        }
        catch (Exception e) {
            log.warn((Object)"Exception occured when closing the Proxool pool", (Throwable)e);
            throw new HibernateException("Exception occured when closing the Proxool pool", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

