/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.criterion;

import java.util.ArrayList;
import org.hibernate.Criteria;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.engine.TypedValue;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;

public class InExpression
implements Criterion {
    private final String propertyName;
    private final Object[] values;

    protected InExpression(String propertyName, Object[] values) {
        this.propertyName = propertyName;
        this.values = values;
    }

    public String toSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        String params;
        if (this.values.length > 0) {
            params = StringHelper.repeat("?, ", this.values.length - 1);
            params = String.valueOf(params) + "?";
        } else {
            params = "";
        }
        String condition = " in (" + params + ')';
        return StringHelper.join(" and ", StringHelper.suffix(criteriaQuery.getColumnsUsingProjection(criteria, this.propertyName), condition));
    }

    public TypedValue[] getTypedValues(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        ArrayList<TypedValue> list = new ArrayList<TypedValue>();
        Type type = criteriaQuery.getTypeUsingProjection(criteria, this.propertyName);
        if (type.isComponentType()) {
            AbstractComponentType actype = (AbstractComponentType)type;
            Type[] types = actype.getSubtypes();
            int i = 0;
            while (i < types.length) {
                int j = 0;
                while (j < this.values.length) {
                    Object subval = this.values[j] == null ? null : actype.getPropertyValues(this.values[j], EntityMode.POJO)[i];
                    list.add(new TypedValue(types[i], subval, EntityMode.POJO));
                    ++j;
                }
                ++i;
            }
        } else {
            int j = 0;
            while (j < this.values.length) {
                list.add(new TypedValue(type, this.values[j], EntityMode.POJO));
                ++j;
            }
        }
        return list.toArray(new TypedValue[list.size()]);
    }

    public String toString() {
        return String.valueOf(this.propertyName) + " in (" + StringHelper.toString(this.values) + ')';
    }
}

