/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.criterion;

import org.hibernate.Criteria;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.TypedValue;
import org.hibernate.impl.CriteriaImpl;
import org.hibernate.loader.criteria.CriteriaQueryTranslator;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.sql.Select;
import org.hibernate.type.Type;

public abstract class SubqueryExpression
implements Criterion {
    private CriteriaImpl criteriaImpl;
    private String quantifier;
    private String op;
    private QueryParameters params;
    private Type[] types;

    protected Type[] getTypes() {
        return this.types;
    }

    protected SubqueryExpression(String op, String quantifier, DetachedCriteria dc) {
        this.criteriaImpl = dc.getCriteriaImpl();
        this.quantifier = quantifier;
        this.op = op;
    }

    protected abstract String toLeftSqlString(Criteria var1, CriteriaQuery var2);

    public String toSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        SessionFactoryImplementor factory = ((CriteriaImpl)criteria).getSession().getFactory();
        OuterJoinLoadable persister = (OuterJoinLoadable)factory.getEntityPersister(this.criteriaImpl.getEntityOrClassName());
        CriteriaQueryTranslator innerQuery = new CriteriaQueryTranslator(factory, this.criteriaImpl, this.criteriaImpl.getEntityOrClassName(), criteriaQuery.generateSQLAlias(), criteriaQuery);
        this.params = innerQuery.getQueryParameters();
        this.types = innerQuery.getProjectedTypes();
        String sql = new Select(factory.getDialect()).setWhereClause(innerQuery.getWhereCondition()).setGroupByClause(innerQuery.getGroupBy()).setSelectClause(innerQuery.getSelect()).setFromClause(String.valueOf(persister.fromTableFragment(innerQuery.getRootSQLALias())) + persister.fromJoinFragment(innerQuery.getRootSQLALias(), true, false)).toStatementString();
        StringBuffer buf = new StringBuffer().append(this.toLeftSqlString(criteria, criteriaQuery));
        if (this.op != null) {
            buf.append(' ').append(this.op).append(' ');
        }
        if (this.quantifier != null) {
            buf.append(this.quantifier).append(' ');
        }
        return buf.append('(').append(sql).append(')').toString();
    }

    public TypedValue[] getTypedValues(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        Type[] types = this.params.getPositionalParameterTypes();
        Object[] values = this.params.getPositionalParameterValues();
        TypedValue[] tv = new TypedValue[types.length];
        int i = 0;
        while (i < types.length) {
            tv[i] = new TypedValue(types[i], values[i], EntityMode.POJO);
            ++i;
        }
        return tv;
    }
}

