/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.List;
import org.hibernate.dialect.SQLFunction;
import org.hibernate.engine.Mapping;
import org.hibernate.type.Type;

public class StandardSQLFunction
implements SQLFunction {
    private Type returnType = null;
    private String name;

    public StandardSQLFunction(String name) {
        this.name = name;
    }

    public StandardSQLFunction(String name, Type typeValue) {
        this.returnType = typeValue;
        this.name = name;
    }

    public Type getReturnType(Type columnType, Mapping mapping) {
        if (this.returnType == null) {
            return columnType;
        }
        return this.returnType;
    }

    public boolean hasArguments() {
        return true;
    }

    public boolean hasParenthesesIfNoArguments() {
        return true;
    }

    public String render(List args) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.name).append('(');
        for (int i = 0; i < args.size(); ++i) {
            buf.append(args.get(i));
            if (i >= args.size() - 1) continue;
            buf.append(", ");
        }
        return buf.append(')').toString();
    }
}

