/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.Mapping;
import org.hibernate.type.Type;

public class NoArgSQLFunction
implements SQLFunction {
    private Type returnType;
    private boolean hasParenthesesIfNoArguments;
    private String name;

    public NoArgSQLFunction(String name, Type returnType) {
        this(name, returnType, true);
    }

    public NoArgSQLFunction(String name, Type returnType, boolean hasParenthesesIfNoArguments) {
        this.returnType = returnType;
        this.hasParenthesesIfNoArguments = hasParenthesesIfNoArguments;
        this.name = name;
    }

    public Type getReturnType(Type columnType, Mapping mapping) throws QueryException {
        return this.returnType;
    }

    public boolean hasArguments() {
        return false;
    }

    public boolean hasParenthesesIfNoArguments() {
        return this.hasParenthesesIfNoArguments;
    }

    public String render(List args) throws QueryException {
        if (args.size() > 0) {
            throw new QueryException("function takes no arguments: " + this.name);
        }
        return this.hasParenthesesIfNoArguments ? String.valueOf(this.name) + "()" : this.name;
    }
}

