/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.Mapping;
import org.hibernate.type.Type;

public class SQLFunctionTemplate
implements SQLFunction {
    private final Type type;
    private final boolean hasArguments;
    private final boolean hasParenthesesIfNoArgs;
    private final String template;
    private final String[] chunks;
    private final int[] paramIndexes;

    public SQLFunctionTemplate(Type type, String template) {
        this(type, template, true);
    }

    public SQLFunctionTemplate(Type type, String template, boolean hasParenthesesIfNoArgs) {
        this.type = type;
        this.template = template;
        ArrayList<String> chunkList = new ArrayList<String>();
        ArrayList<Integer> paramList = new ArrayList<Integer>();
        StringBuffer chunk = new StringBuffer(10);
        StringBuffer index = new StringBuffer(2);
        int i = 0;
        while (i < template.length()) {
            char c = template.charAt(i);
            if (c == '?') {
                chunkList.add(chunk.toString());
                chunk.delete(0, chunk.length());
                while (++i < template.length()) {
                    c = template.charAt(i);
                    if (Character.isDigit(c)) {
                        index.append(c);
                        continue;
                    }
                    chunk.append(c);
                    break;
                }
                paramList.add(new Integer(Integer.parseInt(index.toString()) - 1));
                index.delete(0, index.length());
            } else {
                chunk.append(c);
            }
            ++i;
        }
        if (chunk.length() > 0) {
            chunkList.add(chunk.toString());
        }
        this.chunks = chunkList.toArray(new String[chunkList.size()]);
        this.paramIndexes = new int[paramList.size()];
        i = 0;
        while (i < this.paramIndexes.length) {
            this.paramIndexes[i] = (Integer)paramList.get(i);
            ++i;
        }
        this.hasArguments = this.paramIndexes.length > 0;
        this.hasParenthesesIfNoArgs = hasParenthesesIfNoArgs;
    }

    public String render(List args) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.chunks.length) {
            if (i < this.paramIndexes.length) {
                Object arg;
                Object v0 = arg = this.paramIndexes[i] < args.size() ? args.get(this.paramIndexes[i]) : null;
                if (arg != null) {
                    buf.append(this.chunks[i]).append((Object)arg);
                }
            } else {
                buf.append(this.chunks[i]);
            }
            ++i;
        }
        return buf.toString();
    }

    public Type getReturnType(Type columnType, Mapping mapping) throws QueryException {
        return this.type;
    }

    public boolean hasArguments() {
        return this.hasArguments;
    }

    public boolean hasParenthesesIfNoArguments() {
        return this.hasParenthesesIfNoArgs;
    }

    public String toString() {
        return this.template;
    }
}

