/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.Serializable;
import org.hibernate.collection.CollectionPersister;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.util.ArrayHelper;

public class CollectionCacheEntry
implements Serializable {
    private final Serializable state;

    public Serializable[] getState() {
        return (Serializable[])this.state;
    }

    public CollectionCacheEntry(PersistentCollection collection, CollectionPersister persister) {
        this.state = collection.disassemble(persister);
    }

    CollectionCacheEntry(Serializable state) {
        this.state = state;
    }

    public void assemble(PersistentCollection collection, CollectionPersister persister, Object owner) {
        collection.initializeFromCache(persister, this.state, owner);
    }

    public String toString() {
        return "CollectionCacheEntry" + ArrayHelper.toString(this.getState());
    }
}

