/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.QueryException;
import org.hibernate.ScrollMode;
import org.hibernate.engine.RowSelection;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.pretty.Printer;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;

public final class QueryParameters {
    private static final Log log;
    private Type[] positionalParameterTypes;
    private Object[] positionalParameterValues;
    private Map namedParameters;
    private Map lockModes;
    private RowSelection rowSelection;
    private boolean cacheable;
    private String cacheRegion;
    private String comment;
    private ScrollMode scrollMode;
    private Serializable[] collectionKeys;
    private Object optionalObject;
    private String optionalEntityName;
    private Serializable optionalId;
    private boolean readOnly;
    private boolean callable = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.engine.QueryParameters");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public QueryParameters() {
        this(ArrayHelper.EMPTY_TYPE_ARRAY, ArrayHelper.EMPTY_OBJECT_ARRAY);
    }

    public QueryParameters(Type type, Object value) {
        this(new Type[]{type}, new Object[]{value});
    }

    public QueryParameters(Type[] positionalParameterTypes, Object[] postionalParameterValues, Object optionalObject, String optionalEntityName, Serializable optionalObjectId) {
        this(positionalParameterTypes, postionalParameterValues);
        this.optionalObject = optionalObject;
        this.optionalId = optionalObjectId;
        this.optionalEntityName = optionalEntityName;
    }

    public QueryParameters(Type[] positionalParameterTypes, Object[] postionalParameterValues) {
        this(positionalParameterTypes, postionalParameterValues, null, null, false, null, null);
    }

    public QueryParameters(Type[] positionalParameterTypes, Object[] postionalParameterValues, Serializable[] collectionKeys) {
        this(positionalParameterTypes, postionalParameterValues, null, collectionKeys);
    }

    public QueryParameters(Type[] positionalParameterTypes, Object[] postionalParameterValues, Map namedParameters, Serializable[] collectionKeys) {
        this(positionalParameterTypes, postionalParameterValues, namedParameters, null, null, false, false, null, null, collectionKeys);
    }

    public QueryParameters(Type[] positionalParameterTypes, Object[] positionalParameterValues, Map lockModes, RowSelection rowSelection, boolean cacheable, String cacheRegion, String comment) {
        this(positionalParameterTypes, positionalParameterValues, null, lockModes, rowSelection, false, cacheable, cacheRegion, comment, null);
    }

    public QueryParameters(Type[] positionalParameterTypes, Object[] positionalParameterValues, Map namedParameters, Map lockModes, RowSelection rowSelection, boolean readOnly, boolean cacheable, String cacheRegion, String comment, Serializable[] collectionKeys) {
        this.positionalParameterTypes = positionalParameterTypes;
        this.positionalParameterValues = positionalParameterValues;
        this.namedParameters = namedParameters;
        this.lockModes = lockModes;
        this.rowSelection = rowSelection;
        this.cacheable = cacheable;
        this.cacheRegion = cacheRegion;
        this.comment = comment;
        this.collectionKeys = collectionKeys;
        this.readOnly = readOnly;
    }

    public boolean hasRowSelection() {
        return this.rowSelection != null;
    }

    public Map getNamedParameters() {
        return this.namedParameters;
    }

    public Type[] getPositionalParameterTypes() {
        return this.positionalParameterTypes;
    }

    public Object[] getPositionalParameterValues() {
        return this.positionalParameterValues;
    }

    public RowSelection getRowSelection() {
        return this.rowSelection;
    }

    public void setNamedParameters(Map map) {
        this.namedParameters = map;
    }

    public void setPositionalParameterTypes(Type[] types) {
        this.positionalParameterTypes = types;
    }

    public void setPositionalParameterValues(Object[] objects) {
        this.positionalParameterValues = objects;
    }

    public void setRowSelection(RowSelection selection) {
        this.rowSelection = selection;
    }

    public Map getLockModes() {
        return this.lockModes;
    }

    public void setLockModes(Map map) {
        this.lockModes = map;
    }

    public void traceParameters(SessionFactoryImplementor factory) throws HibernateException {
        Printer print = new Printer(factory);
        if (this.positionalParameterValues.length != 0) {
            log.trace((Object)("parameters: " + print.toString(this.positionalParameterTypes, this.positionalParameterValues)));
        }
        if (this.namedParameters != null) {
            log.trace((Object)("named parameters: " + print.toString(this.namedParameters)));
        }
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public void setCacheable(boolean b) {
        this.cacheable = b;
    }

    public String getCacheRegion() {
        return this.cacheRegion;
    }

    public void setCacheRegion(String cacheRegion) {
        this.cacheRegion = cacheRegion;
    }

    public void validateParameters() throws QueryException {
        int values;
        int types = this.positionalParameterTypes == null ? 0 : this.positionalParameterTypes.length;
        int n = values = this.positionalParameterValues == null ? 0 : this.positionalParameterValues.length;
        if (types != values) {
            throw new QueryException("Number of positional parameter types (" + types + " does not match number of positional parameters (" + values + ")");
        }
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public ScrollMode getScrollMode() {
        return this.scrollMode;
    }

    public void setScrollMode(ScrollMode scrollMode) {
        this.scrollMode = scrollMode;
    }

    public Serializable[] getCollectionKeys() {
        return this.collectionKeys;
    }

    public void setCollectionKeys(Serializable[] collectionKeys) {
        this.collectionKeys = collectionKeys;
    }

    public String getOptionalEntityName() {
        return this.optionalEntityName;
    }

    public void setOptionalEntityName(String optionalEntityName) {
        this.optionalEntityName = optionalEntityName;
    }

    public Serializable getOptionalId() {
        return this.optionalId;
    }

    public void setOptionalId(Serializable optionalId) {
        this.optionalId = optionalId;
    }

    public Object getOptionalObject() {
        return this.optionalObject;
    }

    public void setOptionalObject(Object optionalObject) {
        this.optionalObject = optionalObject;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setCallable(boolean callable) {
        this.callable = callable;
    }

    public boolean isCallable() {
        return this.callable;
    }
}

