/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.action.EntityIdentityInsertAction;
import org.hibernate.action.EntityInsertAction;
import org.hibernate.classic.Lifecycle;
import org.hibernate.classic.Validatable;
import org.hibernate.engine.Cascades;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.ForeignKeys;
import org.hibernate.engine.Nullability;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Versioning;
import org.hibernate.event.AbstractReassociateEventListener;
import org.hibernate.event.SessionEventSource;
import org.hibernate.event.WrapVisitor;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.IdentifierGeneratorFactory;
import org.hibernate.impl.EntityEntry;
import org.hibernate.impl.Status;
import org.hibernate.persister.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;

public abstract class AbstractSaveEventListener
extends AbstractReassociateEventListener {
    protected static final int PERSISTENT = 0;
    protected static final int TRANSIENT = 1;
    protected static final int DETACHED = 2;
    protected static final int DELETED = 3;
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$event$AbstractSaveEventListener == null ? (class$org$hibernate$event$AbstractSaveEventListener = AbstractSaveEventListener.class$("org.hibernate.event.AbstractSaveEventListener")) : class$org$hibernate$event$AbstractSaveEventListener));
    static /* synthetic */ Class class$org$hibernate$event$AbstractSaveEventListener;

    protected Serializable saveWithRequestedId(Object entity, Serializable requestedId, String entityName, Object anything, SessionEventSource source) throws HibernateException {
        return this.performSave(entity, requestedId, source.getEntityPersister(entityName, entity), false, anything, source);
    }

    protected Serializable saveWithGeneratedId(Object entity, String entityName, Object anything, SessionEventSource source) throws HibernateException {
        EntityPersister persister = source.getEntityPersister(entityName, entity);
        Serializable generatedId = persister.getIdentifierGenerator().generate(source, entity);
        if (log.isDebugEnabled()) {
            log.debug((Object)("generated identifier: " + generatedId + ", using strategy: " + persister.getIdentifierGenerator().getClass().getName()));
        }
        if (generatedId == null) {
            throw new IdentifierGenerationException("null id generated for:" + entity.getClass());
        }
        if (generatedId == IdentifierGeneratorFactory.SHORT_CIRCUIT_INDICATOR) {
            return source.getIdentifier(entity);
        }
        if (generatedId == IdentifierGeneratorFactory.POST_INSERT_INDICATOR) {
            return this.performSave(entity, null, persister, true, anything, source);
        }
        return this.performSave(entity, generatedId, persister, false, anything, source);
    }

    protected Serializable performSave(Object entity, Serializable id, EntityPersister persister, boolean useIdentityColumn, Object anything, SessionEventSource source) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("saving " + MessageHelper.infoString((EntityPersister)persister, (Serializable)id)));
        }
        if (!useIdentityColumn) {
            Object old = source.getEntity(new EntityKey(id, persister));
            if (old != null) {
                if (source.getEntry(old).getStatus() == Status.DELETED) {
                    source.forceFlush(source.getEntry(old));
                } else {
                    throw new NonUniqueObjectException(id, persister.getEntityName());
                }
            }
            persister.setIdentifier(entity, id);
        }
        if (persister.implementsLifecycle()) {
            log.debug((Object)"calling onSave()");
            if (((Lifecycle)entity).onSave(source)) {
                log.debug((Object)"insertion vetoed by onSave()");
                return id;
            }
        }
        return this.performSaveOrReplicate(entity, id, persister, useIdentityColumn, anything, source);
    }

    protected Serializable performSaveOrReplicate(Object entity, Serializable id, EntityPersister persister, boolean useIdentityColumn, Object anything, SessionEventSource source) throws HibernateException {
        if (persister.implementsValidatable()) {
            ((Validatable)entity).validate();
        }
        if (useIdentityColumn) {
            log.trace((Object)"executing insertions");
            source.getActionQueue().executeInserts();
        }
        source.addEntry(entity, Status.SAVING, null, null, id, null, LockMode.WRITE, useIdentityColumn, persister, false);
        this.cascadeBeforeSave(source, persister, entity, anything);
        Object[] values = persister.getPropertyValues(entity);
        Type[] types = persister.getPropertyTypes();
        boolean substitute = this.substituteValuesIfNecessary(entity, id, values, persister, source);
        if (persister.hasCollections()) {
            boolean bl = substitute = substitute || this.visitCollections(id, values, types, source);
        }
        if (substitute) {
            persister.setPropertyValues(entity, values);
        }
        TypeFactory.deepCopy((Object[])values, (Type[])types, (boolean[])persister.getPropertyUpdateability(), (Object[])values);
        ForeignKeys.nullifyTransientReferences((Object[])values, (Type[])types, (boolean)useIdentityColumn, (Object)entity, (SessionImplementor)source);
        Nullability.checkNullability((Object[])values, (EntityPersister)persister, (boolean)false, (SessionFactoryImplementor)source.getFactory());
        if (useIdentityColumn) {
            EntityIdentityInsertAction insert = new EntityIdentityInsertAction(values, entity, persister, (SessionImplementor)source);
            source.getActionQueue().execute(insert);
            id = insert.getGeneratedId();
            persister.setIdentifier(entity, id);
            source.checkUniqueness(id, persister, entity);
        }
        Object version = Versioning.getVersion((Object[])values, (EntityPersister)persister);
        source.addEntity(entity, Status.MANAGED, values, id, version, LockMode.WRITE, useIdentityColumn, persister, this.isVersionIncrementDisabled());
        source.removeNonExist(new EntityKey(id, persister));
        if (!useIdentityColumn) {
            source.getActionQueue().addAction(new EntityInsertAction(id, values, entity, version, persister, (SessionImplementor)source));
        }
        this.cascadeAfterSave(source, persister, entity, anything);
        return id;
    }

    protected boolean isVersionIncrementDisabled() {
        return false;
    }

    protected boolean visitCollections(Serializable id, Object[] values, Type[] types, SessionEventSource source) {
        WrapVisitor visitor = new WrapVisitor(source);
        visitor.processValues(values, types);
        return visitor.isSubstitutionRequired();
    }

    protected boolean substituteValuesIfNecessary(Object entity, Serializable id, Object[] values, EntityPersister persister, SessionEventSource source) {
        boolean substitute = source.getInterceptor().onSave(entity, id, values, persister.getPropertyNames(), persister.getPropertyTypes());
        if (persister.isVersioned()) {
            substitute = Versioning.seedVersion(values, persister.getVersionProperty(), persister.getVersionType()) || substitute;
        }
        return substitute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeBeforeSave(SessionEventSource source, EntityPersister persister, Object entity, Object anything) throws HibernateException {
        source.incrementCascadeLevel();
        try {
            Cascades.cascade((SessionImplementor)source, (EntityPersister)persister, (Object)entity, (Cascades.CascadingAction)this.getCascadeAction(), (int)2, (Object)anything);
        }
        finally {
            source.decrementCascadeLevel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeAfterSave(SessionEventSource source, EntityPersister persister, Object entity, Object anything) throws HibernateException {
        source.incrementCascadeLevel();
        try {
            Cascades.cascade((SessionImplementor)source, (EntityPersister)persister, (Object)entity, (Cascades.CascadingAction)this.getCascadeAction(), (int)1, (Object)anything);
        }
        finally {
            source.decrementCascadeLevel();
        }
    }

    protected abstract Cascades.CascadingAction getCascadeAction();

    protected int getEntityState(Object entity, String entityName, EntityEntry entry, SessionEventSource source) {
        if (entry != null) {
            if (entry.getStatus() != Status.DELETED) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("persistent instance of: " + this.getLoggableName(entityName, entity)));
                }
                return 0;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("deleted instance of: " + this.getLoggableName(entityName, entity)));
            }
            return 3;
        }
        if (ForeignKeys.isTransient(entityName, entity, this.getAssumedUnsaved(), source)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("transient instance of: " + this.getLoggableName(entityName, entity)));
            }
            return 1;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("detached instance of: " + this.getLoggableName(entityName, entity)));
        }
        return 2;
    }

    private String getLoggableName(String entityName, Object entity) {
        return entityName == null ? entity.getClass().getName() : entityName;
    }

    protected Boolean getAssumedUnsaved() {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

