/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.StaleObjectStateException;
import org.hibernate.action.EntityUpdateAction;
import org.hibernate.classic.Validatable;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.Nullability;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Versioning;
import org.hibernate.event.AbstractEventListener;
import org.hibernate.event.DirtyCollectionSearchVisitor;
import org.hibernate.event.FlushEntityEvent;
import org.hibernate.event.FlushEntityEventListener;
import org.hibernate.event.FlushVisitor;
import org.hibernate.event.SessionEventSource;
import org.hibernate.event.WrapVisitor;
import org.hibernate.impl.EntityEntry;
import org.hibernate.impl.Status;
import org.hibernate.persister.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.ArrayHelper;

public class DefaultFlushEntityEventListener
extends AbstractEventListener
implements FlushEntityEventListener {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$event$DefaultFlushEntityEventListener == null ? (class$org$hibernate$event$DefaultFlushEntityEventListener = DefaultFlushEntityEventListener.class$("org.hibernate.event.DefaultFlushEntityEventListener")) : class$org$hibernate$event$DefaultFlushEntityEventListener));
    static /* synthetic */ Class class$org$hibernate$event$DefaultFlushEntityEventListener;

    public void onFlushEntity(FlushEntityEvent event) throws HibernateException {
        Object[] values;
        Object entity = event.getEntity();
        EntityEntry entry = event.getEntityEntry();
        SessionEventSource session = event.getSource();
        EntityPersister persister = entry.getPersister();
        Status status = entry.getStatus();
        if (status == Status.DELETED) {
            values = entry.getDeletedState();
        } else if (status == Status.READ_ONLY) {
            values = entry.getLoadedState();
        } else {
            session.checkId(entity, persister, entry.getId());
            values = persister.getPropertyValues(entity);
        }
        Type[] types = persister.getPropertyTypes();
        event.setPropertyValues(values);
        boolean substitute = false;
        if (persister.hasCollections()) {
            WrapVisitor visitor = new WrapVisitor(session);
            visitor.processValues(values, types);
            substitute = visitor.isSubstitutionRequired();
        }
        if (status != Status.READ_ONLY && persister.isMutable()) {
            this.dirtyCheck(event);
        }
        if (this.isUpdateNecessary(event)) {
            if (log.isTraceEnabled()) {
                if (status == Status.DELETED) {
                    log.trace((Object)("Updating deleted entity: " + MessageHelper.infoString((EntityPersister)persister, (Serializable)entry.getId())));
                } else {
                    log.trace((Object)("Updating entity: " + MessageHelper.infoString((EntityPersister)persister, (Serializable)entry.getId())));
                }
            }
            if (!entry.isBeingReplicated()) {
                boolean bl = substitute = substitute || this.invokeInterceptor(event);
            }
            if (status == Status.MANAGED && persister.implementsValidatable()) {
                ((Validatable)entity).validate();
            }
            Object nextVersion = this.getNextVersion(event);
            Object[] updatedState = null;
            if (status == Status.MANAGED) {
                updatedState = new Object[values.length];
                TypeFactory.deepCopy((Object[])values, (Type[])types, (boolean[])persister.getPropertyUpdateability(), (Object[])updatedState);
            }
            int[] dirtyProperties = event.getDirtyProperties();
            if (event.isDirtyCheckPossible() && dirtyProperties == null) {
                if (!event.hasDirtyCollection()) {
                    throw new AssertionFailure("dirty, but no dirty properties");
                }
                dirtyProperties = ArrayHelper.EMPTY_INT_ARRAY;
            }
            Nullability.checkNullability((Object[])values, (EntityPersister)persister, (boolean)true, (SessionFactoryImplementor)session.getFactory());
            session.getActionQueue().addAction(new EntityUpdateAction(entry.getId(), values, dirtyProperties, event.hasDirtyCollection(), entry.getLoadedState(), entry.getVersion(), nextVersion, entity, updatedState, entry.getRowId(), persister, (SessionImplementor)session));
        }
        if (status != Status.DELETED) {
            if (substitute) {
                persister.setPropertyValues(entity, values);
            }
            if (persister.hasCollections()) {
                new FlushVisitor(session, entity).processValues(values, types);
            }
        }
    }

    private boolean invokeInterceptor(FlushEntityEvent event) {
        SessionEventSource session = event.getSource();
        EntityEntry entry = event.getEntityEntry();
        EntityPersister persister = entry.getPersister();
        Object entity = event.getEntity();
        Object[] values = event.getPropertyValues();
        boolean intercepted = session.getInterceptor().onFlushDirty(entity, entry.getId(), values, entry.getLoadedState(), persister.getPropertyNames(), persister.getPropertyTypes());
        if (intercepted && event.isDirtyCheckPossible() && !event.isDirtyCheckHandledByInterceptor()) {
            int[] dirtyProperties = event.hasDatabaseSnapshot() ? persister.findModified(event.getDatabaseSnapshot(), values, entity, session) : persister.findDirty(values, entry.getLoadedState(), entity, session);
            event.setDirtyProperties(dirtyProperties);
        }
        return intercepted;
    }

    private Object getNextVersion(FlushEntityEvent event) throws HibernateException {
        EntityEntry entry = event.getEntityEntry();
        EntityPersister persister = entry.getPersister();
        if (persister.isVersioned()) {
            Object[] values = event.getPropertyValues();
            if (entry.isBeingReplicated()) {
                return Versioning.getVersion((Object[])values, (EntityPersister)persister);
            }
            int[] dirtyProperties = event.getDirtyProperties();
            boolean isVersionIncrementRequired = entry.getStatus() != Status.DELETED && (dirtyProperties == null || Versioning.isVersionIncrementRequired(dirtyProperties, event.hasDirtyCollection(), persister.getPropertyVersionability()));
            Object nextVersion = isVersionIncrementRequired ? Versioning.increment(entry.getVersion(), persister.getVersionType()) : entry.getVersion();
            Versioning.setVersion((Object[])values, (Object)nextVersion, (EntityPersister)persister);
            return nextVersion;
        }
        return null;
    }

    protected final boolean isUpdateNecessary(FlushEntityEvent event) throws HibernateException {
        EntityPersister persister = event.getEntityEntry().getPersister();
        Status status = event.getEntityEntry().getStatus();
        if (status == Status.READ_ONLY || !persister.isMutable()) {
            return false;
        }
        if (!event.isDirtyCheckPossible()) {
            return true;
        }
        int[] dirtyProperties = event.getDirtyProperties();
        if (dirtyProperties != null && dirtyProperties.length != 0) {
            return true;
        }
        if (status == Status.MANAGED && persister.isVersioned() && persister.hasCollections()) {
            DirtyCollectionSearchVisitor visitor = new DirtyCollectionSearchVisitor(event.getSource(), persister.getPropertyVersionability());
            visitor.processValues(event.getPropertyValues(), persister.getPropertyTypes());
            boolean hasDirtyCollections = visitor.wasDirtyCollectionFound();
            event.setHasDirtyCollection(hasDirtyCollections);
            return hasDirtyCollections;
        }
        return false;
    }

    protected void dirtyCheck(FlushEntityEvent event) throws HibernateException {
        boolean cannotDirtyCheck;
        boolean interceptorHandledDirtyCheck;
        Object entity = event.getEntity();
        Object[] values = event.getPropertyValues();
        SessionEventSource session = event.getSource();
        EntityEntry entry = event.getEntityEntry();
        EntityPersister persister = entry.getPersister();
        Serializable id = entry.getId();
        int[] dirtyProperties = session.getInterceptor().findDirty(entity, id, values, entry.getLoadedState(), persister.getPropertyNames(), persister.getPropertyTypes());
        event.setDatabaseSnapshot(null);
        if (dirtyProperties == null) {
            interceptorHandledDirtyCheck = false;
            boolean bl = cannotDirtyCheck = entry.getLoadedState() == null;
            if (!cannotDirtyCheck) {
                dirtyProperties = persister.findDirty(values, entry.getLoadedState(), entity, session);
            } else {
                Object[] databaseSnapshot;
                Object[] objectArray = databaseSnapshot = persister.isSelectBeforeUpdateRequired() ? session.getDatabaseSnapshot(id, persister) : session.getCachedDatabaseSnapshot(new EntityKey(id, persister));
                if (databaseSnapshot != null) {
                    dirtyProperties = persister.findModified(databaseSnapshot, values, entity, session);
                    cannotDirtyCheck = false;
                    event.setDatabaseSnapshot(databaseSnapshot);
                } else if (persister.isSelectBeforeUpdateRequired()) {
                    throw new StaleObjectStateException(persister.getEntityName(), id);
                }
            }
        } else {
            cannotDirtyCheck = false;
            interceptorHandledDirtyCheck = true;
        }
        event.setDirtyProperties(dirtyProperties);
        event.setDirtyCheckHandledByInterceptor(interceptorHandledDirtyCheck);
        event.setDirtyCheckPossible(!cannotDirtyCheck);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

