/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.TransientObjectException;
import org.hibernate.engine.Cascades;
import org.hibernate.engine.ForeignKeys;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.AbstractLockUpgradeEventListener;
import org.hibernate.event.LockEvent;
import org.hibernate.event.LockEventListener;
import org.hibernate.event.SessionEventSource;
import org.hibernate.impl.EntityEntry;
import org.hibernate.persister.EntityPersister;
import org.hibernate.pretty.MessageHelper;

public class DefaultLockEventListener
extends AbstractLockUpgradeEventListener
implements LockEventListener {
    public void onLock(LockEvent event) throws HibernateException {
        Object entity;
        if (event.getObject() == null) {
            throw new NullPointerException("attempted to lock null");
        }
        if (event.getLockMode() == LockMode.WRITE) {
            throw new HibernateException("Invalid lock mode for lock()");
        }
        SessionEventSource source = event.getSource();
        EntityEntry entry = source.getEntry(entity = source.unproxyAndReassociate(event.getObject()));
        if (entry == null) {
            EntityPersister persister = source.getEntityPersister(event.getEntityName(), entity);
            Serializable id = persister.getIdentifier(entity);
            if (!ForeignKeys.isNotTransient(event.getEntityName(), entity, Boolean.FALSE, source)) {
                throw new TransientObjectException("cannot lock an unsaved transient instance: " + MessageHelper.infoString((EntityPersister)persister));
            }
            entry = this.reassociate(event, entity, id, persister);
            this.cascadeOnLock(event, persister, entity);
        }
        this.upgradeLock(entity, entry, event.getLockMode(), source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cascadeOnLock(LockEvent event, EntityPersister persister, Object entity) {
        SessionEventSource source = event.getSource();
        source.incrementCascadeLevel();
        try {
            Cascades.cascade((SessionImplementor)source, (EntityPersister)persister, (Object)entity, (Cascades.CascadingAction)Cascades.ACTION_LOCK, (int)0, (Object)event.getLockMode());
        }
        finally {
            source.decrementCascadeLevel();
        }
    }
}

