/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.StaleObjectStateException;
import org.hibernate.WrongClassException;
import org.hibernate.engine.Cascades;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.AbstractSaveEventListener;
import org.hibernate.event.MergeEvent;
import org.hibernate.event.MergeEventListener;
import org.hibernate.event.SessionEventSource;
import org.hibernate.persister.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.IdentityMap;

public class DefaultMergeEventListener
extends AbstractSaveEventListener
implements MergeEventListener {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$event$DefaultMergeEventListener == null ? (class$org$hibernate$event$DefaultMergeEventListener = DefaultMergeEventListener.class$("org.hibernate.event.DefaultMergeEventListener")) : class$org$hibernate$event$DefaultMergeEventListener));
    private final boolean isSaveOrUpdateCopyListener;
    static /* synthetic */ Class class$org$hibernate$event$DefaultMergeEventListener;

    public DefaultMergeEventListener() {
        this(false);
    }

    public DefaultMergeEventListener(boolean isSaveOrUpdateCopyListener) {
        this.isSaveOrUpdateCopyListener = isSaveOrUpdateCopyListener;
    }

    public Object onMerge(MergeEvent event) throws HibernateException {
        return this.onMerge(event, IdentityMap.instantiate(10));
    }

    public Object onMerge(MergeEvent event, Map copyCache) throws HibernateException {
        Object entity;
        SessionEventSource source = event.getSource();
        Object original = event.getOriginal();
        if (original == null) {
            return null;
        }
        if (original instanceof HibernateProxy) {
            LazyInitializer li = ((HibernateProxy)original).getHibernateLazyInitializer();
            if (li.isUninitialized()) {
                log.trace((Object)"ignoring uninitialized proxy");
                return source.load(li.getEntityName(), li.getIdentifier());
            }
            entity = li.getImplementation();
        } else {
            entity = original;
        }
        if (copyCache.containsKey(entity)) {
            return entity;
        }
        event.setEntity(entity);
        int entityState = this.getEntityState(entity, event.getEntityName(), source.getEntry(entity), source);
        switch (entityState) {
            case 2: {
                return this.entityIsDetached(event, copyCache);
            }
            case 1: {
                return this.entityIsTransient(event, copyCache);
            }
            case 0: {
                return this.entityIsPersistent(event, copyCache);
            }
        }
        throw new ObjectDeletedException("deleted instance passed to merge", null, event.getEntityName());
    }

    protected Object entityIsPersistent(MergeEvent event, Map copyCache) {
        log.trace((Object)"ignoring persistent instance");
        Object entity = event.getEntity();
        EntityPersister persister = event.getSource().getEntityPersister(event.getEntityName(), entity);
        copyCache.put(entity, entity);
        this.cascadeOnMerge(event, persister, entity, copyCache);
        return entity;
    }

    protected Object entityIsTransient(MergeEvent event, Map copyCache) {
        log.trace((Object)"merging transient instance");
        Object entity = event.getEntity();
        SessionEventSource source = event.getSource();
        EntityPersister persister = source.getEntityPersister(event.getEntityName(), entity);
        String entityName = persister.getEntityName();
        Serializable id = persister.hasIdentifierProperty() ? persister.getIdentifier(entity) : null;
        Object copy = persister.instantiate(id);
        copyCache.put(entity, copy);
        this.cascadeOnMerge(event, persister, entity, copyCache);
        this.copyValues(persister, entity, copy, source, copyCache);
        Serializable requestedId = event.getRequestedId();
        if (requestedId == null) {
            this.saveWithGeneratedId(copy, entityName, copyCache, source);
        } else {
            this.saveWithRequestedId(copy, requestedId, entityName, copyCache, source);
        }
        return copy;
    }

    protected Object entityIsDetached(MergeEvent event, Map copyCache) {
        Object result;
        log.trace((Object)"merging detached instance");
        Object entity = event.getEntity();
        SessionEventSource source = event.getSource();
        EntityPersister persister = source.getEntityPersister(event.getEntityName(), entity);
        String entityName = persister.getEntityName();
        Serializable id = event.getRequestedId();
        if (id == null) {
            id = persister.getIdentifier(entity);
        }
        if ((result = source.get(entityName, id)) == null) {
            return this.entityIsTransient(event, copyCache);
        }
        copyCache.put(entity, result);
        Object target = source.unproxy(result);
        if (target == entity) {
            throw new AssertionFailure("entity was not detached");
        }
        if (!source.getEntityName(target).equals(entityName)) {
            throw new WrongClassException("class of the given object did not match class of persistent copy", event.getRequestedId(), entityName);
        }
        if (persister.isVersioned() && !persister.getVersionType().isSame(persister.getVersion(target), persister.getVersion(entity))) {
            throw new StaleObjectStateException(entityName, event.getRequestedId());
        }
        this.cascadeOnMerge(event, persister, entity, copyCache);
        this.copyValues(persister, entity, target, source, copyCache);
        return result;
    }

    protected void copyValues(EntityPersister persister, Object entity, Object target, SessionEventSource source, Map copyCache) {
        Object[] copiedValues = TypeFactory.replace(persister.getPropertyValues(entity), persister.getPropertyValues(target), persister.getPropertyTypes(), source, target, copyCache);
        persister.setPropertyValues(target, copiedValues);
    }

    protected void cascadeOnMerge(MergeEvent event, EntityPersister persister, Object entity, Map copyCache) {
        Cascades.cascade((SessionImplementor)event.getSource(), (EntityPersister)persister, (Object)entity, (Cascades.CascadingAction)this.getCascadeAction(), (int)0, (Object)copyCache);
    }

    protected Cascades.CascadingAction getCascadeAction() {
        return this.isSaveOrUpdateCopyListener ? Cascades.ACTION_SAVE_UPDATE_COPY : Cascades.ACTION_MERGE;
    }

    protected Boolean getAssumedUnsaved() {
        return Boolean.FALSE;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

