/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.ReplicationMode;
import org.hibernate.TransientObjectException;
import org.hibernate.engine.Cascades;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.AbstractSaveEventListener;
import org.hibernate.event.OnReplicateVisitor;
import org.hibernate.event.ReplicateEvent;
import org.hibernate.event.ReplicateEventListener;
import org.hibernate.event.SessionEventSource;
import org.hibernate.impl.Status;
import org.hibernate.persister.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;

public class DefaultReplicateEventListener
extends AbstractSaveEventListener
implements ReplicateEventListener {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$event$DefaultReplicateEventListener == null ? (class$org$hibernate$event$DefaultReplicateEventListener = DefaultReplicateEventListener.class$("org.hibernate.event.DefaultReplicateEventListener")) : class$org$hibernate$event$DefaultReplicateEventListener));
    static /* synthetic */ Class class$org$hibernate$event$DefaultReplicateEventListener;

    public void onReplicate(ReplicateEvent event) throws HibernateException {
        SessionEventSource source = event.getSource();
        if (source.reassociateIfUninitializedProxy(event.getObject())) {
            log.trace((Object)"uninitialized proxy passed to replicate()");
            return;
        }
        Object entity = source.unproxyAndReassociate(event.getObject());
        if (source.isEntryFor(entity)) {
            log.trace((Object)"ignoring persistent instance passed to replicate()");
            return;
        }
        EntityPersister persister = source.getEntityPersister(event.getEntityName(), entity);
        Serializable id = persister.getIdentifier(entity);
        if (id == null) {
            throw new TransientObjectException("transient instance passed to replicate()");
        }
        ReplicationMode replicationMode = event.getReplicationMode();
        Object oldVersion = replicationMode == ReplicationMode.EXCEPTION ? null : persister.getCurrentVersion(id, source);
        if (oldVersion != null) {
            boolean canReplicate;
            if (log.isTraceEnabled()) {
                log.trace((Object)("found existing row for " + MessageHelper.infoString((EntityPersister)persister, (Serializable)id)));
            }
            if (canReplicate = replicationMode.shouldOverwriteCurrentVersion(entity, oldVersion, persister.getVersion(entity), persister.getVersionType())) {
                this.performReplication(entity, id, oldVersion, persister, replicationMode, source);
            } else {
                log.trace((Object)"no need to replicate");
            }
        } else {
            boolean regenerate;
            if (log.isTraceEnabled()) {
                log.trace((Object)("no existing row, replicating new instance " + MessageHelper.infoString((EntityPersister)persister, (Serializable)id)));
            }
            this.performSaveOrReplicate(entity, (regenerate = persister.isIdentifierAssignedByInsert()) ? null : id, persister, regenerate, replicationMode, source);
        }
    }

    protected boolean visitCollections(Serializable id, Object[] values, Type[] types, SessionEventSource source) {
        OnReplicateVisitor visitor = new OnReplicateVisitor(source, id);
        visitor.processValues(values, types);
        return super.visitCollections(id, values, types, source);
    }

    protected boolean substituteValuesIfNecessary(Object entity, Serializable id, Object[] values, EntityPersister persister, SessionEventSource source) {
        return false;
    }

    protected boolean isVersionIncrementDisabled() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void performReplication(Object entity, Serializable id, Object version, EntityPersister persister, ReplicationMode replicationMode, SessionEventSource source) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("replicating changes to " + MessageHelper.infoString((EntityPersister)persister, (Serializable)id)));
        }
        new OnReplicateVisitor(source, id).process(entity, persister);
        source.addEntity(entity, Status.MANAGED, null, id, version, LockMode.NONE, true, persister, true);
        source.incrementCascadeLevel();
        try {
            Cascades.cascade((SessionImplementor)source, (EntityPersister)persister, (Object)entity, (Cascades.CascadingAction)Cascades.ACTION_REPLICATE, (int)0, (Object)replicationMode);
        }
        finally {
            source.decrementCascadeLevel();
        }
    }

    protected Cascades.CascadingAction getCascadeAction() {
        return Cascades.ACTION_REPLICATE;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

