/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.event.DefaultSaveOrUpdateEventListener;
import org.hibernate.event.SaveOrUpdateEvent;
import org.hibernate.impl.EntityEntry;
import org.hibernate.impl.Status;
import org.hibernate.persister.EntityPersister;

public class DefaultUpdateEventListener
extends DefaultSaveOrUpdateEventListener {
    protected Serializable performSaveOrUpdate(SaveOrUpdateEvent event) {
        EntityEntry entry = event.getSource().getEntry(event.getEntity());
        if (entry != null) {
            if (entry.getStatus() == Status.DELETED) {
                throw new ObjectDeletedException("deleted instance passed to update()", null, event.getEntityName());
            }
            return this.entityIsPersistent(event);
        }
        this.entityIsDetached(event);
        return null;
    }

    protected Serializable getUpdateId(Object entity, EntityPersister persister, Serializable requestedId) throws HibernateException {
        if (requestedId == null) {
            return super.getUpdateId(entity, persister, requestedId);
        }
        persister.setIdentifier(entity, requestedId);
        return requestedId;
    }
}

