/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.PersistentObjectException;
import org.hibernate.engine.Cascades;
import org.hibernate.event.CreateEvent;
import org.hibernate.event.CreateEventListener;
import org.hibernate.event.SessionEventSource;
import org.hibernate.event.def.AbstractSaveEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.util.IdentityMap;

public class DefaultCreateEventListener
extends AbstractSaveEventListener
implements CreateEventListener {
    private static final Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.event.def.DefaultCreateEventListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public void onCreate(CreateEvent event) throws HibernateException {
        this.onCreate(event, IdentityMap.instantiate(10));
    }

    public void onCreate(CreateEvent event, Map createCache) throws HibernateException {
        Object entity;
        SessionEventSource source = event.getSource();
        Object object = event.getObject();
        if (object instanceof HibernateProxy) {
            LazyInitializer li = ((HibernateProxy)object).getHibernateLazyInitializer();
            if (li.isUninitialized()) {
                if (li.getSession() == this) {
                    return;
                }
                throw new PersistentObjectException("uninitialized proxy passed to create()");
            }
            entity = li.getImplementation();
        } else {
            entity = object;
        }
        int entityState = this.getEntityState(entity, event.getEntityName(), source.getPersistenceContext().getEntry(entity), source);
        switch (entityState) {
            case 2: {
                throw new PersistentObjectException("detached entity passed to create: " + event.getEntityName());
            }
            case 0: {
                this.entityIsPersistent(event, createCache);
                break;
            }
            case 1: {
                this.entityIsTransient(event, createCache);
                break;
            }
            default: {
                throw new ObjectDeletedException("deleted entity passed to create", null, event.getEntityName());
            }
        }
    }

    protected void entityIsPersistent(CreateEvent event, Map createCache) {
        log.trace((Object)"ignoring persistent instance");
        SessionEventSource source = event.getSource();
        Object entity = source.getPersistenceContext().unproxy(event.getObject());
        EntityPersister persister = source.getEntityPersister(event.getEntityName(), entity);
        if (createCache.put(entity, entity) == null) {
            this.cascadeBeforeSave(source, persister, entity, createCache);
            this.cascadeAfterSave(source, persister, entity, createCache);
        }
    }

    protected void entityIsTransient(CreateEvent event, Map createCache) throws HibernateException {
        log.trace((Object)"saving transient instance");
        SessionEventSource source = event.getSource();
        Object entity = source.getPersistenceContext().unproxy(event.getObject());
        if (createCache.put(entity, entity) == null) {
            this.saveWithGeneratedId(entity, event.getEntityName(), createCache, source);
        }
    }

    protected Cascades.CascadingAction getCascadeAction() {
        return Cascades.ACTION_CREATE;
    }

    protected Boolean getAssumedUnsaved() {
        return Boolean.TRUE;
    }
}

