/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.MappingException;
import org.hibernate.engine.JoinSequence;
import org.hibernate.hql.CollectionProperties;
import org.hibernate.hql.CollectionSubqueryFactory;
import org.hibernate.hql.NameGenerator;
import org.hibernate.hql.ast.FromElement;
import org.hibernate.persister.collection.CollectionPropertyMapping;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.entity.PropertyMapping;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

class FromElementType {
    private static final Log log;
    private FromElement fromElement;
    private EntityType entityType;
    private EntityPersister persister;
    private QueryableCollection queryableCollection;
    private CollectionPropertyMapping collectionPropertyMapping;
    private JoinSequence joinSequence;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.hql.ast.FromElementType");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public FromElementType(FromElement fromElement, EntityPersister persister, EntityType entityType) {
        this.fromElement = fromElement;
        this.persister = persister;
        this.entityType = entityType;
        if (persister != null) {
            fromElement.setText(String.valueOf(((Queryable)persister).getTableName()) + " " + this.getTableAlias());
        }
    }

    private String getTableAlias() {
        return this.fromElement.getTableAlias();
    }

    public EntityPersister getEntityPersister() {
        return this.persister;
    }

    public Type getDataType() {
        if (this.persister == null) {
            if (this.queryableCollection == null) {
                return null;
            }
            return this.queryableCollection.getType();
        }
        return this.entityType;
    }

    public Type getSelectType() {
        if (this.persister == null) {
            if (this.queryableCollection == null) {
                return null;
            }
            return this.queryableCollection.getType();
        }
        return ((Queryable)this.persister).getType();
    }

    public Queryable getQueryable() {
        return this.persister instanceof Queryable ? (Queryable)this.persister : null;
    }

    String renderScalarIdentifierSelect(int i) {
        this.checkInitialized();
        String[] cols = this.getPropertyMapping("id").toColumns(this.getTableAlias(), "id");
        StringBuffer buf = new StringBuffer();
        int j = 0;
        while (j < cols.length) {
            String column = cols[j];
            if (j > 0) {
                buf.append(", ");
            }
            buf.append(column).append(" as ").append(NameGenerator.scalarName(i, j));
            ++j;
        }
        return buf.toString();
    }

    String renderIdentifierSelect(int size, int k) {
        this.checkInitialized();
        if (this.fromElement.getFromClause().isSubQuery()) {
            String[] idColumnNames = this.persister != null ? ((Queryable)this.persister).getIdentifierColumnNames() : new String[]{};
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < idColumnNames.length) {
                buf.append(this.fromElement.getTableAlias()).append('.').append(idColumnNames[i]);
                if (i != idColumnNames.length - 1) {
                    buf.append(", ");
                }
                ++i;
            }
            return buf.toString();
        }
        String fragment = ((Queryable)this.persister).identifierSelectFragment(this.getTableAlias(), FromElementType.getSuffix(size, k));
        return FromElementType.trimLeadingCommaAndSpaces(fragment);
    }

    private static String getSuffix(int size, int k) {
        String suffix = size == 1 ? "" : String.valueOf(Integer.toString(k)) + '_';
        return suffix;
    }

    private void checkInitialized() {
        this.fromElement.checkInitialized();
    }

    String renderPropertySelect(int size, int k) {
        this.checkInitialized();
        String fragment = this.persister != null ? ((Queryable)this.persister).propertySelectFragment(this.getTableAlias(), FromElementType.getSuffix(size, k)) : "";
        return FromElementType.trimLeadingCommaAndSpaces(fragment);
    }

    private static String trimLeadingCommaAndSpaces(String fragment) {
        if (fragment.length() > 0 && fragment.charAt(0) == ',') {
            fragment = fragment.substring(1);
        }
        fragment = fragment.trim();
        return fragment.trim();
    }

    public void setJoinSequence(JoinSequence joinSequence) {
        this.joinSequence = joinSequence;
    }

    public JoinSequence getJoinSequence() {
        if (this.joinSequence != null) {
            return this.joinSequence;
        }
        if (this.persister instanceof Joinable) {
            Joinable joinable = (Joinable)((Object)this.persister);
            return this.fromElement.getSessionFactoryHelper().createJoinSequence().setRoot(joinable, this.getTableAlias());
        }
        return null;
    }

    public void setQueryableCollection(QueryableCollection queryableCollection) {
        if (this.queryableCollection != null) {
            throw new IllegalStateException("QueryableCollection is already defined for " + this + "!");
        }
        this.queryableCollection = queryableCollection;
        if (!queryableCollection.isOneToMany()) {
            this.fromElement.setText(String.valueOf(queryableCollection.getTableName()) + " " + this.getTableAlias());
        }
    }

    public QueryableCollection getQueryableCollection() {
        return this.queryableCollection;
    }

    public Type getPropertyType(String propertyName, String propertyPath) {
        this.checkInitialized();
        Type type = null;
        if (this.persister != null && propertyName.equals(this.persister.getIdentifierPropertyName())) {
            type = this.persister.getIdentifierType();
        } else {
            PropertyMapping mapping = this.getPropertyMapping(propertyName);
            type = mapping.toType(propertyPath);
        }
        if (type == null) {
            throw new MappingException("Property " + propertyName + " does not exist in " + (this.queryableCollection == null ? "class" : "collection") + " " + (this.queryableCollection == null ? this.fromElement.getClassName() : this.queryableCollection.getRole()));
        }
        return type;
    }

    String[] toColumns(String tableAlias, String path, boolean inSelect) {
        this.checkInitialized();
        PropertyMapping propertyMapping = this.getPropertyMapping(path);
        if (!inSelect && this.queryableCollection != null && CollectionProperties.isCollectionProperty(path)) {
            Map enabledFilters = this.fromElement.getWalker().getEnabledFilters();
            String subquery = CollectionSubqueryFactory.createCollectionSubquery(this.joinSequence, enabledFilters, propertyMapping.toColumns(tableAlias, path));
            if (log.isDebugEnabled()) {
                log.debug((Object)("toColumns(" + tableAlias + "," + path + ") : subquery = " + subquery));
            }
            return new String[]{"(" + subquery + ")"};
        }
        return propertyMapping.toColumns(tableAlias, path);
    }

    PropertyMapping getPropertyMapping(String propertyName) {
        this.checkInitialized();
        if (this.queryableCollection == null) {
            return (PropertyMapping)((Object)this.persister);
        }
        if (CollectionProperties.isCollectionProperty(propertyName)) {
            if (this.collectionPropertyMapping == null) {
                this.collectionPropertyMapping = new CollectionPropertyMapping(this.queryableCollection);
            }
            return this.collectionPropertyMapping;
        }
        if (this.queryableCollection.getElementType().isComponentType() && propertyName.equals("id")) {
            return (PropertyMapping)((Object)this.queryableCollection.getOwnerEntityPersister());
        }
        return this.queryableCollection;
    }

    public boolean isCollectionOfValuesOrComponents() {
        if (this.persister == null) {
            if (this.queryableCollection == null) {
                return false;
            }
            return !this.queryableCollection.getElementType().isEntityType();
        }
        return false;
    }

    public boolean isEntity() {
        return this.persister != null;
    }
}

