/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast;

import antlr.SemanticException;
import antlr.collections.AST;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.hql.ast.AbstractSelectExpression;
import org.hibernate.hql.ast.DisplayableNode;
import org.hibernate.hql.ast.FromElement;
import org.hibernate.hql.ast.InitializeableNode;
import org.hibernate.hql.ast.PathNode;
import org.hibernate.hql.ast.ResolvableNode;

abstract class FromReferenceNode
extends AbstractSelectExpression
implements ResolvableNode,
DisplayableNode,
InitializeableNode,
PathNode {
    private static final Log log;
    private FromElement fromElement;
    private boolean resolved = false;
    public static final int ROOT_LEVEL = 0;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.hql.ast.FromReferenceNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    FromReferenceNode() {
    }

    public FromElement getFromElement() {
        return this.fromElement;
    }

    public void setFromElement(FromElement fromElement) {
        this.fromElement = fromElement;
    }

    void resolveFirstChild() throws SemanticException {
    }

    public String getPath() {
        return this.getOriginalText();
    }

    boolean isResolved() {
        return this.resolved;
    }

    void setResolved() {
        this.resolved = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Resolved :  " + this.getPath() + " -> " + this.getText()));
        }
    }

    public String getDisplayText() {
        StringBuffer buf = new StringBuffer();
        buf.append("{").append(this.fromElement == null ? "no fromElement" : this.fromElement.getDisplayText());
        buf.append("}");
        return buf.toString();
    }

    public void recursiveResolve(int level, boolean impliedAtRoot, String classAlias) throws SemanticException {
        AST lhs = this.getFirstChild();
        int nextLevel = level + 1;
        if (lhs != null) {
            FromReferenceNode n = (FromReferenceNode)lhs;
            n.recursiveResolve(nextLevel, impliedAtRoot, null);
        }
        this.resolveFirstChild();
        boolean impliedJoin = true;
        if (level == 0 && !impliedAtRoot) {
            impliedJoin = false;
        }
        this.resolve(true, impliedJoin, classAlias, (AST)this);
    }

    public boolean isReturnableEntity() throws SemanticException {
        return this.fromElement.isEntity() && this.getDataType().isAssociationType();
    }

    public void resolveInFunctionCall(boolean generateJoin, boolean implicitJoin) throws SemanticException {
        this.resolve(generateJoin, implicitJoin);
    }

    public void resolve(boolean generateJoin, boolean implicitJoin) throws SemanticException {
        this.resolve(generateJoin, implicitJoin, null);
    }

    public void resolve(boolean generateJoin, boolean implicitJoin, String classAlias) throws SemanticException {
        this.resolve(generateJoin, implicitJoin, classAlias, null);
    }

    void prepareForDot(String propertyName) throws SemanticException {
    }
}

