/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast;

import antlr.SemanticException;
import antlr.collections.AST;
import org.hibernate.hql.ast.FromElement;
import org.hibernate.hql.ast.FromReferenceNode;
import org.hibernate.hql.ast.SelectExpression;
import org.hibernate.type.Type;

class IdentNode
extends FromReferenceNode
implements SelectExpression {
    IdentNode() {
    }

    public void resolveIndex(AST parent) throws SemanticException {
        throw new UnsupportedOperationException();
    }

    public void resolve(boolean generateJoin, boolean implicitJoin, String classAlias, AST parent) throws SemanticException {
        if (!this.isResolved()) {
            FromElement element = this.getWalker().getCurrentFromClause().getFromElement(this.getText());
            if (element != null) {
                this.setFromElement(element);
                this.setText(element.getIdentityColumn());
                this.setType(121);
            }
            this.setResolved();
        }
    }

    public Type getDataType() {
        Type type = super.getDataType();
        return type == null && this.getFromElement() != null ? this.getFromElement().getDataType() : type;
    }

    public void setScalarColumnText(int i) throws SemanticException {
        this.setText(this.getFromElement().renderScalarIdentifierSelect(i));
    }

    public boolean isReturnableEntity() throws SemanticException {
        return true;
    }

    public String getDisplayText() {
        StringBuffer buf = new StringBuffer();
        if (this.getType() == 121) {
            buf.append("{alias=").append(this.getOriginalText());
            if (this.getFromElement() == null) {
                buf.append(", no from element");
            } else {
                buf.append(", className=").append(this.getFromElement().getClassName());
                buf.append(", tableAlias=").append(this.getFromElement().getTableAlias());
            }
            buf.append("}");
        } else {
            buf.append("{originalText=" + this.getOriginalText()).append("}");
        }
        return buf.toString();
    }
}

