/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast;

import antlr.RecognitionException;
import antlr.collections.AST;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.hql.antlr.SqlGeneratorBase;
import org.hibernate.hql.ast.ErrorCounter;
import org.hibernate.hql.ast.ErrorReporter;
import org.hibernate.hql.ast.MethodNode;
import org.hibernate.hql.ast.ParseErrorHandler;

class SqlGenerator
extends SqlGeneratorBase
implements ErrorReporter {
    private ParseErrorHandler parseErrorHandler;
    private SqlWriter writer = new DefaultWriter();
    private LinkedList outputStack = new LinkedList();

    protected void out(String s) {
        this.writer.clause(s);
    }

    protected void commaBetweenParameters(String comma) {
        this.writer.commaBetweenParameters(comma);
    }

    public void reportError(RecognitionException e) {
        this.parseErrorHandler.reportError(e);
    }

    public void reportError(String s) {
        this.parseErrorHandler.reportError(s);
    }

    public void reportWarning(String s) {
        this.parseErrorHandler.reportWarning(s);
    }

    public ParseErrorHandler getParseErrorHandler() {
        return this.parseErrorHandler;
    }

    public SqlGenerator() {
        this.parseErrorHandler = new ErrorCounter();
    }

    public String getSQL() {
        return this.getStringBuffer().toString();
    }

    protected void optionalSpace() {
        int c = this.getLastChar();
        switch (c) {
            case -1: {
                return;
            }
            case 32: {
                return;
            }
            case 41: {
                return;
            }
            case 40: {
                return;
            }
        }
        this.out(" ");
    }

    protected void beginFunctionTemplate(AST m, AST i) {
        MethodNode methodNode = (MethodNode)m;
        SQLFunction template = methodNode.getSQLFunction();
        if (template == null) {
            super.beginFunctionTemplate(m, i);
        } else {
            this.outputStack.addFirst(this.writer);
            this.writer = new FunctionArguments();
        }
    }

    protected void endFunctionTemplate(AST m) {
        MethodNode methodNode = (MethodNode)m;
        SQLFunction template = methodNode.getSQLFunction();
        if (template == null) {
            super.endFunctionTemplate(m);
        } else {
            FunctionArguments functionArguments = (FunctionArguments)this.writer;
            this.writer = (SqlWriter)this.outputStack.removeFirst();
            this.out(template.render(functionArguments.getArgs()));
        }
    }

    static interface SqlWriter {
        public void clause(String var1);

        public void commaBetweenParameters(String var1);
    }

    class FunctionArguments
    implements SqlWriter {
        private int argInd;
        private final List args = new ArrayList(3);

        FunctionArguments() {
        }

        public void clause(String clause) {
            if (this.argInd == this.args.size()) {
                this.args.add(clause);
            } else {
                this.args.set(this.argInd, this.args.get(this.argInd) + clause);
            }
        }

        public void commaBetweenParameters(String comma) {
            ++this.argInd;
        }

        public List getArgs() {
            return this.args;
        }
    }

    class DefaultWriter
    implements SqlWriter {
        DefaultWriter() {
        }

        public void clause(String clause) {
            SqlGenerator.this.getStringBuffer().append(clause);
        }

        public void commaBetweenParameters(String comma) {
            SqlGenerator.this.getStringBuffer().append(comma);
        }
    }
}

