/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.id.IdentifierGeneratorFactory;
import org.hibernate.id.PostInsertIdentifierGenerator;
import org.hibernate.id.PostInsertIdentityPersister;
import org.hibernate.pretty.MessageHelper;

public abstract class AbstractPostInsertGenerator
implements PostInsertIdentifierGenerator {
    public Serializable generate(SessionImplementor s, Object obj) {
        return IdentifierGeneratorFactory.POST_INSERT_INDICATOR;
    }

    protected abstract String getSQL(PostInsertIdentityPersister var1);

    protected void bindParameters(SessionImplementor session, PreparedStatement ps, Object object, PostInsertIdentityPersister persister) throws SQLException {
    }

    protected abstract Serializable getResult(SessionImplementor var1, ResultSet var2, Object var3, PostInsertIdentityPersister var4) throws SQLException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Serializable getGenerated(SessionImplementor session, Object object, PostInsertIdentityPersister persister) throws HibernateException {
        String sql = this.getSQL(persister);
        try {
            Serializable serializable;
            PreparedStatement idSelect = session.getBatcher().prepareStatement(sql);
            try {
                this.bindParameters(session, idSelect, object, persister);
                ResultSet rs = idSelect.executeQuery();
                try {
                    serializable = this.getResult(session, rs, object, persister);
                    Object var7_9 = null;
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    rs.close();
                    throw throwable;
                }
                rs.close();
                Object var10_11 = null;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                session.getBatcher().closeStatement(idSelect);
                throw throwable;
            }
            session.getBatcher().closeStatement(idSelect);
            return serializable;
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(session.getFactory().getSQLExceptionConverter(), sqle, "could not insert: " + MessageHelper.infoString(persister), sql);
        }
    }
}

