/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jdbc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.cfg.Settings;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.jdbc.Batcher;
import org.hibernate.transaction.CacheSynchronization;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.util.JTAHelper;

public class JDBCContext
implements Serializable {
    private static final Log log;
    private Context owner;
    private transient Batcher batcher;
    private transient Connection connection;
    private boolean autoClose;
    private transient boolean connect;
    private boolean isTransactionCallbackRegistered;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.jdbc.JDBCContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public JDBCContext(Context owner, Connection connection, boolean autoClose) {
        boolean registerSynchronization;
        this.owner = owner;
        this.connection = connection;
        this.connect = connection == null;
        this.autoClose = autoClose;
        Settings settings = owner.getFactory().getSettings();
        this.batcher = settings.getBatcherFactory().createBatcher(this);
        boolean bl = registerSynchronization = settings.isAutoCloseSessionEnabled() || settings.isFlushBeforeCompletionEnabled();
        if (registerSynchronization) {
            this.registerSynchronizationIfPossible();
        }
    }

    public SessionFactoryImplementor getFactory() {
        return this.owner.getFactory();
    }

    public Batcher getBatcher() {
        return this.batcher;
    }

    public boolean isConnected() {
        return this.connection != null || this.connect;
    }

    public Connection release() {
        if (this.connection == null) {
            this.connect = false;
            return null;
        }
        return this.disconnect();
    }

    public Connection connection() throws HibernateException {
        if (this.connection == null) {
            if (this.connect) {
                this.connect();
            } else {
                if (this.owner.isOpen()) {
                    throw new HibernateException("Session is currently disconnected");
                }
                throw new HibernateException("Session is closed");
            }
        }
        return this.connection;
    }

    public boolean registerCallbackIfNecessary() {
        if (this.isTransactionCallbackRegistered) {
            return false;
        }
        this.isTransactionCallbackRegistered = true;
        return true;
    }

    public boolean registerSynchronizationIfPossible() {
        if (this.isTransactionCallbackRegistered) {
            return true;
        }
        TransactionManager tm = this.owner.getFactory().getTransactionManager();
        if (tm == null) {
            return false;
        }
        try {
            javax.transaction.Transaction tx = tm.getTransaction();
            if (this.isJTATransactionInProgress(tx)) {
                tx.registerSynchronization((Synchronization)new CacheSynchronization(this.owner, this, tx, null));
                this.isTransactionCallbackRegistered = true;
                log.debug((Object)"successfully registered Synchronization");
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new TransactionException("could not register synchronization with JTA TransactionManager", e);
        }
    }

    private boolean isJTATransactionInProgress(javax.transaction.Transaction tx) throws SystemException {
        return tx != null && JTAHelper.isInProgress(tx.getStatus());
    }

    private void connect() throws HibernateException {
        this.connection = this.batcher.openConnection();
        this.connect = false;
        if (!this.isTransactionCallbackRegistered) {
            this.registerSynchronizationIfPossible();
        }
        if (this.owner.getFactory().getStatistics().isStatisticsEnabled()) {
            this.owner.getFactory().getStatisticsImplementor().connect();
        }
    }

    public Connection disconnect() throws HibernateException {
        Connection c;
        block9: {
            block8: {
                try {
                    if (!this.connect) break block8;
                    this.connect = false;
                    Connection connection = null;
                    Object var2_4 = null;
                    if (!this.isTransactionCallbackRegistered) {
                        this.afterTransactionCompletion(false, null);
                    }
                    return connection;
                }
                catch (Throwable throwable) {
                    block10: {
                        Object var2_7 = null;
                        if (this.isTransactionCallbackRegistered) break block10;
                        this.afterTransactionCompletion(false, null);
                    }
                    throw throwable;
                }
            }
            if (this.connection == null) {
                throw new HibernateException("Already disconnected");
            }
            this.batcher.closeStatements();
            c = this.connection;
            this.connection = null;
            if (!this.autoClose) break block9;
            this.batcher.closeConnection(c);
            Connection connection = null;
            Object var2_5 = null;
            if (!this.isTransactionCallbackRegistered) {
                this.afterTransactionCompletion(false, null);
            }
            return connection;
        }
        Connection connection = c;
        Object var2_6 = null;
        if (!this.isTransactionCallbackRegistered) {
            this.afterTransactionCompletion(false, null);
        }
        return connection;
    }

    public void reconnect() throws HibernateException {
        if (this.isConnected()) {
            throw new HibernateException("Already connected");
        }
        if (!this.owner.isOpen()) {
            throw new HibernateException("Session is closed");
        }
        log.debug((Object)"reconnecting session");
        this.connect = true;
    }

    public void reconnect(Connection conn) throws HibernateException {
        if (this.isConnected()) {
            throw new HibernateException("Already connected");
        }
        this.connection = conn;
    }

    public Transaction beginTransaction() throws HibernateException {
        return this.owner.getFactory().getSettings().getTransactionFactory().beginTransaction(this, this.owner);
    }

    public void beforeTransactionCompletion(Transaction tx) {
        log.trace((Object)"before transaction completion");
        this.owner.beforeTransactionCompletion(tx);
    }

    public void afterTransactionCompletion(boolean success, Transaction tx) {
        log.trace((Object)"after transaction completion");
        if (this.getFactory().getStatistics().isStatisticsEnabled()) {
            this.getFactory().getStatisticsImplementor().endTransaction(success);
        }
        this.isTransactionCallbackRegistered = false;
        this.owner.afterTransactionCompletion(success, tx);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        if (this.isConnected()) {
            throw new IllegalStateException("Cannot serialize a JDBCContext while connected");
        }
        log.trace((Object)"Serializing JDBCContext");
        oos.writeObject(this.owner);
        oos.defaultWriteObject();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        log.trace((Object)"Deserializing JDBCContext");
        this.owner = (Context)ois.readObject();
        ois.defaultReadObject();
        this.batcher = this.owner.getFactory().getSettings().getBatcherFactory().createBatcher(this);
    }

    protected void finalize() throws Throwable {
        log.debug((Object)"running Session.finalize()");
        if (this.isTransactionCallbackRegistered) {
            log.warn((Object)"afterTransactionCompletion() was never called");
        }
        if (this.connection != null) {
            if (this.connection.isClosed()) {
                log.warn((Object)"finalizing unclosed session with closed connection");
            } else {
                log.warn((Object)"unclosed connection, forgot to call close() on your session?");
                if (this.autoClose) {
                    this.connection.close();
                }
            }
        }
    }

    public static interface Context
    extends TransactionFactory.Context {
        public void beforeTransactionCompletion(Transaction var1);

        public void afterTransactionCompletion(boolean var1, Transaction var2);
    }
}

