/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.loader.EntityLoader;
import org.hibernate.loader.Loader;
import org.hibernate.loader.UniqueEntityLoader;
import org.hibernate.persister.EntityPersister;
import org.hibernate.persister.OuterJoinLoadable;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;

public class BatchingEntityLoader
implements UniqueEntityLoader {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$loader$BatchingEntityLoader == null ? (class$org$hibernate$loader$BatchingEntityLoader = BatchingEntityLoader.class$("org.hibernate.loader.BatchingEntityLoader")) : class$org$hibernate$loader$BatchingEntityLoader));
    private final Loader[] loaders;
    private final int[] batchSizes;
    private final EntityPersister persister;
    private final Type idType;
    static /* synthetic */ Class class$org$hibernate$loader$BatchingEntityLoader;

    public BatchingEntityLoader(EntityPersister persister, int[] batchSizes, Loader[] loaders) {
        this.batchSizes = batchSizes;
        this.loaders = loaders;
        this.persister = persister;
        this.idType = persister.getIdentifierType();
    }

    private Object getObjectFromList(List results, Serializable id, SessionImplementor session) {
        Iterator iter = results.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!this.idType.isEqual(id, session.getEntityIdentifier(obj))) continue;
            return obj;
        }
        return null;
    }

    public Object load(Serializable id, Object optionalObject, SessionImplementor session) throws HibernateException {
        Serializable[] batch = session.getEntityBatch(this.persister.getEntityName(), id, this.batchSizes[0]);
        for (int i = 0; i < this.batchSizes.length - 1; ++i) {
            int smallBatchSize = this.batchSizes[i];
            if (batch[smallBatchSize - 1] == null) continue;
            Serializable[] smallBatch = new Serializable[smallBatchSize];
            System.arraycopy(batch, 0, smallBatch, 0, smallBatchSize);
            List results = this.loaders[i].loadEntityBatch(session, smallBatch, this.idType, optionalObject, this.persister.getEntityName(), id);
            log.debug((Object)"done batch load");
            return this.getObjectFromList(results, id, session);
        }
        Object result = ((UniqueEntityLoader)((Object)this.loaders[this.batchSizes.length - 1])).load(id, optionalObject, session);
        log.debug((Object)"done unique load");
        return result;
    }

    public static UniqueEntityLoader createBatchingEntityLoader(OuterJoinLoadable persister, int maxBatchSize, LockMode lockMode, SessionFactoryImplementor factory, Map enabledFilters) throws MappingException {
        if (maxBatchSize > 1) {
            int[] batchSizesToCreate = ArrayHelper.getBatchSizes(maxBatchSize);
            Loader[] loadersToCreate = new Loader[batchSizesToCreate.length];
            for (int i = 0; i < batchSizesToCreate.length; ++i) {
                loadersToCreate[i] = new EntityLoader(persister, batchSizesToCreate[i], lockMode, factory, enabledFilters);
            }
            return new BatchingEntityLoader(persister, batchSizesToCreate, loadersToCreate);
        }
        return new EntityLoader(persister, lockMode, factory, enabledFilters);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

