/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.ScrollableResults;
import org.hibernate.collection.CollectionPersister;
import org.hibernate.collection.QueryableCollection;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SQLQueryCollectionReturn;
import org.hibernate.engine.SQLQueryReturn;
import org.hibernate.engine.SQLQueryRoleReturn;
import org.hibernate.engine.SQLQueryRootReturn;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.TypedValue;
import org.hibernate.loader.Loader;
import org.hibernate.persister.EntityPersister;
import org.hibernate.persister.Loadable;
import org.hibernate.persister.SQLLoadable;
import org.hibernate.type.AssociationType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.StringHelper;

public class SQLLoader
extends Loader {
    private final String sqlQuery;
    private final String sql;
    private final String[] aliases;
    private final SQLLoadable[] classPersisters;
    private final int[] owners;
    private final LockMode[] lockModeArray;
    private final Map alias2Persister;
    private QueryableCollection collectionPersister;
    private String collectionAlias;
    private String collectionOwnerAlias;
    private int collectionOwner;
    private final Set querySpaces = new HashSet();
    private final Type[] resultTypes;
    private final String[] suffixes;
    private int parameterCount = 0;
    private final Map namedParameters = new HashMap();

    protected String getSQLString() {
        return this.sql;
    }

    protected String[] getAliases() {
        return this.aliases;
    }

    protected Loadable[] getEntityPersisters() {
        return this.classPersisters;
    }

    protected int[] getOwners() {
        return this.owners;
    }

    protected LockMode[] getLockModes(Map lockModes) {
        return this.lockModeArray;
    }

    protected CollectionPersister getCollectionPersister() {
        return this.collectionPersister;
    }

    protected int getCollectionOwner() {
        return this.collectionOwner;
    }

    protected String[] getSuffixes() {
        return this.suffixes;
    }

    public Set getQuerySpaces() {
        return this.querySpaces;
    }

    public SQLLoader(SQLQueryReturn[] queryReturns, String sqlQuery, Collection additionalQuerySpaces, SessionFactoryImplementor factory) throws HibernateException {
        super(factory);
        int indx;
        this.sqlQuery = sqlQuery;
        boolean isCollectionInitializer = false;
        ArrayList aliasList = new ArrayList();
        ArrayList classPersisterList = new ArrayList();
        ArrayList lockModeList = new ArrayList();
        this.alias2Persister = new HashMap(queryReturns.length);
        HashMap<String, SQLQueryReturn> alias2Return = new HashMap<String, SQLQueryReturn>(queryReturns.length);
        HashMap<String, String> alias2OwnerAlias = new HashMap<String, String>();
        int max = queryReturns.length;
        for (indx = 0; indx < max; ++indx) {
            alias2Return.put(queryReturns[indx].getAlias(), queryReturns[indx]);
            if (queryReturns[indx] instanceof SQLQueryRoleReturn) {
                SQLQueryRoleReturn roleReturn = (SQLQueryRoleReturn)queryReturns[indx];
                alias2OwnerAlias.put(roleReturn.getAlias(), roleReturn.getOwnerAlias());
                continue;
            }
            if (!(queryReturns[indx] instanceof SQLQueryCollectionReturn)) continue;
            isCollectionInitializer = true;
        }
        max = queryReturns.length;
        for (indx = 0; indx < max; ++indx) {
            this.processReturn(queryReturns[indx], aliasList, classPersisterList, lockModeList, this.alias2Persister, alias2Return, isCollectionInitializer);
        }
        this.aliases = ArrayHelper.toStringArray(aliasList);
        this.classPersisters = classPersisterList.toArray(new SQLLoadable[0]);
        this.lockModeArray = lockModeList.toArray(new LockMode[0]);
        ArrayList<Type> resultTypeList = new ArrayList<Type>();
        for (int i = 0; i < this.classPersisters.length; ++i) {
            SQLLoadable persister = this.classPersisters[i];
            this.alias2Persister.put(this.aliases[i], persister);
            ArrayHelper.addAll(this.querySpaces, persister.getQuerySpaces());
            resultTypeList.add(persister.getType());
        }
        if (additionalQuerySpaces != null) {
            this.querySpaces.addAll(additionalQuerySpaces);
        }
        this.resultTypes = ArrayHelper.toTypeArray(resultTypeList);
        int[] ownersArray = new int[this.classPersisters.length];
        int max2 = this.aliases.length;
        for (int indx2 = 0; indx2 < max2; ++indx2) {
            String ownerAlias = (String)alias2OwnerAlias.get(this.aliases[indx2]);
            ownersArray[indx2] = StringHelper.isNotEmpty(ownerAlias) ? this.getPersisterIndex(ownerAlias) : -1;
        }
        if (ArrayHelper.isAllNegative(ownersArray)) {
            ownersArray = null;
        }
        this.owners = ownersArray;
        if (!isCollectionInitializer && StringHelper.isNotEmpty(this.collectionOwnerAlias)) {
            this.collectionOwner = this.getPersisterIndex(this.collectionOwnerAlias);
        }
        this.suffixes = SQLLoader.generateSuffixes((int)this.classPersisters.length);
        this.sql = this.substituteParams(this.substituteBrackets(sqlQuery));
        this.postInstantiate();
    }

    private void processReturn(SQLQueryReturn rtn, List aliases, List persisters, List lockModes, Map alias2Persister, Map alias2Return, boolean isCollectionInitializer) {
        if (rtn instanceof SQLQueryRootReturn) {
            this.processRootReturn((SQLQueryRootReturn)rtn, aliases, persisters, lockModes, alias2Persister);
        } else if (rtn instanceof SQLQueryCollectionReturn) {
            this.processCollectionReturn((SQLQueryCollectionReturn)rtn);
        } else {
            this.processRoleReturn((SQLQueryRoleReturn)rtn, aliases, persisters, lockModes, alias2Persister, alias2Return, isCollectionInitializer);
        }
    }

    private void processRootReturn(SQLQueryRootReturn rootReturn, List aliases, List persisters, List lockModes, Map alias2Persister) {
        if (alias2Persister.containsKey(rootReturn.getAlias())) {
            return;
        }
        SQLLoadable persister = this.getSQLLoadable(rootReturn.getReturnClass().getName());
        aliases.add(rootReturn.getAlias());
        persisters.add(persister);
        alias2Persister.put(rootReturn.getAlias(), persister);
        lockModes.add(rootReturn.getLockMode());
    }

    private void processCollectionReturn(SQLQueryCollectionReturn collectionReturn) {
        this.collectionOwner = -1;
        String collectionRole = collectionReturn.getOwnerClass().getName() + "." + collectionReturn.getOwnerProperty();
        this.collectionPersister = (QueryableCollection)this.getFactory().getCollectionPersister(collectionRole);
        this.collectionAlias = collectionReturn.getAlias();
    }

    private void processRoleReturn(SQLQueryRoleReturn roleReturn, List aliases, List persisters, List lockModes, Map alias2persister, Map returnsByAlias, boolean isCollectionInitializer) {
        SQLLoadable ownerPersister;
        Type returnType;
        if (alias2persister.containsKey(roleReturn.getAlias()) || roleReturn.getAlias().equals(this.collectionAlias)) {
            return;
        }
        String ownerAlias = roleReturn.getOwnerAlias();
        if (!returnsByAlias.containsKey(ownerAlias)) {
            throw new HibernateException("Owner alias [" + ownerAlias + "] is unknown for alias [" + roleReturn.getAlias() + "]");
        }
        if (!alias2persister.containsKey(ownerAlias)) {
            SQLQueryReturn ownerReturn = (SQLQueryReturn)returnsByAlias.get(ownerAlias);
            this.processReturn(ownerReturn, aliases, persisters, lockModes, alias2persister, returnsByAlias, isCollectionInitializer);
        }
        if ((returnType = (ownerPersister = (SQLLoadable)alias2persister.get(ownerAlias)).getPropertyType(roleReturn.getOwnerProperty())).isPersistentCollectionType()) {
            if (isCollectionInitializer) {
                throw new HibernateException("A sql query cannot name both a collection to be initialized and a collection to be fetched");
            }
            if (this.collectionAlias != null) {
                throw new HibernateException("Only one colection role return can be specified per sql-query");
            }
            String collectionRole = ownerPersister.getMappedClass().getName() + "." + roleReturn.getOwnerProperty();
            this.collectionOwnerAlias = roleReturn.getOwnerAlias();
            this.collectionPersister = (QueryableCollection)this.getFactory().getCollectionPersister(collectionRole);
            this.collectionAlias = roleReturn.getAlias();
        } else if (returnType.isAssociationType()) {
            String returnEntityName = ((AssociationType)returnType).getAssociatedEntityName(this.getFactory());
            SQLLoadable persister = this.getSQLLoadable(returnEntityName);
            aliases.add(roleReturn.getAlias());
            persisters.add(persister);
            lockModes.add(roleReturn.getLockMode());
            alias2persister.put(roleReturn.getAlias(), persister);
        } else if (returnType.isEntityType()) {
            String returnEntityName = ((EntityType)returnType).getAssociatedEntityName();
            SQLLoadable persister = (SQLLoadable)this.getFactory().getEntityPersister(returnEntityName);
            aliases.add(roleReturn.getAlias());
            persisters.add(persister);
            lockModes.add(roleReturn.getLockMode());
            alias2persister.put(roleReturn.getAlias(), persister);
        }
    }

    private SQLLoadable getSQLLoadable(String entityName) throws MappingException {
        EntityPersister persister = this.getFactory().getEntityPersister(entityName);
        if (!(persister instanceof SQLLoadable)) {
            throw new MappingException("class persister is not SQLLoadable: " + entityName);
        }
        return (SQLLoadable)persister;
    }

    public List list(SessionImplementor session, QueryParameters queryParameters) throws HibernateException {
        return this.list(session, queryParameters, this.querySpaces, this.resultTypes);
    }

    protected Object getResultColumnOrRow(Object[] row, ResultSet rs, SessionImplementor session) throws SQLException, HibernateException {
        if (this.classPersisters.length == 1) {
            return row[row.length - 1];
        }
        return row;
    }

    public String substituteBrackets(String sqlString) throws QueryException {
        StringBuffer result = new StringBuffer(sqlString.length() + 20);
        int curr = 0;
        while (curr < sqlString.length()) {
            int left = sqlString.indexOf(123, curr);
            if (left < 0) {
                result.append(sqlString.substring(curr));
                break;
            }
            result.append(sqlString.substring(curr, left));
            int right = sqlString.indexOf(125, left + 1);
            if (right < 0) {
                throw new QueryException("Unmatched braces for alias path", sqlString);
            }
            String aliasPath = sqlString.substring(left + 1, right);
            int firstDot = aliasPath.indexOf(46);
            if (firstDot == -1) {
                if (this.getPersisterByResultAlias(aliasPath) != null) {
                    result.append(aliasPath);
                } else {
                    result.append('{').append(aliasPath).append('}');
                }
            } else {
                String aliasName = aliasPath.substring(0, firstDot);
                if (aliasName.equals(this.collectionAlias)) {
                    result.append(this.collectionPersister.selectFragment(aliasName));
                } else {
                    SQLLoadable currentPersister = this.getPersisterByResultAlias(aliasName);
                    if (currentPersister == null) {
                        result.append('{').append(aliasPath).append('}');
                    } else {
                        String propertyName = aliasPath.substring(firstDot + 1);
                        this.resolveProperties(aliasName, propertyName, result, currentPersister);
                    }
                }
            }
            curr = right + 1;
        }
        return result.toString();
    }

    private void resolveProperties(String aliasName, String propertyName, StringBuffer result, SQLLoadable currentPersister) {
        int currentPersisterIndex = this.getPersisterIndex(aliasName);
        if (!aliasName.equals(this.aliases[currentPersisterIndex])) {
            throw new QueryException("Alias [" + aliasName + "] does not correspond to return alias " + this.aliases[currentPersisterIndex], this.sqlQuery);
        }
        if ("*".equals(propertyName)) {
            result.append(currentPersister.selectFragment(aliasName, this.suffixes[currentPersisterIndex]));
        } else {
            String[] columnAliases = currentPersister.getSubclassPropertyColumnAliases(propertyName, this.suffixes[currentPersisterIndex]);
            if (columnAliases == null || columnAliases.length == 0) {
                throw new QueryException("No column name found for property [" + propertyName + "]", this.sqlQuery);
            }
            if (columnAliases.length != 1) {
                throw new QueryException("SQL queries only support properties mapped to a single column - property [" + propertyName + "] is mapped to " + columnAliases.length + " columns.", this.sqlQuery);
            }
            result.append(columnAliases[0]);
        }
    }

    private String substituteParams(String sqlString) {
        StringBuffer result = new StringBuffer(sqlString.length());
        int curr = 0;
        while (curr < sqlString.length()) {
            int left = sqlString.indexOf(":", curr);
            if (left < 0) {
                result.append(sqlString.substring(curr));
                break;
            }
            result.append(sqlString.substring(curr, left));
            int right = StringHelper.firstIndexOfChar(sqlString, " \n\r\f\t,()=<>&|+-=/*'^![]#~\\", left + 1);
            boolean foundSeperator = right > 0;
            int chopLocation = -1;
            chopLocation = right < 0 ? sqlString.length() : right;
            String param = sqlString.substring(left + 1, chopLocation);
            this.addNamedParameter(param);
            result.append("?");
            if (!foundSeperator) break;
            result.append(sqlString.charAt(right));
            curr = right + 1;
        }
        return result.toString();
    }

    private int getPersisterIndex(String aliasName) {
        for (int i = 0; i < this.aliases.length; ++i) {
            if (!aliasName.equals(this.aliases[i])) continue;
            return i;
        }
        return -1;
    }

    private SQLLoadable getPersisterByResultAlias(String aliasName) {
        return (SQLLoadable)this.alias2Persister.get(aliasName);
    }

    void addNamedParameter(String name) {
        Integer loc = new Integer(this.parameterCount++);
        Object o = this.namedParameters.get(name);
        if (o == null) {
            this.namedParameters.put(name, loc);
        } else if (o instanceof Integer) {
            ArrayList<Object> list = new ArrayList<Object>(4);
            list.add(o);
            list.add(loc);
            this.namedParameters.put(name, list);
        } else {
            ((List)o).add(loc);
        }
    }

    protected int[] getNamedParameterLocs(String name) throws QueryException {
        Object o = this.namedParameters.get(name);
        if (o == null) {
            QueryException qe = new QueryException("Named parameter does not appear in Query: " + name, this.sqlQuery);
            throw qe;
        }
        if (o instanceof Integer) {
            return new int[]{(Integer)o};
        }
        return ArrayHelper.toIntArray((List)o);
    }

    protected int bindNamedParameters(PreparedStatement ps, Map namedParams, int start, SessionImplementor session) throws SQLException, HibernateException {
        if (namedParams != null) {
            Iterator iter = namedParams.entrySet().iterator();
            int result = 0;
            while (iter.hasNext()) {
                Map.Entry e = iter.next();
                String name = (String)e.getKey();
                TypedValue typedval = (TypedValue)e.getValue();
                int[] locs = this.getNamedParameterLocs(name);
                for (int i = 0; i < locs.length; ++i) {
                    typedval.getType().nullSafeSet(ps, typedval.getValue(), locs[i] + start, session);
                }
                result += locs.length;
            }
            return result;
        }
        return 0;
    }

    public ScrollableResults scroll(QueryParameters queryParameters, SessionImplementor session) throws HibernateException {
        return this.scroll(queryParameters, this.resultTypes, null, session);
    }

    protected String getQueryIdentifier() {
        return this.sqlQuery;
    }

    public String toString() {
        return this.sqlQuery;
    }
}

